/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public final class Biguint
implements Streamable {
    private static final int LENGTH_SIZE = 2;
    private BigInteger val;
    private byte[] valBytes;

    public Biguint() {
        this.val = BigInteger.valueOf(0L);
    }

    public Biguint(int n) {
        this.val = BigInteger.valueOf(n);
    }

    public Biguint(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public Biguint(BigInteger bigInteger) {
        this.val = bigInteger;
    }

    public Biguint(byte[] byArray) {
        this.val = new BigInteger(1, byArray);
        if (byArray != null) {
            this.valBytes = (byte[])byArray.clone();
        }
    }

    public BigInteger getValue() {
        return this.val;
    }

    public void input(InputStream inputStream) throws IOException {
        short s = Utils.inputShort((InputStream)inputStream);
        this.valBytes = new byte[s];
        Utils.inputByteArray((byte[])this.valBytes, (InputStream)inputStream);
        this.val = new BigInteger(1, this.valBytes);
    }

    public int length() {
        if (this.valBytes == null) {
            this.makeValBytes();
        }
        return 2 + this.valBytes.length;
    }

    public void makeRandom(RandomBitsSource randomBitsSource, int n) {
        this.val = randomBitsSource.randomBigInteger(n);
    }

    private void makeValBytes() {
        this.valBytes = Utils.toByteArray((BigInteger)this.val);
    }

    public void output(OutputStream outputStream) throws IOException {
        if (this.valBytes == null) {
            this.makeValBytes();
        }
        Utils.outputShort((int)((short)(this.length() - 2)), (OutputStream)outputStream);
        outputStream.write(this.valBytes);
    }

    public byte[] toByteArray() {
        if (this.valBytes == null) {
            this.makeValBytes();
        }
        return this.valBytes;
    }

    public String toString() {
        return this.val.toString();
    }
}

