/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.ASN1.ASN1Sequence;
import com.phaos.SSL.HandshakeBody;
import com.phaos.cert.X500Name;
import com.phaos.utils.ArrayVector;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CertificateRequest
extends HandshakeBody {
    private static final int handshakeType = 13;
    public static final int rsa_sign = 1;
    public static final int dss_sign = 2;
    public static final int rsa_fixed_dh = 3;
    public static final int dss_fixed_dh = 4;
    public static final int rsa_ephemeral_dh = 5;
    public static final int dss_ephemeral_dh = 6;
    public static final int fortezza_dms = 20;
    private byte[] certTypes;
    private X500Name[] CAs;

    public CertificateRequest(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public CertificateRequest(byte[] byArray, X500Name[] x500NameArray) {
        this.certTypes = byArray;
        this.CAs = x500NameArray;
    }

    private int CAsLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.CAs.length) {
            n += this.nameLength(this.CAs[n2]);
            ++n2;
        }
        return n;
    }

    public X500Name[] cas() {
        return this.CAs;
    }

    public byte[] getCertTypes() {
        return this.certTypes;
    }

    public int getHandshakeType() {
        return 13;
    }

    public void input(InputStream inputStream) throws IOException {
        this.certTypes = new byte[Utils.inputByte((InputStream)inputStream) & 0xFF];
        Utils.inputByteArray((byte[])this.certTypes, (InputStream)inputStream);
        ArrayVector arrayVector = new ArrayVector();
        int n = Utils.inputShort((InputStream)inputStream) & 0xFFFF;
        while (n > 0) {
            int n2 = Utils.inputShort((InputStream)inputStream) & 0xFFFF;
            n -= 2 + n2;
            X500Name x500Name = this.inputX500Name(inputStream, n2);
            arrayVector.addElement((Object)x500Name);
        }
        this.CAs = new X500Name[arrayVector.size()];
        arrayVector.getElements((Object[])this.CAs);
    }

    private X500Name inputX500Name(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        Utils.inputByteArray((byte[])byArray, (InputStream)inputStream);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        if (byArray[0] != 48) {
            ASN1Sequence.makeHeader((int)n).output((OutputStream)unsyncByteArrayOutputStream);
        }
        unsyncByteArrayOutputStream.write(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(unsyncByteArrayOutputStream.toByteArray());
        X500Name x500Name = new X500Name();
        x500Name.input((InputStream)byteArrayInputStream);
        return x500Name;
    }

    public int length() {
        return 1 + this.certTypes.length + 2 + this.CAsLength();
    }

    private int nameLength(X500Name x500Name) {
        return 2 + x500Name.length();
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.certTypes.length);
        outputStream.write(this.certTypes);
        Utils.outputShort((int)((short)this.CAsLength()), (OutputStream)outputStream);
        int n = 0;
        while (n < this.CAs.length) {
            this.outputX500Name(this.CAs[n], outputStream);
            ++n;
        }
    }

    private void outputX500Name(X500Name x500Name, OutputStream outputStream) throws IOException {
        Utils.outputShort((int)((short)x500Name.length()), (OutputStream)outputStream);
        x500Name.output(outputStream);
    }

    public String toString() {
        String[] stringArray = new String[]{"", "rsa_sign", "dss_sign", "rsa_fixed_dh", "dss_fixed_dh", "rsa_ephemeral_dh", "dss_ephemeral_dh", "", "", "", "", "", "", "", "", "", "", "", "", "", "fortezza_dms"};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("certTypes = {" + stringArray[this.certTypes[0]]);
        int n = 1;
        while (n < this.certTypes.length) {
            stringBuffer.append(", " + stringArray[this.certTypes[n]]);
            ++n;
        }
        stringBuffer.append("}, CAs = \n");
        int n2 = 0;
        while (n2 < this.CAs.length) {
            stringBuffer.append(String.valueOf(String.valueOf(this.CAs[n2])) + ";\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

