/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.CertificateVerifyV31;
import com.phaos.SSL.HandshakeBody;
import com.phaos.SSL.MACHash;
import com.phaos.SSL.MACHashV3;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertificateVerify
extends HandshakeBody {
    private static final int handshakeType = 15;
    protected SSLCrypto sslCrypto;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected RandomBitsSource rbs;
    private SessionState sessionState;
    protected byte[] sigBytes;
    protected byte[] md5Hash;
    protected byte[] shaHash;
    protected byte[] rsaHash;
    private static Class certificatVerifyV3;

    public void computeDigest(byte[] byArray, SymmetricKey symmetricKey) throws SSLException {
        try {
            MACHashV3 mACHashV3 = (MACHashV3)MACHash.getInstance(1, ProtocolVersion.SSL3, this.sslCrypto);
            this.md5Hash = mACHashV3.generateMAC(symmetricKey, byArray);
            MACHashV3 mACHashV32 = (MACHashV3)MACHash.getInstance(2, ProtocolVersion.SSL3, this.sslCrypto);
            this.shaHash = mACHashV32.generateMAC(symmetricKey, byArray);
        }
        catch (Exception exception) {
            AlertException alertException = new AlertException(exception.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    protected void computeSigBytes() throws SSLException {
        try {
            Signature signature = this.sslCrypto.getSignatureInstance(this.privateKey);
            signature.setRandomBitsSource(this.rbs);
            if (signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID())) {
                if (this.rsaHash == null) {
                    this.rsaHash = new byte[this.md5Hash.length + this.shaHash.length];
                }
                System.arraycopy(this.md5Hash, 0, this.rsaHash, 0, this.md5Hash.length);
                System.arraycopy(this.shaHash, 0, this.rsaHash, this.md5Hash.length, this.shaHash.length);
                signature.setHash(this.rsaHash);
            } else if (signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.dsaWithSHA1.getOID()) || signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.dsaWithSHA.getOID()) || signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.dsaWithSHA1Old.getOID())) {
                signature.setHash(this.shaHash);
                this.md5Hash = null;
            } else {
                throw new AuthenticationException("Unknown signature algorithm " + this.privateKey.getAlgorithm());
            }
            this.sigBytes = signature.sign();
        }
        catch (Exception exception) {
            AlertException alertException = new AlertException(exception.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public void erase() {
        this.publicKey = null;
        this.privateKey = null;
        this.sessionState = null;
    }

    public static CertificateVerify getCertificateVerify(ProtocolVersion protocolVersion) throws IOException {
        if (protocolVersion.equals(ProtocolVersion.TLS1)) {
            return new CertificateVerifyV31();
        }
        if (certificatVerifyV3 == null) {
            return new CertificateVerify();
        }
        try {
            CertificateVerify certificateVerify = (CertificateVerify)certificatVerifyV3.newInstance();
            return certificateVerify;
        }
        catch (IllegalAccessException illegalAccessException) {
            AlertException alertException = new AlertException("Unable to instantiate " + certificatVerifyV3.getName() + ":" + illegalAccessException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (InstantiationException instantiationException) {
            AlertException alertException = new AlertException("Unable to instantiate " + certificatVerifyV3.getName() + ":" + instantiationException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (ClassCastException classCastException) {
            AlertException alertException = new AlertException("Class does not implement certificatVerifyV3.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public int getHandshakeType() {
        return 15;
    }

    public void initialize(byte[] byArray, SymmetricKey symmetricKey, PrivateKey privateKey, RandomBitsSource randomBitsSource, SSLCrypto sSLCrypto, SessionState sessionState) throws SSLException {
        this.privateKey = privateKey;
        this.sslCrypto = sSLCrypto;
        this.rbs = randomBitsSource;
        this.sessionState = sessionState;
        this.computeDigest(byArray, symmetricKey);
        this.computeSigBytes();
    }

    public void initialize(byte[] byArray, SymmetricKey symmetricKey, PublicKey publicKey, SSLCrypto sSLCrypto, InputStream inputStream, SessionState sessionState) throws IOException {
        this.publicKey = publicKey;
        this.sslCrypto = sSLCrypto;
        this.sessionState = sessionState;
        this.computeDigest(byArray, symmetricKey);
        this.input(inputStream);
    }

    public void input(InputStream inputStream) throws IOException {
        this.sigBytes = new byte[Utils.inputShort((InputStream)inputStream)];
        Utils.inputByteArray((byte[])this.sigBytes, (InputStream)inputStream);
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("CertificateVerify received: " + this.toString());
        }
        try {
            Signature signature = this.sslCrypto.getSignatureInstance(this.publicKey);
            signature.setSigBytes(this.sigBytes);
            if (signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID())) {
                if (this.rsaHash == null) {
                    this.rsaHash = new byte[this.md5Hash.length + this.shaHash.length];
                }
                System.arraycopy(this.md5Hash, 0, this.rsaHash, 0, this.md5Hash.length);
                System.arraycopy(this.shaHash, 0, this.rsaHash, this.md5Hash.length, this.shaHash.length);
                signature.setHash(this.rsaHash);
            } else if (signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.dsaWithSHA1.getOID()) || signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.dsaWithSHA.getOID()) || signature.getDigestEncryptionAlgID().getOID().equals((Object)AlgID.dsaWithSHA1Old.getOID())) {
                signature.setHash(this.shaHash);
                this.md5Hash = null;
            } else {
                throw new AuthenticationException("Unknown signature algorithm " + this.publicKey.getAlgorithm());
            }
            if (!signature.verify()) {
                throw new CipherException("Invalid signature");
            }
            if (this.sessionState.getDebug()) {
                this.sessionState.debugln("Valid client signature");
            }
        }
        catch (CipherException cipherException) {
            AlertException alertException = new AlertException(cipherException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (AuthenticationException authenticationException) {
            AlertException alertException = new AlertException(authenticationException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public int length() {
        return 2 + this.sigBytes.length;
    }

    public void output(OutputStream outputStream) throws IOException {
        Utils.outputShort((int)((short)this.sigBytes.length), (OutputStream)outputStream);
        outputStream.write(this.sigBytes);
    }

    protected static void setClass(Class clazz) {
        certificatVerifyV3 = clazz;
    }

    public String toString() {
        return "MD5 = " + Utils.toHexString((byte[])this.md5Hash) + ", SHA = " + Utils.toHexString((byte[])this.shaHash);
    }
}

