/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLCipher;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import java.io.IOException;

public final class CipherSpec {
    public static final short SSL_NULL_WITH_NULL_NULL = 0;
    public static final short SSL_RSA_WITH_NULL_MD5 = 1;
    public static final short SSL_RSA_WITH_NULL_SHA = 2;
    public static final short SSL_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    public static final short SSL_RSA_WITH_RC4_128_MD5 = 4;
    public static final short SSL_RSA_WITH_RC4_128_SHA = 5;
    public static final short SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    public static final short SSL_RSA_EXPORT_WITH_DES_40_CBC_SHA = 8;
    public static final short SSL_RSA_WITH_DES_CBC_SHA = 9;
    public static final short SSL_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    public static final short SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17;
    public static final short SSL_DHE_DSS_WITH_DES_CBC_SHA = 18;
    public static final short SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    public static final short SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20;
    public static final short SSL_DHE_RSA_WITH_DES_CBC_SHA = 21;
    public static final short SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    public static final short SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 = 23;
    public static final short SSL_DH_anon_WITH_RC4_128_MD5 = 24;
    public static final short SSL_DH_anon_EXPORT_WITH_DES_40_CBC_SHA = 25;
    public static final short SSL_DH_anon_WITH_DES_CBC_SHA = 26;
    public static final short SSL_DH_anon_WITH_3DES_EDE_CBC_SHA = 27;
    public static final short TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    public static final short TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    public static final short TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    public static final short TLS_DH_anon_WITH_AES_128_CBC_SHA = 52;
    public static final short TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    public static final short TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    public static final short TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;
    public static final short TLS_DH_anon_WITH_AES_256_CBC_SHA = 58;
    public static final short TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA = 98;
    public static final short TLS_RSA_EXPORT1024_WITH_RC4_56_SHA = 100;
    public static final short TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 99;
    public static final short TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 101;
    public static final short TLS_DHE_DSS_WITH_RC4_128_SHA = 102;
    public static final short SSL_RSA_WITH_BLOWFISH_CBC_MD5 = -255;
    public static final short SSL_RSA_WITH_BLOWFISH_CBC_SHA = -254;
    public static final short SSL_DHE_DSS_WITH_BLOWFISH_CBC_MD5 = -253;
    public static final short SSL_DHE_DSS_WITH_BLOWFISH_CBC_SHA = -252;
    public static final short SSL_DHE_RSA_WITH_BLOWFISH_CBC_MD5 = -251;
    public static final short SSL_DHE_RSA_WITH_BLOWFISH_CBC_SHA = -250;
    public static final short SSL_DH_anon_WITH_BLOWFISH_CBC_MD5 = -249;
    public static final short SSL_DH_anon_WITH_BLOWFISH_CBC_SHA = -248;
    public static final int ANON = 0;
    public static final int RSA = 1;
    public static final int DH = 2;
    public static final int DSA = 3;
    public static final int NULL = 0;
    private short cipherSuite;
    private SSLCrypto sslCrypto;
    private SSLCipher writeCipher;
    private SSLCipher readCipher;
    private int keyExchange;
    private int serverCertType;
    private int keyMaterial;
    private int expKeyMaterial;

    public CipherSpec(int n, ProtocolVersion protocolVersion, SSLCrypto sSLCrypto) throws IOException {
        this.sslCrypto = sSLCrypto;
        this.initialize(n, protocolVersion);
    }

    public CipherSpec(SSLCrypto sSLCrypto) throws IOException {
        this(0, new ProtocolVersion(3, 0), sSLCrypto);
    }

    public void erase() {
        this.cipherSuite = 0;
        if (this.writeCipher != null) {
            this.writeCipher.erase();
        }
        if (this.readCipher != null) {
            this.readCipher.erase();
        }
    }

    public final short getCipherSuite() {
        return this.cipherSuite;
    }

    public final int getExpKeyMaterial() {
        return this.expKeyMaterial;
    }

    public final int getKeyExchange() {
        return this.keyExchange;
    }

    public final int getKeyMaterial() {
        return this.keyMaterial;
    }

    public final SSLCipher getReadCipher() {
        return this.readCipher;
    }

    public final int getServerCertType() {
        return this.serverCertType;
    }

    public final SSLCipher getWriteCipher() {
        return this.writeCipher;
    }

    private void initialize(int n, ProtocolVersion protocolVersion) throws IOException {
        this.cipherSuite = (short)n;
        try {
            switch (this.cipherSuite) {
                case 0: {
                    this.keyExchange = 0;
                    this.serverCertType = 0;
                    this.keyMaterial = 0;
                    this.expKeyMaterial = 0;
                    this.writeCipher = SSLCipher.getInstance(null, true, 64, 0, 0, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(null, true, 64, 0, 0, protocolVersion, this.sslCrypto);
                    break;
                }
                case 1: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 0;
                    this.expKeyMaterial = 0;
                    this.writeCipher = SSLCipher.getInstance(null, true, 64, 0, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(null, true, 64, 0, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case 2: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 0;
                    this.expKeyMaterial = 0;
                    this.writeCipher = SSLCipher.getInstance(null, true, 64, 0, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(null, true, 64, 0, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 3: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 5;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, true, 64, 0, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, true, 64, 0, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case 4: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case 5: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 6: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 5;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC2_CBC, true, 64, 8, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC2_CBC, true, 64, 8, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case 8: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 5;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 9: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 8;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 10: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 24;
                    this.expKeyMaterial = 24;
                    this.writeCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 20: {
                    this.keyExchange = 2;
                    this.serverCertType = 1;
                    this.keyMaterial = 5;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 21: {
                    this.keyExchange = 2;
                    this.serverCertType = 1;
                    this.keyMaterial = 8;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 22: {
                    this.keyExchange = 2;
                    this.serverCertType = 1;
                    this.keyMaterial = 24;
                    this.expKeyMaterial = 24;
                    this.writeCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 17: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 5;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 18: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 8;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 19: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 24;
                    this.expKeyMaterial = 24;
                    this.writeCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 23: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 5;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, true, 64, 0, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, true, 64, 0, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case 24: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case 25: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 5;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, true, 64, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 26: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 8;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 27: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 24;
                    this.expKeyMaterial = 24;
                    this.writeCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.DES_EDE3_CBC, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 47: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 50: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 51: {
                    this.keyExchange = 2;
                    this.serverCertType = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 52: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes128_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 53: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 32;
                    this.expKeyMaterial = 32;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 56: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 32;
                    this.expKeyMaterial = 32;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 57: {
                    this.keyExchange = 2;
                    this.serverCertType = 1;
                    this.keyMaterial = 32;
                    this.expKeyMaterial = 32;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 58: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 32;
                    this.expKeyMaterial = 32;
                    this.writeCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.aes256_CBC, false, 0, 16, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 98: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 8;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, true, 128, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, true, 128, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 100: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 7;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, true, 128, 0, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, true, 128, 0, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 99: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 8;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.desCBC, true, 128, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.desCBC, true, 128, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 101: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 7;
                    this.expKeyMaterial = 8;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, true, 128, 0, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, true, 128, 0, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case 102: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.RC4, false, 0, 0, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case -255: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case -254: {
                    this.serverCertType = 1;
                    this.keyExchange = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case -253: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case -252: {
                    this.keyExchange = 2;
                    this.serverCertType = 3;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case -251: {
                    this.keyExchange = 2;
                    this.serverCertType = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case -250: {
                    this.keyExchange = 2;
                    this.serverCertType = 1;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                case -249: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 1, protocolVersion, this.sslCrypto);
                    break;
                }
                case -248: {
                    this.keyExchange = 2;
                    this.serverCertType = 0;
                    this.keyMaterial = 16;
                    this.expKeyMaterial = 16;
                    this.writeCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    this.readCipher = SSLCipher.getInstance(AlgID.BLOWFISH, false, 0, 8, 2, protocolVersion, this.sslCrypto);
                    break;
                }
                default: {
                    AlertException alertException = new AlertException("Ciphersuite unknown", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
                    alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                    throw alertException;
                }
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public static boolean matches(int n, SSLCertificate sSLCertificate) {
        short s = (short)n;
        int n2 = s == 0 || s == 23 || s == 24 || s == 25 || s == 26 || s == 27 || s == -249 || s == -248 || s == 52 || s == 58 ? 0 : (s == 1 || s == 2 || s == 3 || s == 4 || s == 5 || s == 6 || s == 8 || s == 9 || s == 10 || s == 20 || s == 21 || s == 22 || s == -255 || s == -254 || s == -251 || s == -250 || s == 47 || s == 51 || s == 53 || s == 57 || s == 98 || s == 100 ? 1 : (s == 17 || s == 18 || s == 19 || s == -253 || s == -252 || s == 50 || s == 56 || s == 99 || s == 101 || s == 102 ? 3 : -1));
        return n2 == 0 || n2 == 1 && sSLCertificate != null && sSLCertificate.certificateList.size() > 0 && sSLCertificate.getPublicKey().getAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID()) || n2 == 3 && sSLCertificate != null && sSLCertificate.certificateList.size() > 0 && (sSLCertificate.getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsaOld.getOID()) || sSLCertificate.getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsa.getOID()));
    }

    public final void setReadCipher(SSLCipher sSLCipher) {
        this.readCipher = sSLCipher;
    }

    public final void setWriteCipher(SSLCipher sSLCipher) {
        this.writeCipher = sSLCipher;
    }

    public String toString() {
        String[] stringArray = new String[]{"NULL", "RSA", "DH"};
        String[] stringArray2 = new String[]{"ANON", "RSA", "DH", "DSA"};
        return "cipherSuite = 0x" + Integer.toString(this.cipherSuite, 16) + ", writeCipher = " + this.writeCipher + ", readCipher = " + this.readCipher + ", keyMaterial = " + this.keyMaterial + ", expKeyMaterial = " + this.expKeyMaterial + ", keyExchange = " + stringArray[this.keyExchange] + ", serverCertType = " + stringArray2[this.serverCertType];
    }
}

