/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.ClientHello;
import com.phaos.SSL.Compression;
import com.phaos.SSL.Message;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Random;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.SessionID;
import com.phaos.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ClientHelloV2
extends Message
implements ClientHello {
    private ProtocolVersion protocolVersion;
    private int[] cipherKinds;
    private SessionID sessionID;
    private byte[] challengeData;

    public ClientHelloV2() {
        this.cipherKinds = new int[0];
        this.challengeData = new byte[0];
    }

    public ClientHelloV2(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void erase() {
        Utils.setArray((int[])this.cipherKinds, (int)0);
        Utils.setArray((byte[])this.challengeData, (byte)0);
        this.cipherKinds = new int[0];
        this.challengeData = new byte[0];
        this.sessionID.erase();
    }

    public byte[] getChallengeData() {
        return this.challengeData;
    }

    public int[] getCipherKinds() {
        return this.cipherKinds;
    }

    public short[] getCipherSuites() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.cipherKinds.length) {
            if ((this.cipherKinds[n2] & 0xFF0000) == 0) {
                ++n;
            }
            ++n2;
        }
        short[] sArray = new short[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.cipherKinds.length) {
            if ((this.cipherKinds[n3] & 0xFF0000) == 0) {
                sArray[n4++] = (short)this.cipherKinds[n3];
            }
            ++n3;
        }
        return sArray;
    }

    public Compression[] getCompressionMethods() {
        return new Compression[]{Compression.NULL};
    }

    public Random getRandom() {
        byte[] byArray = new byte[32];
        System.arraycopy(this.challengeData, Math.max(this.challengeData.length - 32, 0), byArray, Math.max(32 - this.challengeData.length, 0), Math.min(this.challengeData.length, 32));
        Random random = new Random();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            random.input(byteArrayInputStream);
        }
        catch (IOException iOException) {}
        return random;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public int getType() {
        return 1;
    }

    public ProtocolVersion getVersion() {
        return this.protocolVersion;
    }

    public void input(InputStream inputStream) throws IOException {
        byte by = (byte)inputStream.read();
        if (by != this.getType()) {
            throw new IOException("Attempted to fill a ClientHelloV2 object with a different type message: " + by);
        }
        if (this.protocolVersion == null) {
            this.protocolVersion = new ProtocolVersion(inputStream);
        } else {
            this.protocolVersion.input(inputStream);
        }
        short s = Utils.inputShort((InputStream)inputStream);
        short s2 = Utils.inputShort((InputStream)inputStream);
        short s3 = Utils.inputShort((InputStream)inputStream);
        if (s2 != 0 && s2 != 16) {
            throw new SSLException("Invaild Session ID length for a SSL v2 Client Hello: " + s2);
        }
        this.cipherKinds = new int[s / 3];
        byte[] byArray = new byte[s2];
        this.challengeData = new byte[s3];
        int n = 0;
        while (n < this.cipherKinds.length) {
            this.cipherKinds[n] = Utils.input24bit((InputStream)inputStream);
            ++n;
        }
        inputStream.read(byArray);
        inputStream.read(this.challengeData);
        this.sessionID = new SessionID(byArray);
    }

    public int length() {
        return 9 + this.cipherKinds.length * 3 + this.sessionID.getID().length + this.challengeData.length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.protocolVersion.output(outputStream);
        Utils.outputShort((int)(this.cipherKinds.length * 3), (OutputStream)outputStream);
        Utils.outputShort((int)this.sessionID.getID().length, (OutputStream)outputStream);
        Utils.outputShort((int)this.challengeData.length, (OutputStream)outputStream);
        int n = 0;
        while (n < this.cipherKinds.length) {
            Utils.output24bit((int)this.cipherKinds[n], (OutputStream)outputStream);
            ++n;
        }
        outputStream.write(this.sessionID.getID());
        outputStream.write(this.challengeData);
    }

    public void setChallengeData(byte[] byArray) {
        this.challengeData = byArray == null ? new byte[0] : byArray;
    }

    public void setCipherKinds(int[] nArray) {
        this.cipherKinds = nArray == null ? new int[0] : nArray;
    }

    public void setSessionID(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    public void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(ClientHelloV2){");
        stringBuffer.append("ProtocolVersion=" + this.protocolVersion + ", ");
        stringBuffer.append("CipherKinds={");
        int n = 0;
        while (n < this.cipherKinds.length) {
            stringBuffer.append(this.cipherKinds[n]);
            if (n + 1 != this.cipherKinds.length) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}, ");
        stringBuffer.append("SessionID=" + this.sessionID + ", ");
        stringBuffer.append("ChallengeData=" + Utils.toHexString((byte[])this.challengeData) + "}");
        return stringBuffer.toString();
    }
}

