/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.ClientHello;
import com.phaos.SSL.Compression;
import com.phaos.SSL.HandshakeBody;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Random;
import com.phaos.SSL.SessionID;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ClientHelloV3
extends HandshakeBody
implements ClientHello {
    private static final int handshakeType = 1;
    private ProtocolVersion version;
    private Random random;
    private SessionID sessionID;
    private short[] cipherSuites;
    private Compression[] compressionMethods;
    private int inputLength;
    private byte[] extensions;

    public ClientHelloV3(ProtocolVersion protocolVersion, short[] sArray, RandomBitsSource randomBitsSource) {
        this(protocolVersion, sArray, null, randomBitsSource, null, null);
    }

    public ClientHelloV3(ProtocolVersion protocolVersion, short[] sArray, RandomBitsSource randomBitsSource, SessionID sessionID, SessionState sessionState) {
        if (sArray == null || sArray.length == 0) {
            throw new IllegalStateException("No cipherSuites specified");
        }
        this.version = protocolVersion;
        this.random = new Random(randomBitsSource);
        if (sessionID == null) {
            this.sessionID = new SessionID();
            this.cipherSuites = (short[])sArray.clone();
            this.compressionMethods = new Compression[]{Compression.NULL};
        } else {
            this.sessionID = sessionID;
            short s = sessionState.getPendingCS().getCipherSuite();
            this.cipherSuites = null;
            int n = 0;
            while (n < sArray.length && this.cipherSuites == null) {
                if (s == sArray[n]) {
                    this.cipherSuites = (short[])sArray.clone();
                }
                ++n;
            }
            if (this.cipherSuites == null) {
                this.cipherSuites = new short[sArray.length + 1];
                System.arraycopy(sArray, 0, this.cipherSuites, 0, sArray.length);
                this.cipherSuites[sArray.length] = s;
            }
            this.compressionMethods = new Compression[]{sessionState.getCompressionMethod()};
        }
    }

    public ClientHelloV3(ProtocolVersion protocolVersion, short[] sArray, Compression[] compressionArray, RandomBitsSource randomBitsSource, SessionID sessionID, SessionState sessionState) {
        if (sArray == null || sArray.length == 0) {
            throw new IllegalStateException("No cipherSuites specified");
        }
        this.version = protocolVersion;
        this.random = new Random(randomBitsSource);
        if (sessionID == null) {
            this.sessionID = new SessionID();
            this.cipherSuites = (short[])sArray.clone();
            this.compressionMethods = compressionArray == null || compressionArray.length == 0 ? new Compression[]{Compression.NULL} : (Compression[])compressionArray.clone();
        } else {
            this.sessionID = sessionID;
            short s = sessionState.getPendingCS().getCipherSuite();
            this.cipherSuites = null;
            int n = 0;
            while (n < sArray.length && this.cipherSuites == null) {
                if (s == sArray[n]) {
                    this.cipherSuites = (short[])sArray.clone();
                }
                ++n;
            }
            if (this.cipherSuites == null) {
                this.cipherSuites = new short[sArray.length + 1];
                System.arraycopy(sArray, 0, this.cipherSuites, 0, sArray.length);
                this.cipherSuites[sArray.length] = s;
            }
            if (compressionArray != null) {
                Compression compression = sessionState.getCompressionMethod();
                this.compressionMethods = null;
                int n2 = 0;
                while (n2 < compressionArray.length && this.compressionMethods == null) {
                    if (compression.getValue() == compressionArray[n2].getValue()) {
                        this.compressionMethods = (Compression[])compressionArray.clone();
                    }
                    ++n2;
                }
                if (this.compressionMethods == null) {
                    this.compressionMethods = new Compression[compressionArray.length + 1];
                    System.arraycopy(compressionArray, 0, this.compressionMethods, 0, compressionArray.length);
                    this.compressionMethods[compressionArray.length] = compression;
                }
            } else {
                this.compressionMethods = new Compression[]{sessionState.getCompressionMethod()};
            }
        }
    }

    public ClientHelloV3(InputStream inputStream, int n) throws IOException {
        this.inputLength = n;
        this.input(inputStream);
    }

    public void erase() {
        if (this.random != null) {
            this.random.erase();
        }
        if (this.sessionID != null) {
            this.sessionID.erase();
        }
    }

    public short[] getCipherSuites() {
        return this.cipherSuites;
    }

    public Compression[] getCompressionMethods() {
        return this.compressionMethods;
    }

    public int getHandshakeType() {
        return 1;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void input(InputStream inputStream) throws IOException {
        this.version = new ProtocolVersion(inputStream);
        this.random = new Random(inputStream);
        this.sessionID = new SessionID(inputStream);
        this.cipherSuites = new short[Utils.inputShort((InputStream)inputStream) / 2];
        int n = 0;
        while (n < this.cipherSuites.length) {
            this.cipherSuites[n] = Utils.inputShort((InputStream)inputStream);
            ++n;
        }
        this.compressionMethods = new Compression[Utils.inputByte((InputStream)inputStream)];
        int n2 = 0;
        while (n2 < this.compressionMethods.length) {
            this.compressionMethods[n2] = new Compression(inputStream);
            ++n2;
        }
        this.extensions = null;
        int n3 = this.inputLength - this.length();
        if (n3 > 0) {
            this.extensions = Utils.inputBytes((InputStream)inputStream, (int)n3);
        }
    }

    public int length() {
        return this.version.length() + this.random.length() + this.sessionID.length() + 2 + 2 * this.cipherSuites.length + 1 + this.compressionMethods.length * Compression.NULL.length() + (this.extensions == null ? 0 : this.extensions.length);
    }

    public void output(OutputStream outputStream) throws IOException {
        this.version.output(outputStream);
        this.random.output(outputStream);
        this.sessionID.output(outputStream);
        Utils.outputShort((int)((short)(2 * this.cipherSuites.length)), (OutputStream)outputStream);
        int n = 0;
        while (n < this.cipherSuites.length) {
            Utils.outputShort((int)this.cipherSuites[n], (OutputStream)outputStream);
            ++n;
        }
        outputStream.write(this.compressionMethods.length);
        int n2 = 0;
        while (n2 < this.compressionMethods.length) {
            this.compressionMethods[n2].output(outputStream);
            ++n2;
        }
        if (this.extensions != null) {
            outputStream.write(this.extensions);
        }
    }

    public String toString() {
        String string = "Version = " + this.version + ", random = " + this.random + ", sessionID = " + this.sessionID + ", cipherSuites = " + this.cipherSuites.length + " {";
        int n = 0;
        while (n < this.cipherSuites.length) {
            string = String.valueOf(string) + Integer.toString(this.cipherSuites[n], 16);
            string = n < this.cipherSuites.length - 1 ? String.valueOf(string) + ", " : String.valueOf(string) + "}, ";
            ++n;
        }
        string = String.valueOf(string) + "compressionMethods = " + this.compressionMethods.length + " {";
        int n2 = 0;
        while (n2 < this.compressionMethods.length) {
            string = String.valueOf(string) + Integer.toString(this.compressionMethods[n2].getValue(), 16);
            string = n2 < this.compressionMethods.length - 1 ? String.valueOf(string) + ", " : String.valueOf(string) + "}";
            ++n2;
        }
        if (this.extensions != null) {
            string = String.valueOf(string) + "extensions=" + Utils.toHexString((byte[])this.extensions);
        }
        return string;
    }
}

