/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.Biguint;
import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.ClientKeyExchangeV3;
import com.phaos.SSL.ClientKeyExchangeV31;
import com.phaos.SSL.HandshakeBody;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.DiffieHellman;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public abstract class ClientKeyExchange
extends HandshakeBody {
    private static final int handshakeType = 16;
    private static Class clientKeyExchangeClassV3;
    protected PublicKey publicKey;
    protected ProtocolVersion latestClientVersion;
    protected SSLCrypto sslCrypto;
    protected Biguint gx;
    protected DiffieHellman dh;
    protected BigInteger k;
    protected SymmetricKey pms;
    protected byte[] encryptedPMS;
    protected CipherSpec pendingCS;
    protected PrivateKey privateKey;
    protected int encryptedPMSLengthInput;
    protected RandomBitsSource rng;
    protected boolean allowBadPMS;

    protected abstract void computeDH(BigInteger var1, BigInteger var2, BigInteger var3, RandomBitsSource var4) throws IOException;

    protected abstract void computeRSA(RandomBitsSource var1) throws IOException;

    protected SymmetricKey dhPreMasterSecret() {
        if (this.gx != null && this.dh != null) {
            return new SymmetricKey(new Biguint(this.k).toByteArray());
        }
        return null;
    }

    protected SymmetricKey dhPreMasterSecret(DiffieHellman diffieHellman) {
        if (this.gx != null) {
            this.k = diffieHellman.getKey(this.gx.getValue());
            return new SymmetricKey(new Biguint(this.k).toByteArray());
        }
        return null;
    }

    protected void erase() {
        this.publicKey = null;
        this.gx = new Biguint(0);
        this.dh = null;
        this.erasePMS();
        this.privateKey = null;
    }

    protected abstract void erasePMS();

    public static ClientKeyExchange getClientKeyExchange(ProtocolVersion protocolVersion) throws IOException {
        if (protocolVersion.equals(ProtocolVersion.TLS1)) {
            return new ClientKeyExchangeV31();
        }
        if (clientKeyExchangeClassV3 == null) {
            return new ClientKeyExchangeV3();
        }
        try {
            ClientKeyExchange clientKeyExchange = (ClientKeyExchange)clientKeyExchangeClassV3.newInstance();
            return clientKeyExchange;
        }
        catch (IllegalAccessException illegalAccessException) {
            AlertException alertException = new AlertException("Unable to instantiate " + clientKeyExchangeClassV3.getName() + ":" + illegalAccessException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (InstantiationException instantiationException) {
            AlertException alertException = new AlertException("Unable to instantiate " + clientKeyExchangeClassV3.getName() + ":" + instantiationException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (ClassCastException classCastException) {
            AlertException alertException = new AlertException("Class does not implement CkiClientKeyExchangeV3.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    protected Biguint getGx() {
        return this.gx;
    }

    public int getHandshakeType() {
        return 16;
    }

    protected void initialize(CipherSpec cipherSpec, ProtocolVersion protocolVersion, PrivateKey privateKey, int n, RandomBitsSource randomBitsSource, SSLCrypto sSLCrypto, boolean bl, InputStream inputStream) throws IOException {
        this.allowBadPMS = bl;
        this.pendingCS = cipherSpec;
        this.latestClientVersion = protocolVersion;
        this.privateKey = privateKey;
        this.encryptedPMSLengthInput = n;
        this.rng = randomBitsSource;
        this.sslCrypto = sSLCrypto;
        this.input(inputStream);
    }

    protected void initialize(CipherSpec cipherSpec, ProtocolVersion protocolVersion, RandomBitsSource randomBitsSource, SSLCrypto sSLCrypto, boolean bl, InputStream inputStream) throws IOException {
        this.allowBadPMS = bl;
        this.pendingCS = cipherSpec;
        this.latestClientVersion = protocolVersion;
        this.rng = randomBitsSource;
        this.sslCrypto = sSLCrypto;
        this.input(inputStream);
    }

    protected void initialize(PublicKey publicKey, ProtocolVersion protocolVersion, RandomBitsSource randomBitsSource, SSLCrypto sSLCrypto) throws IOException {
        this.publicKey = publicKey;
        this.latestClientVersion = protocolVersion;
        this.sslCrypto = sSLCrypto;
        this.computeRSA(randomBitsSource);
    }

    protected void initialize(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, RandomBitsSource randomBitsSource, SSLCrypto sSLCrypto) throws IOException {
        this.sslCrypto = sSLCrypto;
        this.computeDH(bigInteger, bigInteger2, bigInteger3, randomBitsSource);
    }

    public int length() {
        return this.gx != null ? this.gx.length() : this.encryptedPMS.length;
    }

    public void output(OutputStream outputStream) throws IOException {
        if (this.gx != null) {
            this.gx.output(outputStream);
        } else {
            outputStream.write(this.encryptedPMS);
        }
    }

    protected SymmetricKey rsaPreMasterSecret() {
        return this.pms;
    }

    protected static void setClass(Class clazz) {
        clientKeyExchangeClassV3 = clazz;
    }
}

