/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.Biguint;
import com.phaos.SSL.ClientKeyExchange;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ClientKeyExchangeV31
extends ClientKeyExchange {
    protected void computeDH(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, RandomBitsSource randomBitsSource) throws IOException {
        try {
            this.dh = this.sslCrypto.getDiffieHellmanInstance(bigInteger, bigInteger2, randomBitsSource);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        this.gx = new Biguint(this.dh.myValue());
        this.k = this.dh.getKey(bigInteger3);
    }

    protected void computeRSA(RandomBitsSource randomBitsSource) throws IOException {
        byte[] byArray = new byte[46];
        randomBitsSource.randomBytes(byArray);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(48);
        try {
            this.latestClientVersion.output((OutputStream)unsyncByteArrayOutputStream);
            unsyncByteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        this.pms = new SymmetricKey(unsyncByteArrayOutputStream.toByteArray());
        try {
            Cipher cipher = this.sslCrypto.getCipherInstance(AlgID.rsaEncryption, (Key)this.publicKey);
            cipher.setRandomBitsSource(randomBitsSource);
            this.encryptedPMS = cipher.encrypt(this.pms.getBytes());
            cipher.erase();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (CipherException cipherException) {
            AlertException alertException = new AlertException(cipherException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (InvalidKeyException invalidKeyException) {
            AlertException alertException = new AlertException(invalidKeyException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    protected void erasePMS() {
        this.k = BigInteger.valueOf(0L);
        if (this.pms != null) {
            this.pms.erase();
        }
    }

    public void input(InputStream inputStream) throws IOException {
        if (this.pendingCS.getKeyExchange() == 2) {
            this.gx = new Biguint(inputStream);
        } else {
            Object object;
            this.encryptedPMSLengthInput -= 2;
            if (Utils.inputShort((InputStream)inputStream) != this.encryptedPMSLengthInput) {
                throw new AlertException("Incorrect message format", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECODE_ERROR));
            }
            this.encryptedPMS = new byte[this.encryptedPMSLengthInput];
            Utils.inputByteArray((byte[])this.encryptedPMS, (InputStream)inputStream);
            boolean bl = false;
            try {
                object = this.sslCrypto.getCipherInstance(AlgID.rsaEncryption, (Key)this.privateKey);
                this.pms = new SymmetricKey(object.decrypt(this.encryptedPMS));
                object.erase();
                if (this.allowBadPMS) {
                    if (this.pms.getBytes()[0] != this.latestClientVersion.getMajor() || this.pms.getBytes()[1] != 0 && this.pms.getBytes()[1] != 1) {
                        bl = true;
                    }
                } else if (!this.latestClientVersion.equals(new ProtocolVersion(this.pms.getBytes()[0], this.pms.getBytes()[1]))) {
                    bl = true;
                }
            }
            catch (CipherException cipherException) {
                bl = true;
            }
            catch (InvalidKeyException invalidKeyException) {
                AlertException alertException = new AlertException(invalidKeyException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
                alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                throw alertException;
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
                alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                throw alertException;
            }
            if (bl) {
                object = new byte[48];
                this.rng.randomBytes((byte[])object);
                this.pms = new SymmetricKey((byte[])object);
            }
        }
    }

    public int length() {
        return (this.gx != null ? 0 : 2) + super.length();
    }

    public void output(OutputStream outputStream) throws IOException {
        if (this.gx == null) {
            Utils.outputShort((int)this.encryptedPMS.length, (OutputStream)outputStream);
        }
        super.output(outputStream);
    }

    public String toString() {
        if (this.gx != null) {
            return "gx = " + this.gx + ", dh = " + this.dh + ", k = " + this.k;
        }
        return "pms = " + Utils.toHexString((byte[])this.pms.getBytes());
    }
}

