/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Random;
import com.phaos.SSL.Secrets;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;

public final class ConnectionState {
    private static final long MAX_SEQ_NUM = 0x7FFFFFFFFFFFFFFEL;
    protected Random peerRandom;
    protected Random ownRandom;
    protected SymmetricKey writeMACSecret;
    protected SymmetricKey readMACSecret;
    protected SymmetricKey writeKey;
    protected SymmetricKey readKey;
    protected byte[] writeIV;
    protected byte[] readIV;
    private long sequenceNumIn;
    private long sequenceNumOut;

    public void erase() {
        if (this.peerRandom != null) {
            this.peerRandom.erase();
        }
        if (this.ownRandom != null) {
            this.ownRandom.erase();
        }
        if (this.writeMACSecret != null) {
            this.writeMACSecret.erase();
        }
        if (this.readMACSecret != null) {
            this.readMACSecret.erase();
        }
        if (this.writeKey != null) {
            this.writeKey.erase();
        }
        if (this.readKey != null) {
            this.readKey.erase();
        }
        Utils.setArray((byte[])this.writeIV, (byte)0);
        Utils.setArray((byte[])this.readIV, (byte)0);
    }

    public Random getOwnRandom() {
        return this.ownRandom;
    }

    public Random getPeerRandom() {
        return this.peerRandom;
    }

    public byte[] getReadIV() {
        return this.readIV;
    }

    public SymmetricKey getReadKey() {
        return this.readKey;
    }

    public SymmetricKey getReadMACSecret() {
        return this.readMACSecret;
    }

    public long getSeqIn() {
        return this.sequenceNumIn;
    }

    public long getSeqOut() {
        return this.sequenceNumOut;
    }

    public byte[] getWriteIV() {
        return this.writeIV;
    }

    public SymmetricKey getWriteKey() {
        return this.writeKey;
    }

    public SymmetricKey getWriteMACSecret() {
        return this.writeMACSecret;
    }

    public void incrSeqIn() {
        if (++this.sequenceNumIn > 0x7FFFFFFFFFFFFFFEL) {
            this.sequenceNumIn = 0L;
        }
    }

    public void incrSeqOut() {
        if (++this.sequenceNumOut > 0x7FFFFFFFFFFFFFFEL) {
            this.sequenceNumOut = 0L;
        }
    }

    public void resetSeqIn() {
        this.sequenceNumIn = 0L;
    }

    public void resetSeqOut() {
        this.sequenceNumOut = 0L;
    }

    public void setOwnRandom(Random random) {
        this.ownRandom = random;
    }

    public void setPeerRandom(Random random) {
        this.peerRandom = random;
    }

    public void setSecrets(Secrets secrets) {
        if (secrets.isClient()) {
            this.writeMACSecret = secrets.getClientMACsecret();
            this.readMACSecret = secrets.getServerMACsecret();
            this.writeKey = secrets.getClientKey();
            this.readKey = secrets.getServerKey();
            this.writeIV = secrets.getClientIV();
            this.readIV = secrets.getServerIV();
        } else {
            this.writeMACSecret = secrets.getServerMACsecret();
            this.readMACSecret = secrets.getClientMACsecret();
            this.writeKey = secrets.getServerKey();
            this.readKey = secrets.getClientKey();
            this.writeIV = secrets.getServerIV();
            this.readIV = secrets.getClientIV();
        }
    }
}

