/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.Finished;
import com.phaos.SSL.MACHash;
import com.phaos.SSL.MACHashV3;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FinishedV3
extends Finished {
    private static final int handshakeType = 20;
    private boolean client;
    private static final byte[] clientSSL = Utils.wordToBytes((int)1129074260);
    private static final byte[] serverSSL = Utils.wordToBytes((int)1397904978);
    public byte[] md5Hash;
    public byte[] shaHash;

    public FinishedV3(boolean bl, byte[] byArray, SymmetricKey symmetricKey, SSLCrypto sSLCrypto) throws IOException {
        super(sSLCrypto);
        this.client = bl;
        try {
            this.computeDigest(byArray, symmetricKey);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public FinishedV3(boolean bl, byte[] byArray, SymmetricKey symmetricKey, SSLCrypto sSLCrypto, InputStream inputStream) throws IOException {
        super(sSLCrypto);
        this.client = bl;
        try {
            this.computeDigest(byArray, symmetricKey);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        this.input(inputStream);
    }

    private void computeDigest(byte[] byArray, SymmetricKey symmetricKey) throws AlgorithmIdentifierException, IOException {
        MACHashV3 mACHashV3 = (MACHashV3)MACHash.getInstance(1, ProtocolVersion.SSL3, this.sslCrypto);
        this.md5Hash = mACHashV3.generateMAC(symmetricKey, this.getLabel(), byArray);
        MACHashV3 mACHashV32 = (MACHashV3)MACHash.getInstance(2, ProtocolVersion.SSL3, this.sslCrypto);
        this.shaHash = mACHashV32.generateMAC(symmetricKey, this.getLabel(), byArray);
    }

    public int getHandshakeType() {
        return 20;
    }

    private byte[] getLabel() {
        return this.client ? clientSSL : serverSSL;
    }

    public void input(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[20];
        Utils.inputByteArray((byte[])byArray, (InputStream)inputStream);
        Utils.inputByteArray((byte[])byArray2, (InputStream)inputStream);
        if (!Utils.areEqual((byte[])byArray, (byte[])this.md5Hash) || !Utils.areEqual((byte[])byArray2, (byte[])this.shaHash)) {
            throw new AlertException("Incorrect handshake hash: should be " + this.toString() + "; is md5 = " + Utils.toHexString((byte[])byArray) + ", sha = " + Utils.toHexString((byte[])byArray2), "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE), 1);
        }
    }

    public int length() {
        return this.md5Hash.length + this.shaHash.length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.md5Hash);
        outputStream.write(this.shaHash);
    }

    public String toString() {
        return "md5 = " + Utils.toHexString((byte[])this.md5Hash) + ", sha = " + Utils.toHexString((byte[])this.shaHash);
    }
}

