/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.Finished;
import com.phaos.SSL.MACHashV31;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FinishedV31
extends Finished {
    private static final int handshakeType = 20;
    private boolean client;
    private static final byte[] CLIENT_TLS = "client finished".getBytes();
    private static final byte[] SERVER_TLS = "server finished".getBytes();
    public byte[] hash;

    public FinishedV31(boolean bl, byte[] byArray, SymmetricKey symmetricKey, SSLCrypto sSLCrypto) throws IOException {
        super(sSLCrypto);
        this.client = bl;
        try {
            this.computeDigest(byArray, symmetricKey);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public FinishedV31(boolean bl, byte[] byArray, SymmetricKey symmetricKey, SSLCrypto sSLCrypto, InputStream inputStream) throws IOException {
        super(sSLCrypto);
        this.client = bl;
        try {
            this.computeDigest(byArray, symmetricKey);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        this.input(inputStream);
    }

    private void computeDigest(byte[] byArray, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        byte[] byArray2 = new byte[36];
        try {
            MessageDigest messageDigest = this.sslCrypto.getMessageDigestInstance(AlgID.md5);
            messageDigest.update(byArray);
            messageDigest.computeCurrent();
            MessageDigest messageDigest2 = this.sslCrypto.getMessageDigestInstance(AlgID.sha_1);
            messageDigest2.update(byArray);
            messageDigest2.computeCurrent();
            System.arraycopy(messageDigest.digestBits, 0, byArray2, 0, 16);
            System.arraycopy(messageDigest2.digestBits, 0, byArray2, 16, 20);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("Class MessageDigest MD5/ SHA1 not found: " + algorithmIdentifierException.toString());
        }
        this.hash = MACHashV31.PRF(symmetricKey, this.getLabel(), byArray2, 12, this.sslCrypto);
    }

    public int getHandshakeType() {
        return 20;
    }

    private byte[] getLabel() {
        return this.client ? CLIENT_TLS : SERVER_TLS;
    }

    public void input(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[12];
        Utils.inputByteArray((byte[])byArray, (InputStream)inputStream);
        if (!Utils.areEqual((byte[])byArray, (byte[])this.hash)) {
            throw new AlertException("Incorrect handshake hash: should be " + this.toString() + "; is hash = " + Utils.toHexString((byte[])byArray), "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE), 1);
        }
    }

    public int length() {
        return this.hash.length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.hash);
    }

    public String toString() {
        return "hash = " + Utils.toHexString((byte[])this.hash);
    }
}

