/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.BadMACException;
import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.ClientAuthenticationException;
import com.phaos.SSL.ClientHello;
import com.phaos.SSL.ClientHelloV2;
import com.phaos.SSL.ClientHelloV3;
import com.phaos.SSL.ClientSessionCache;
import com.phaos.SSL.HandshakeMessage;
import com.phaos.SSL.HandshakeParams;
import com.phaos.SSL.HandshakeV3;
import com.phaos.SSL.HandshakeV31;
import com.phaos.SSL.HashtableSessionCache;
import com.phaos.SSL.HelloRequest;
import com.phaos.SSL.Message;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Record;
import com.phaos.SSL.RecordInputStream;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.SSLParams;
import com.phaos.SSL.SSLSocket;
import com.phaos.SSL.ServerHello;
import com.phaos.SSL.ServerHelloV2;
import com.phaos.SSL.SessionID;
import com.phaos.SSL.SessionParams;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InterruptedIOException;

class Handshake {
    private boolean handshakePerformed;
    private boolean handshakeInProgress;
    private boolean renegotiationAndEmptyIS;
    private boolean renegotiation = false;
    private boolean resumed;
    private HandshakeParams handshakeParams;
    private Record record;
    private SSLCrypto sslCrypto;
    private RecordInputStream recordIS;
    private ClientHello clientHello;
    private ServerHello serverHello;
    private SessionID sessionID;
    private HandshakeV3 endHandshake;
    private String serverName;
    private int port;
    private boolean swappedToSSL2 = false;
    private SessionParams sessionParams;
    private SSLSocket socket;

    public Handshake(Record record, SSLParams sSLParams, String string, int n, boolean bl, SSLCrypto sSLCrypto, SSLSocket sSLSocket) throws IOException {
        this(record, sSLParams, bl, sSLCrypto, sSLSocket);
        this.handshakeParams.setServerName(string);
        this.serverName = string;
        this.port = n;
        this.socket = sSLSocket;
    }

    public Handshake(Record record, SSLParams sSLParams, boolean bl, SSLCrypto sSLCrypto, SSLSocket sSLSocket) throws IOException {
        this.record = record;
        this.sslCrypto = sSLCrypto;
        this.socket = sSLSocket;
        this.handshakeParams = new HandshakeParams(sSLParams, bl, sSLCrypto);
    }

    private void buildClientHelloV2() throws IOException {
        int n;
        int[] nArray;
        Object object;
        Object[] objectArray;
        SessionID sessionID;
        ClientHelloV2 clientHelloV2 = new ClientHelloV2();
        ProtocolVersion protocolVersion = null;
        SSLCrypto sSLCrypto = this.sslCrypto;
        SSLParams sSLParams = this.handshakeParams.getSSLParams();
        if (this.sessionParams != null) {
            sessionID = this.sessionParams.getSessionID();
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Attempting to resume session: " + sessionID);
            }
        } else {
            sessionID = new SessionID();
        }
        if (sSLParams.getAllowTLS1()) {
            protocolVersion = new ProtocolVersion(3, 1);
        } else if (sSLParams.getAllowSSL3()) {
            protocolVersion = new ProtocolVersion(3, 0);
        } else if (sSLParams.getAllowSSL2()) {
            protocolVersion = new ProtocolVersion(0, 2);
        }
        if (protocolVersion == null) {
            throw new IOException("No protocol versions were allowed in SSLParams,unable to perform handshake");
        }
        if (sSLParams.getAllowSSL2() && (sSLParams.getAllowSSL3() || sSLParams.getAllowTLS1())) {
            objectArray = sSLParams.getSSL2ClientCipherKinds();
            object = sSLParams.getClientCipherSuites();
            nArray = new int[objectArray.length + ((short[])object).length];
            System.arraycopy(objectArray, 0, nArray, 0, objectArray.length);
            int n2 = 0;
            n = objectArray.length;
            while (n2 < ((short[])object).length) {
                nArray[n] = object[n2] & 0xFFFF;
                ++n2;
                ++n;
            }
        } else if (sSLParams.getAllowSSL2()) {
            nArray = (int[])sSLParams.getSSL2ClientCipherKinds().clone();
        } else {
            objectArray = sSLParams.getClientCipherSuites();
            nArray = new int[objectArray.length];
            int n3 = 0;
            while (n3 < objectArray.length) {
                nArray[n3] = objectArray[n3] & 0xFFFF;
                ++n3;
            }
        }
        clientHelloV2.setCipherKinds(nArray);
        clientHelloV2.setSessionID(sessionID);
        clientHelloV2.setVersion(protocolVersion);
        object = sSLCrypto.getRBS(null);
        if (sSLParams.getSSL2Use16ByteChallenge() && sSLParams.getAllowSSL2()) {
            objectArray = new byte[16];
        } else {
            byte[] byArray = new byte[1];
            object.randomBytes(byArray);
            n = (byArray[0] & 0x7F) % 17 + 16;
            objectArray = new byte[n];
        }
        object.randomBytes((byte[])objectArray);
        clientHelloV2.setChallengeData((byte[])objectArray);
        this.clientHello = clientHelloV2;
    }

    private void checkServerSessionIDCached() throws IOException {
        if (this.handshakeParams.getSSLParams().getResumableSessions() && this.handshakeParams.getSSLParams().getServerSessionCache() != null) {
            SessionParams sessionParams;
            if (this.record.getSessionState().getSessionID().isEmpty()) {
                return;
            }
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Checking whether " + this.record.getSessionState().getSessionID() + " is in cache");
            }
            if ((sessionParams = this.handshakeParams.getSSLParams().getServerSessionCache().getSession(this.record.getSessionState().getSessionID())) != null) {
                if (this.record.getSessionState().getDebug()) {
                    this.record.getSessionState().debugln("Session in cache");
                }
                if (this.handshakeParams.supportedCS(this.clientHello.getCipherSuites(), sessionParams.getCipherSuite())) {
                    this.resumed = true;
                    if (this.record.getSessionState().getDebug()) {
                        this.record.getSessionState().debugln("Using session params " + sessionParams);
                    }
                    this.record.setSessionParams(sessionParams);
                }
            }
        }
    }

    private void chooseCipherSuite() throws IOException {
        int n = -1;
        short[] sArray = this.clientHello.getCipherSuites();
        short[] sArray2 = this.handshakeParams.getSSLParams().getServerCipherSuites();
        int n2 = 0;
        while (n2 < sArray.length && n == -1) {
            int n3 = 0;
            while (n3 < sArray2.length && n == -1) {
                if (sArray[n2] == sArray2[n3]) {
                    n = sArray[n2] & 0xFFFF;
                }
                ++n3;
            }
            ++n2;
        }
        if (n == -1) {
            throw new AlertException("Unsupported ciphersuites requested", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Using ciphersuite " + Integer.toString(n, 16));
        }
        this.record.getSessionState().setPendingCS(new CipherSpec(n, this.record.getProtocolVersionOut(), this.sslCrypto));
        if (this.record.getSessionState().getPendingCS().getServerCertType() == 3 && this.handshakeParams.getSSLParams().getServerCertDSA() != null) {
            this.record.getSessionState().setCert(this.handshakeParams.getSSLParams().getServerCertDSA());
        } else {
            this.record.getSessionState().setCert(this.handshakeParams.getSSLParams().getServerCert());
        }
    }

    private void clientInit() throws IOException {
        this.sendClientHello();
        if (this.renegotiationAndEmptyIS) {
            this.record.emptyIS(this.recordIS);
        }
        this.receiveServerHello();
        if (this.serverHello instanceof ServerHelloV2 && this.handshakeParams.getSSLParams().getAllowSSL2() && SSLSocket.supportsSSL2()) {
            this.socket.clientSwap((ClientHelloV2)this.clientHello, (ServerHelloV2)this.serverHello, this.sessionParams);
            this.swappedToSSL2 = true;
            return;
        }
        if (this.serverHello instanceof ServerHelloV2) {
            if (this.handshakeParams.getSSLParams().getAllowSSL2()) {
                throw new SSLException("SSL v2 not supported");
            }
            throw new SSLException("SSL v2 not allowed");
        }
        if (this.record.getSessionState().getSessionID() != null && !this.record.getSessionState().getSessionID().isEmpty() && this.record.getSessionState().getSessionID().equals(this.serverHello.getSessionID()) && this.serverHello.getVersion().equals(this.record.getProtocolVersionOut()) && this.serverHello.getCipherSuite() == this.record.getSessionState().getPendingCS().getCipherSuite()) {
            this.resumed = true;
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Resuming session " + this.record.getSessionState().getSessionID());
                this.record.getSessionState().debugln("Using session params " + this.record.getSessionState().getSessionParams(this.record.getProtocolVersionOut()));
            }
        } else {
            this.verifyServerHello();
        }
    }

    public void erase() throws IOException {
        if (this.clientHello != null) {
            this.clientHello.erase();
        }
        if (this.serverHello != null) {
            this.serverHello.erase();
        }
        if (this.endHandshake != null) {
            this.endHandshake.erase();
        }
    }

    public HandshakeParams getHandshakeParams() {
        return this.handshakeParams;
    }

    public boolean isInProgress() {
        return this.handshakeInProgress;
    }

    public boolean isPerformed() {
        return this.handshakePerformed;
    }

    public boolean isResumed() {
        return this.resumed;
    }

    private void receiveClientHello() throws IOException {
        if (this.record.isHandshakeType()) {
            this.receiveClientHelloV3();
        } else {
            this.receiveClientHelloV2();
        }
    }

    private void receiveClientHelloV2() throws IOException {
        Message message = this.record.receiveV2(this.handshakeParams);
        if (message.getType() != 1) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.clientHello = (ClientHello)((Object)message);
    }

    private void receiveClientHelloV3() throws IOException {
        Message message = this.record.receive(this.handshakeParams);
        if (message.getType() != 22 || ((HandshakeMessage)message).getBody().getHandshakeType() != 1) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.clientHello = (ClientHello)((Object)((HandshakeMessage)message).getBody());
    }

    private void receiveServerHello() throws IOException {
        SSLParams sSLParams = this.handshakeParams.getSSLParams();
        if ((sSLParams.getAllowSSL2() && SSLSocket.supportsSSL2() || sSLParams.getUseV2Hello()) && !this.renegotiationAndEmptyIS) {
            if (this.record.isServerHelloV2()) {
                try {
                    if (this.record.getSessionState().getDebug()) {
                        this.record.getSessionState().debugln("Attempting to receive a V2 Server Hello");
                    }
                    this.receiveServerHelloV2();
                    if (this.record.getSessionState().getDebug()) {
                        this.record.getSessionState().debugln("Received message: " + this.serverHello);
                    }
                }
                catch (IOException iOException) {
                    if (this.record.getSessionState().getDebug()) {
                        this.record.getSessionState().debugln("Failed to receive a V2 Server Hello, Attempting to receive a V3 ServerHello");
                    }
                    this.receiveServerHelloV3();
                }
            } else {
                if (this.record.isNoCipherErrorV2()) {
                    throw new IOException("Received an SSLv2 NO_CIPHER error message indicating that the server did not have any cipher kinds in common with this client.");
                }
                this.receiveServerHelloV3();
            }
        } else {
            this.receiveServerHelloV3();
        }
    }

    private void receiveServerHelloV2() throws IOException {
        this.serverHello = this.record.readServerHelloV2();
    }

    private void receiveServerHelloV3() throws IOException {
        Message message = this.record.receive(this.handshakeParams);
        if (message.getType() != 22 || ((HandshakeMessage)message).getBody().getHandshakeType() != 2) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.serverHello = (ServerHello)((HandshakeMessage)message).getBody();
        this.record.getConnectionState().setPeerRandom(this.serverHello.getRandom());
        if (!this.handshakeParams.acceptableVersion(this.serverHello.getVersion())) {
            AlertException alertException = new AlertException("Unacceptable protocol version", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.PROTOCOL_VERSION));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Proceeding with SSL3 handshake");
            this.record.getSessionState().debugln("state.sessionID = " + this.record.getSessionState().getSessionID() + ", serverHello.sessionID = " + this.serverHello.getSessionID() + ", state.currentCS.cipherSuite = " + this.record.getSessionState().getCurrentCS().getCipherSuite() + ", sh.cipherSuite = " + this.serverHello.getCipherSuite());
        }
    }

    private void sendClientHello() throws IOException {
        SSLParams sSLParams = this.handshakeParams.getSSLParams();
        if (!this.renegotiation) {
            this.sessionParams = sSLParams.getSessionParams();
            if (sSLParams.getResumableSessions() && this.sessionParams == null) {
                ClientSessionCache clientSessionCache = sSLParams.getClientSessionCache();
                if (clientSessionCache == null && (clientSessionCache = SSLParams.getGlobalClientSessionCache()) == null) {
                    clientSessionCache = new HashtableSessionCache();
                    SSLParams.setGlobalClientSessionCache(clientSessionCache);
                }
                if (this.record.getSessionState().getDebug()) {
                    this.record.getSessionState().debugln("Checking for a session on: Server: " + this.socket.getServerName() + " Port: " + this.socket.getPort());
                }
                this.sessionParams = clientSessionCache.getSession(this.socket.getServerName(), this.socket.getPort());
            }
        } else {
            this.sessionParams = null;
        }
        if ((sSLParams.getAllowSSL2() && SSLSocket.supportsSSL2() || sSLParams.getUseV2Hello()) && !this.renegotiationAndEmptyIS && (this.sessionParams == null || this.sessionParams.getProtocolVersion().equals(ProtocolVersion.SSL2))) {
            this.buildClientHelloV2();
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Sending V2 client hello: " + this.clientHello);
            }
            this.record.sendClientHelloV2((ClientHelloV2)this.clientHello, this.handshakeParams);
            this.record.getConnectionState().setOwnRandom(this.clientHello.getRandom());
            this.handshakeParams.setLatestClientVersion(this.clientHello.getVersion());
            return;
        }
        if (this.sessionParams != null) {
            this.record.setSessionParams(this.sessionParams);
        }
        this.clientHello = new ClientHelloV3(this.record.getProtocolVersionOut(), this.handshakeParams.getSSLParams().getClientCipherSuites(), this.handshakeParams.getRNG(), this.record.getSessionState().getSessionID(), this.record.getSessionState());
        this.record.getConnectionState().setOwnRandom(this.clientHello.getRandom());
        this.record.send(new HandshakeMessage((ClientHelloV3)this.clientHello), this.handshakeParams);
        this.handshakeParams.setLatestClientVersion(this.record.getProtocolVersionOut());
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("V3 client hello sent: " + this.clientHello);
        }
    }

    private void sendHelloRequest() throws IOException {
        this.record.send(new HandshakeMessage(new HelloRequest()));
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Hello Request sent");
        }
    }

    private void sendServerHello() throws IOException {
        this.serverHello = new ServerHello(this.handshakeParams.getRNG());
        this.serverHello.setParams(this.record.getProtocolVersionOut(), this.record.getSessionState().getPendingCS().getCipherSuite(), this.record.getSessionState().getSessionID());
        this.record.getConnectionState().setOwnRandom(this.serverHello.getRandom());
        this.record.send(new HandshakeMessage(this.serverHello), this.handshakeParams);
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Server hello sent: " + this.serverHello);
        }
    }

    private void serverInit() throws IOException {
        this.handshakeInProgress = true;
        this.resumed = false;
        if (this.renegotiationAndEmptyIS) {
            this.record.emptyIS(this.recordIS);
        }
        if (this.clientHello == null) {
            this.receiveClientHello();
        }
        if (this.clientHello instanceof ClientHelloV2 && this.handshakeParams.getSSLParams().getAllowSSL2() && SSLSocket.supportsSSL2()) {
            if (this.clientHello.getVersion().equals(ProtocolVersion.SSL2)) {
                this.socket.serverSwap((ClientHelloV2)this.clientHello);
                this.swappedToSSL2 = true;
                return;
            }
            if (this.clientHello.getVersion().equals(ProtocolVersion.TLS1) && !this.handshakeParams.getSSLParams().getAllowSSL3() && !this.handshakeParams.getSSLParams().getAllowTLS1()) {
                this.socket.serverSwap((ClientHelloV2)this.clientHello);
                this.swappedToSSL2 = true;
                return;
            }
            if (this.clientHello.getVersion().equals(ProtocolVersion.SSL3) && !this.handshakeParams.getSSLParams().getAllowSSL3()) {
                this.socket.serverSwap((ClientHelloV2)this.clientHello);
                this.swappedToSSL2 = true;
                return;
            }
        }
        this.verifyClientHello();
        this.checkServerSessionIDCached();
        if (this.handshakeParams.getSSLParams().getResumableSessions() && !this.resumed) {
            this.sessionID = new SessionID(this.handshakeParams.getRNG());
            this.record.getSessionState().setSessionID(this.sessionID);
        } else if (!this.resumed) {
            this.record.getSessionState().setSessionID(new SessionID());
        }
        if (!this.resumed) {
            this.chooseCipherSuite();
        } else if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Resuming session " + this.record.getSessionState().getSessionID());
        }
        this.sendServerHello();
    }

    public void setClientHello(Message message) throws IOException {
        this.clientHello = (ClientHello)((Object)((HandshakeMessage)message).getBody());
        this.handshakeParams.addMessage(Utils.toBytes((Streamable)message));
    }

    public void startHandshake() throws IOException {
        try {
            this.handshakePerformed = false;
            this.handshakeInProgress = true;
            this.resumed = false;
            if (this.handshakeParams.isClient()) {
                this.clientInit();
            } else {
                this.serverInit();
            }
            if (this.swappedToSSL2) {
                this.handshakePerformed = true;
                this.handshakeInProgress = false;
                return;
            }
            this.endHandshake = this.record.getProtocolVersionOut().equals(ProtocolVersion.TLS1) ? new HandshakeV31(this.record, this.handshakeParams, this.clientHello, this.serverHello, this.resumed, this.sslCrypto) : new HandshakeV3(this.record, this.handshakeParams, this.clientHello, this.serverHello, this.resumed, this.sslCrypto);
            if (this.handshakeParams.isClient()) {
                this.endHandshake.setServerNameAndPort(this.serverName, this.port);
            }
            this.endHandshake.finishHandshake();
            this.handshakeInProgress = false;
            this.handshakePerformed = true;
        }
        catch (AlertException alertException) {
            if (this.record.getProtocolVersionOut().equals(ProtocolVersion.TLS1)) {
                if (alertException.getAlertSSL_TLS() != null) {
                    this.record.send(alertException.getAlertSSL_TLS());
                } else if (alertException.getAlertTLS1() != null) {
                    this.record.send(alertException.getAlertTLS1());
                }
            } else if (alertException.getAlertSSL_TLS() != null) {
                this.record.send(alertException.getAlertSSL_TLS());
            } else if (alertException.getAlertSSL3() != null) {
                this.record.send(alertException.getAlertSSL3());
            }
            this.record.erase();
            this.erase();
            if (alertException.getExceptionType() == 0) {
                throw new SSLException(alertException.toString());
            }
            if (alertException.getExceptionType() == 1) {
                throw new BadMACException(alertException.toString());
            }
            throw new RuntimeException(alertException.toString());
        }
        catch (SSLException sSLException) {
            if (this.handshakeParams.isClient() && sSLException.getError() != null && this.endHandshake != null && this.endHandshake.getCertificateRequest() != null && (sSLException.getError().getValue() == Alert.Error.NO_CERTIFICATE.getValue() || sSLException.getError().getValue() == Alert.Error.BAD_CERTIFICATE.getValue() || sSLException.getError().getValue() == Alert.Error.UNSUPPORTED_CERTIFICATE.getValue() || sSLException.getError().getValue() == Alert.Error.CERTIFICATE_REVOKED.getValue() || sSLException.getError().getValue() == Alert.Error.CERTIFICATE_EXPIRED.getValue() || sSLException.getError().getValue() == Alert.Error.CERTIFICATE_UNKNOWN.getValue() || sSLException.getError().getValue() == Alert.Error.UNKNOWN_CA.getValue())) {
                ClientAuthenticationException clientAuthenticationException = new ClientAuthenticationException(sSLException.toString());
                clientAuthenticationException.setRootCAsNames(this.endHandshake.getCertificateRequest().cas());
                throw clientAuthenticationException;
            }
            this.record.erase();
            this.erase();
            throw sSLException;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.record.erase();
            this.erase();
            throw iOException;
        }
    }

    public void startRenegotiation(boolean bl, RecordInputStream recordInputStream) throws IOException {
        this.recordIS = recordInputStream;
        if (!bl && !this.handshakeParams.isClient()) {
            this.sendHelloRequest();
        }
        if (!bl) {
            this.renegotiationAndEmptyIS = true;
        }
        this.renegotiation = true;
        this.startHandshake();
        this.renegotiation = false;
        this.renegotiationAndEmptyIS = false;
        this.recordIS = null;
    }

    private void verifyClientHello() throws IOException {
        if (!this.handshakeParams.acceptableVersion(this.clientHello.getVersion())) {
            AlertException alertException = new AlertException("Unacceptable protocol version", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.PROTOCOL_VERSION));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        this.record.setProtocolVersionOut(this.handshakeParams.getProtocolVersionServer(this.clientHello.getVersion()));
        this.handshakeParams.setLatestClientVersion(this.clientHello.getVersion());
        this.record.getConnectionState().setPeerRandom(this.clientHello.getRandom());
        this.record.getSessionState().setSessionID(this.clientHello.getSessionID());
    }

    private void verifyServerHello() throws IOException {
        this.record.getSessionState().setSessionID(this.serverHello.getSessionID());
        this.record.setProtocolVersionOut(this.serverHello.getVersion());
        if (!this.handshakeParams.supportedCS(this.serverHello.getCipherSuite())) {
            throw new AlertException("Unsupported ciphersuites requested", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Using ciphersuite " + Integer.toString(this.serverHello.getCipherSuite(), 16));
        }
        this.record.getSessionState().setPendingCS(new CipherSpec(this.serverHello.getCipherSuite(), this.record.getProtocolVersionOut(), this.sslCrypto));
    }
}

