/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.CertificateRequest;
import com.phaos.SSL.CertificateVerify;
import com.phaos.SSL.ClientHelloV3;
import com.phaos.SSL.ClientKeyExchange;
import com.phaos.SSL.ConnectionState;
import com.phaos.SSL.FinishedV3;
import com.phaos.SSL.FinishedV31;
import com.phaos.SSL.HandshakeParams;
import com.phaos.SSL.HelloRequest;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.ServerHello;
import com.phaos.SSL.ServerHelloDone;
import com.phaos.SSL.ServerKeyExchange;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

abstract class HandshakeBody
implements Streamable {
    public static final int HELLO_REQUEST = 0;
    public static final int CLIENT_HELLO = 1;
    public static final int SERVER_HELLO = 2;
    public static final int CERTIFICATE = 11;
    public static final int SERVER_KEY_EXCHANGE = 12;
    public static final int CERTIFICATE_REQUEST = 13;
    public static final int SERVER_DONE = 14;
    public static final int CERTIFICATE_VERIFY = 15;
    public static final int CLIENT_KEY_EXCHANGE = 16;
    public static final int FINISHED = 20;

    HandshakeBody() {
    }

    public abstract int getHandshakeType();

    public abstract void input(InputStream var1) throws IOException;

    static HandshakeBody inputInstance(InputStream inputStream, int n, int n2) throws IOException {
        switch (n) {
            case 0: {
                return new HelloRequest();
            }
            case 1: {
                return new ClientHelloV3(inputStream, n2);
            }
            case 2: {
                return new ServerHello(inputStream);
            }
        }
        throw new AlertException("Unexpected or unrecognized message" + n, "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
    }

    static HandshakeBody inputInstance(InputStream inputStream, int n, int n2, ProtocolVersion protocolVersion, SessionState sessionState, ConnectionState connectionState, HandshakeParams handshakeParams) throws IOException {
        switch (n) {
            case 0: {
                return new HelloRequest();
            }
            case 1: {
                return new ClientHelloV3(inputStream, n2);
            }
            case 2: {
                return new ServerHello(inputStream);
            }
            case 11: {
                if (handshakeParams.isClient()) {
                    return new SSLCertificate(handshakeParams.getSSLParams().getRootCAFingerprints(), handshakeParams.getServerName(), handshakeParams.getSSLCrypto(), inputStream);
                }
                return new SSLCertificate(handshakeParams.getSSLParams().getRootCAFingerprints(), handshakeParams.getServerName(), handshakeParams.getSSLCrypto(), inputStream);
            }
            case 12: {
                return new ServerKeyExchange(sessionState.getPendingCS(), connectionState.getOwnRandom(), connectionState.getPeerRandom(), sessionState.getPeerCert(), handshakeParams.getSSLCrypto(), inputStream);
            }
            case 13: {
                return new CertificateRequest(inputStream);
            }
            case 14: {
                return new ServerHelloDone(inputStream);
            }
            case 15: {
                CertificateVerify certificateVerify = CertificateVerify.getCertificateVerify(protocolVersion);
                certificateVerify.initialize(handshakeParams.getMessageRecord(), sessionState.getMasterSecret(), sessionState.getPeerCert().getPublicKey(), handshakeParams.getSSLCrypto(), inputStream, sessionState);
                return certificateVerify;
            }
            case 16: {
                if (sessionState.getPendingCS().getKeyExchange() != 2) {
                    Object object = sessionState.getPendingCS().getWriteCipher().getIsExportable() && Utils.length((BigInteger)((RSAPublicKey)sessionState.getCert().getBottomCert().getPublicKey()).getModulus()) > sessionState.getPendingCS().getWriteCipher().getMaxExportableKeySize() && handshakeParams.getSSLParams().getTempKey() != null ? handshakeParams.getSSLParams().getTempKey() : sessionState.getCert().getPrivateKey();
                    ClientKeyExchange clientKeyExchange = ClientKeyExchange.getClientKeyExchange(protocolVersion);
                    clientKeyExchange.initialize(sessionState.getPendingCS(), handshakeParams.getLatestClientVersion(), (PrivateKey)object, n2, handshakeParams.getRNG(), handshakeParams.getSSLCrypto(), handshakeParams.getSSLParams().getPMSCompatibility(), inputStream);
                    return clientKeyExchange;
                }
                ClientKeyExchange clientKeyExchange = ClientKeyExchange.getClientKeyExchange(protocolVersion);
                clientKeyExchange.initialize(sessionState.getPendingCS(), handshakeParams.getLatestClientVersion(), handshakeParams.getRNG(), handshakeParams.getSSLCrypto(), handshakeParams.getSSLParams().getPMSCompatibility(), inputStream);
                return clientKeyExchange;
            }
            case 20: {
                if (protocolVersion.equals(ProtocolVersion.TLS1)) {
                    return new FinishedV31(handshakeParams.isClient() ^ true, handshakeParams.getMessageRecord(), sessionState.getMasterSecret(), handshakeParams.getSSLCrypto(), inputStream);
                }
                return new FinishedV3(handshakeParams.isClient() ^ true, handshakeParams.getMessageRecord(), sessionState.getMasterSecret(), handshakeParams.getSSLCrypto(), inputStream);
            }
        }
        throw new AlertException("Unrecognized type" + n, "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
    }

    public abstract int length();

    public abstract void output(OutputStream var1) throws IOException;

    public abstract String toString();
}

