/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.ConnectionState;
import com.phaos.SSL.HandshakeBody;
import com.phaos.SSL.HandshakeParams;
import com.phaos.SSL.Message;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SessionState;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class HandshakeMessage
extends Message {
    private static final int type = 22;
    private HandshakeBody body;

    public HandshakeMessage(HandshakeBody handshakeBody) {
        this.body = handshakeBody;
    }

    public HandshakeMessage(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = Utils.input24bit((InputStream)inputStream);
        this.body = HandshakeBody.inputInstance(inputStream, n, n2);
    }

    public HandshakeMessage(InputStream inputStream, ProtocolVersion protocolVersion, SessionState sessionState, ConnectionState connectionState, HandshakeParams handshakeParams) throws IOException {
        int n = inputStream.read();
        int n2 = Utils.input24bit((InputStream)inputStream);
        this.body = HandshakeBody.inputInstance(inputStream, n, n2, protocolVersion, sessionState, connectionState, handshakeParams);
    }

    public HandshakeBody getBody() {
        return this.body;
    }

    public int getType() {
        return 22;
    }

    public void input(InputStream inputStream) throws IOException {
        throw new RuntimeException("Invalid use of HandshakeMessage.input");
    }

    public int length() {
        return 4 + this.body.length();
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.body.getHandshakeType());
        Utils.output24bit((int)this.body.length(), (OutputStream)outputStream);
        this.body.output(outputStream);
    }

    public String toString() {
        return "Handshake message: " + this.body;
    }
}

