/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.SSLParams;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import java.io.IOException;

class HandshakeParams {
    private SSLCrypto sslCrypto;
    private PrivateKey tempPrivateKey;
    private byte[] messageRecorded;
    private UnsyncByteArrayOutputStream messageRecordedOS;
    private boolean client;
    private boolean certRequested;
    private SSLParams params;
    private ProtocolVersion latestClientVersion;
    private String serverName;
    private RandomBitsSource rbs;

    public HandshakeParams(SSLParams sSLParams, boolean bl, SSLCrypto sSLCrypto) throws IOException {
        this.client = bl;
        this.sslCrypto = sSLCrypto;
        this.setParams(sSLParams);
        this.messageRecordedOS = new UnsyncByteArrayOutputStream();
    }

    public final boolean acceptableVersion(ProtocolVersion protocolVersion) throws SSLException {
        int n = protocolVersion.getMajor();
        int n2 = protocolVersion.getMinor();
        if (protocolVersion.equals(ProtocolVersion.SSL3) && this.params.getAllowSSL3()) {
            return true;
        }
        if (protocolVersion.equals(ProtocolVersion.TLS1) && (this.params.getAllowTLS1() || this.params.getAllowSSL3())) {
            return true;
        }
        return !protocolVersion.equals(ProtocolVersion.SSL3) && n >= 3 && (this.params.getAllowTLS1() || this.params.getAllowSSL3());
    }

    public final void addMessage(byte[] byArray) throws IOException {
        try {
            this.messageRecordedOS.write(byArray);
        }
        catch (IOException iOException) {
            AlertException alertException = new AlertException(iOException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public final boolean getCertRequested() {
        return this.certRequested;
    }

    public final ProtocolVersion getLatestClientVersion() {
        return this.latestClientVersion;
    }

    public final byte[] getMessageRecord() {
        return this.messageRecordedOS.toByteArray();
    }

    public final ProtocolVersion getProtocolVersionServer(ProtocolVersion protocolVersion) throws SSLException {
        int n = protocolVersion.getMajor();
        int n2 = protocolVersion.getMinor();
        if (this.params.getAllowTLS1() && n >= 3 && n2 >= 1) {
            return ProtocolVersion.TLS1;
        }
        if (this.params.getAllowSSL3() && n >= 3 && n2 >= 0) {
            return ProtocolVersion.SSL3;
        }
        if (this.params.getAllowSSL2() && n >= 2 && n2 >= 0) {
            return ProtocolVersion.SSL2;
        }
        AlertException alertException = new AlertException("Unacceptable protocol version", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.PROTOCOL_VERSION));
        alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
        throw alertException;
    }

    public final RandomBitsSource getRNG() {
        return this.rbs;
    }

    public final SSLCrypto getSSLCrypto() {
        return this.sslCrypto;
    }

    public final SSLParams getSSLParams() {
        return this.params;
    }

    public final String getServerName() {
        return this.serverName;
    }

    public final boolean isClient() {
        return this.client;
    }

    public final void setCertRequested(boolean bl) {
        this.certRequested = bl;
    }

    public final void setClient(boolean bl) {
        this.client = bl;
    }

    public final void setLatestClientVersion(ProtocolVersion protocolVersion) {
        this.latestClientVersion = protocolVersion;
    }

    public final void setParams(SSLParams sSLParams) throws IOException {
        this.params = sSLParams;
        this.rbs = this.sslCrypto.getRBS(sSLParams.getRNG());
        this.latestClientVersion = this.client ? sSLParams.getProtocolVersion() : null;
    }

    public final void setSSLParams(SSLParams sSLParams) {
        this.params = sSLParams;
    }

    public final void setServerName(String string) {
        this.serverName = string;
    }

    public final boolean supportedCS(short s) {
        short[] sArray = this.client ? this.params.getClientCipherSuites() : this.params.getServerCipherSuites();
        return this.supportedCS(sArray, s);
    }

    public final boolean supportedCS(short[] sArray, short s) {
        int n = 0;
        while (n < sArray.length) {
            if (s == sArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

