/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.CertificateRequest;
import com.phaos.SSL.CertificateVerify;
import com.phaos.SSL.ChangeCipherSpec;
import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.ClientHello;
import com.phaos.SSL.ClientKeyExchange;
import com.phaos.SSL.ClientSessionCache;
import com.phaos.SSL.Finished;
import com.phaos.SSL.FinishedV3;
import com.phaos.SSL.HandshakeMessage;
import com.phaos.SSL.HandshakeParams;
import com.phaos.SSL.HashtableSessionCache;
import com.phaos.SSL.Message;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Record;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLCertificateVerifier;
import com.phaos.SSL.SSLCipher;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SSLParams;
import com.phaos.SSL.Secrets;
import com.phaos.SSL.ServerHello;
import com.phaos.SSL.ServerHelloDone;
import com.phaos.SSL.ServerKeyExchange;
import com.phaos.SSL.ServerSessionCache;
import com.phaos.SSL.SessionParams;
import com.phaos.cert.IssuerAndSerialNo;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

class HandshakeV3 {
    protected HandshakeParams handshakeParams;
    protected Record record;
    protected SSLCrypto sslCrypto;
    private boolean resumed;
    protected ClientHello clientHello;
    protected ServerHello serverHello;
    protected ClientKeyExchange clientKeyExchange;
    protected ServerKeyExchange serverKeyExchange;
    protected CertificateRequest certificateRequest;
    protected CertificateVerify certificateVerify;
    protected ServerHelloDone serverHelloDone;
    protected Finished finished;
    protected Secrets secrets;
    private String serverName;
    private int port;

    public HandshakeV3(Record record, HandshakeParams handshakeParams, ClientHello clientHello, ServerHello serverHello, boolean bl, SSLCrypto sSLCrypto) throws IOException {
        this.record = record;
        this.handshakeParams = handshakeParams;
        this.clientHello = clientHello;
        this.serverHello = serverHello;
        this.resumed = bl;
        this.sslCrypto = sSLCrypto;
        this.createSecrets();
    }

    public void cacheClientSession() {
        SSLParams sSLParams = this.handshakeParams.getSSLParams();
        if (!sSLParams.getResumableSessions()) {
            return;
        }
        ClientSessionCache clientSessionCache = sSLParams.getClientSessionCache();
        if (clientSessionCache == null && (clientSessionCache = SSLParams.getGlobalClientSessionCache()) == null) {
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Creating a new global client session cache");
            }
            clientSessionCache = new HashtableSessionCache();
            SSLParams.setGlobalClientSessionCache(clientSessionCache);
        }
        SessionParams sessionParams = this.record.getSessionParams();
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Client Session Params added to cache: Server Name: " + this.serverName + " Port: " + this.port + " SessionID: " + sessionParams.getSessionID());
        }
        clientSessionCache.addSession(this.serverName, this.port, sessionParams);
    }

    public void cacheServerSession() {
        SSLParams sSLParams = this.handshakeParams.getSSLParams();
        if (!sSLParams.getResumableSessions()) {
            return;
        }
        ServerSessionCache serverSessionCache = sSLParams.getServerSessionCache();
        if (serverSessionCache == null) {
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Creating a new ServerSessionCache instance");
            }
            serverSessionCache = new HashtableSessionCache();
            sSLParams.setServerSessionCache(serverSessionCache);
        }
        SessionParams sessionParams = this.record.getSessionParams();
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Server session params added to cache: SessionID: " + sessionParams.getSessionID());
        }
        serverSessionCache.addSession(sessionParams);
    }

    private void clientFinishHandshake() throws IOException {
        if (!this.resumed) {
            this.receiveServerMessages();
            if (this.handshakeParams.getCertRequested()) {
                this.sendClientCertificate();
            }
            this.sendClientKeyExchange();
            this.computeMasterSecret();
            if (this.handshakeParams.getCertRequested() && this.record.getSessionState().getCert() != null) {
                this.sendCertificateVerify();
            }
            this.record.sendBufferedMessages();
            this.computeSecrets();
            this.sendChangeCipherSpec();
            this.setPendingWriteCS(false);
            this.sendFinished();
            this.receiveChangeCipherSpec();
            this.setPendingReadCS(true);
            this.receiveFinished();
            if (this.handshakeParams.getSSLParams().getResumableSessions()) {
                this.cacheClientSession();
            }
        } else {
            this.computeSecrets();
            this.receiveChangeCipherSpec();
            this.setPendingReadCS(false);
            this.receiveFinished();
            this.sendChangeCipherSpec();
            this.setPendingWriteCS(true);
            this.sendFinished();
        }
    }

    void computeMasterSecret() throws IOException {
        if (this.record.getSessionState().getPendingCS().getKeyExchange() != 0) {
            if (this.record.getSessionState().getPendingCS().getKeyExchange() == 2) {
                if (this.handshakeParams.isClient()) {
                    this.secrets.setPreMasterSecret(this.clientKeyExchange.dhPreMasterSecret());
                } else {
                    this.secrets.setPreMasterSecret(this.clientKeyExchange.dhPreMasterSecret(this.serverKeyExchange.getDH()));
                }
            } else {
                this.secrets.setPreMasterSecret(this.clientKeyExchange.rsaPreMasterSecret());
            }
            this.record.getSessionState().setMasterSecret(this.secrets.computeMasterSecret(this.handshakeParams.isClient() ? this.record.getConnectionState().getOwnRandom() : this.record.getConnectionState().getPeerRandom(), this.handshakeParams.isClient() ? this.record.getConnectionState().getPeerRandom() : this.record.getConnectionState().getOwnRandom()));
            this.clientKeyExchange.erasePMS();
        } else {
            this.record.getSessionState().setMasterSecret(new SymmetricKey(new byte[0]));
        }
    }

    void computeSecrets() throws IOException {
        this.secrets.computeSecrets(this.record.getSessionState().getMasterSecret(), this.record.getSessionState().getPendingCS(), this.handshakeParams.isClient(), this.record.getConnectionState().getOwnRandom(), this.record.getConnectionState().getPeerRandom());
        this.record.getConnectionState().setSecrets(this.secrets);
        this.secrets.erase();
    }

    void createSecrets() throws IOException {
        this.secrets = Secrets.getSecret(ProtocolVersion.SSL3, this.sslCrypto, this.record.getSessionState());
    }

    void erase() throws IOException {
        if (this.clientHello != null) {
            this.clientHello.erase();
        }
        if (this.serverHello != null) {
            this.serverHello.erase();
        }
        if (this.clientKeyExchange != null) {
            this.clientKeyExchange.erase();
        }
        if (this.serverKeyExchange != null) {
            this.serverKeyExchange.erase();
        }
        if (this.certificateVerify != null) {
            this.certificateVerify.erase();
        }
    }

    public void finishHandshake() throws IOException {
        if (this.handshakeParams.isClient()) {
            this.clientFinishHandshake();
        } else {
            this.serverFinishHandshake();
        }
    }

    CertificateRequest getCertificateRequest() {
        return this.certificateRequest;
    }

    int processIncomingClientMessage(int[] nArray, Message message) throws IOException {
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Message type: " + message.getType());
        }
        boolean bl = false;
        HandshakeMessage handshakeMessage = null;
        if (message.getType() == 22) {
            handshakeMessage = (HandshakeMessage)message;
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Handshake Message type: " + handshakeMessage.getBody().getHandshakeType());
            }
            int n = 0;
            while (n < nArray.length && !bl) {
                if (handshakeMessage.getBody().getHandshakeType() == nArray[n]) {
                    bl = true;
                }
                ++n;
            }
        } else if (message.getType() == 21 && ((Alert)message).getError() == Alert.Error.NO_CERTIFICATE) {
            this.record.getSessionState().setPeerCert(null);
            return 11;
        }
        if (!bl) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        switch (handshakeMessage.getBody().getHandshakeType()) {
            case 11: {
                this.record.getSessionState().setPeerCert((SSLCertificate)handshakeMessage.getBody());
                this.receiveClientCertificate();
                break;
            }
            case 16: {
                this.clientKeyExchange = (ClientKeyExchange)handshakeMessage.getBody();
                this.receiveClientKeyExchange();
                break;
            }
            case 15: {
                this.certificateVerify = (CertificateVerify)handshakeMessage.getBody();
                break;
            }
        }
        return handshakeMessage.getBody().getHandshakeType();
    }

    int processIncomingServerMessage(int[] nArray, Message message) throws IOException {
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Message type: " + message.getType());
        }
        boolean bl = false;
        HandshakeMessage handshakeMessage = null;
        if (message.getType() == 22) {
            handshakeMessage = (HandshakeMessage)message;
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Handshake Message type: " + handshakeMessage.getBody().getHandshakeType());
            }
            int n = 0;
            while (n < nArray.length && !bl) {
                if (handshakeMessage.getBody().getHandshakeType() == nArray[n]) {
                    bl = true;
                }
                ++n;
            }
        }
        if (!bl) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        switch (handshakeMessage.getBody().getHandshakeType()) {
            case 11: {
                this.record.getSessionState().setPeerCert((SSLCertificate)handshakeMessage.getBody());
                this.receiveServerCertificate();
                break;
            }
            case 12: {
                this.serverKeyExchange = (ServerKeyExchange)handshakeMessage.getBody();
                this.receiveServerKeyExchange();
                break;
            }
            case 13: {
                this.certificateRequest = (CertificateRequest)handshakeMessage.getBody();
                this.receiveCertificateRequest();
                break;
            }
            case 14: {
                this.serverHelloDone = (ServerHelloDone)handshakeMessage.getBody();
                this.receiveServerHelloDone();
                break;
            }
        }
        return handshakeMessage.getBody().getHandshakeType();
    }

    void receiveCertificateRequest() throws IOException {
        if (this.record.getSessionState().getPendingCS().getServerCertType() == 0) {
            throw new AlertException("An anonymous server is requesting a client certificate", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.handshakeParams.setCertRequested(true);
    }

    void receiveCertificateVerify() throws IOException {
        ASN1ObjectID aSN1ObjectID;
        if (this.record.getSessionState().getPeerCert() != null && ((aSN1ObjectID = this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID()).equals((Object)AlgID.rsaEncryption.getOID()) || aSN1ObjectID.equals((Object)AlgID.dsaOld.getOID()) || aSN1ObjectID.equals((Object)AlgID.dsa.getOID()))) {
            this.processIncomingClientMessage(new int[]{15}, this.record.receive(this.handshakeParams));
        }
    }

    void receiveChangeCipherSpec() throws IOException {
        Message message = this.record.receive();
        if (message.getType() != 20) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.record.getConnectionState().resetSeqIn();
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("ChangeCipherSpec received");
        }
    }

    void receiveClientCertificate() throws IOException {
        if (!this.handshakeParams.getSSLParams().getRequestClientCert() || this.record.getSessionState().getPendingCS().getServerCertType() == 0) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        if (!(this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID()) || this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsaOld.getOID()) || this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsa.getOID()))) {
            throw new AlertException("Certificate of type " + this.record.getSessionState().getPeerCert().getPublicKey().getAlgID() + " was received instead of RSA or DSA", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNSUPPORTED_CERTIFICATE));
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Client certificate received: " + this.record.getSessionState().getPeerCert());
        }
        this.verifyCertificate(this.record.getSessionState().getPeerCert());
    }

    void receiveClientKeyExchange() throws IOException {
        if (this.record.getSessionState().getPeerCert() == null && this.handshakeParams.getSSLParams().getRequireClientCert()) {
            throw new AlertException("No client certificate received", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
        }
    }

    void receiveClientMessages() throws IOException {
        if (this.record.getSessionState().getPendingCS().getKeyExchange() != 0) {
            this.record.getSessionState().setPeerCert(null);
            this.clientKeyExchange = null;
            int n = this.processIncomingClientMessage(new int[]{11, 16}, this.record.receive(this.handshakeParams));
            if (n == 11) {
                n = this.processIncomingClientMessage(new int[]{16}, this.record.receive(this.handshakeParams));
            }
        }
    }

    void receiveFinished() throws IOException {
        Message message = this.record.receive(this.handshakeParams);
        if (message.getType() != 22 || ((HandshakeMessage)message).getBody().getHandshakeType() != 20) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Received " + message);
        }
    }

    void receiveServerCertificate() throws IOException {
        switch (this.record.getSessionState().getPendingCS().getServerCertType()) {
            case 0: {
                throw new AlertException("An anonymous server sent a certificate", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
            }
            case 1: {
                if (this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID())) break;
                throw new AlertException("Certificate of type " + this.record.getSessionState().getPeerCert().getPublicKey().getAlgorithm() + " was received instead of RSA", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNSUPPORTED_CERTIFICATE));
            }
            case 3: {
                if (this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsa.getOID()) || this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsaOld.getOID())) break;
                throw new AlertException("Certificate of type " + this.record.getSessionState().getPeerCert().getPublicKey().getAlgorithm() + " was received instead of DSA", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNSUPPORTED_CERTIFICATE));
            }
        }
        this.verifyCertificate(this.record.getSessionState().getPeerCert());
    }

    void receiveServerHelloDone() throws IOException {
    }

    void receiveServerKeyExchange() throws IOException {
        if (this.record.getSessionState().getPendingCS().getServerCertType() != 0 && this.record.getSessionState().getPeerCert() == null) {
            throw new AlertException("ServerKeyExchange received before certificate", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
    }

    void receiveServerMessages() throws IOException {
        this.record.getSessionState().setPeerCert(null);
        this.serverKeyExchange = null;
        this.certificateRequest = null;
        this.handshakeParams.setCertRequested(false);
        this.serverHelloDone = null;
        int[] nArray = new int[4];
        nArray[0] = 11;
        nArray[1] = 12;
        nArray[2] = 14;
        int[] nArray2 = nArray;
        int n = 0;
        while (n == 0) {
            n = this.processIncomingServerMessage(nArray2, this.record.receive(this.handshakeParams));
        }
        if (this.record.getSessionState().getPendingCS().getServerCertType() != 0 && this.record.getSessionState().getPeerCert() == null) {
            throw new AlertException("No certificate was received", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
        }
        if (n != 14) {
            int[] nArray3 = new int[4];
            nArray3[0] = 12;
            nArray3[1] = 13;
            nArray3[2] = 14;
            nArray2 = nArray3;
            n = 0;
            while (n == 0) {
                n = this.processIncomingServerMessage(nArray2, this.record.receive(this.handshakeParams));
            }
        }
        if (this.record.getSessionState().getPendingCS().getKeyExchange() == 2 && this.serverKeyExchange == null) {
            throw new AlertException("No serverKeyExchange was received for DH", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
        }
        if (n != 14) {
            int[] nArray4 = new int[3];
            nArray4[0] = 13;
            nArray4[1] = 14;
            nArray2 = nArray4;
            n = 0;
            while (n == 0) {
                n = this.processIncomingServerMessage(nArray2, this.record.receive(this.handshakeParams));
            }
        }
        if (n != 14) {
            int[] nArray5 = new int[2];
            nArray5[0] = 14;
            nArray2 = nArray5;
            n = 0;
            while (n == 0) {
                n = this.processIncomingServerMessage(nArray2, this.record.receive(this.handshakeParams));
            }
        }
    }

    public void removeSession() {
        if (this.handshakeParams.isClient() && this.handshakeParams.getSSLParams().getServerSessionCache() != null && this.record.getSessionState().getSessionID() != null) {
            this.handshakeParams.getSSLParams().getServerSessionCache().removeSession(this.record.getSessionState().getSessionID());
        } else if (this.handshakeParams.isClient() && this.handshakeParams.getSSLParams().getClientSessionCache() != null && this.serverName != null) {
            this.handshakeParams.getSSLParams().getClientSessionCache().removeSession(this.serverName, this.port);
        }
    }

    void sendCertificateRequest() throws IOException {
        if (this.handshakeParams.getSSLParams().getRequestClientCert() && this.record.getSessionState().getPendingCS().getServerCertType() != 0) {
            this.certificateRequest = new CertificateRequest(this.handshakeParams.getSSLParams().getClientCertTypes(), this.handshakeParams.getSSLParams().getClientRootCAs());
            this.record.addToSend(new HandshakeMessage(this.certificateRequest), this.handshakeParams);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Certificate request sent: " + this.certificateRequest);
            }
        }
    }

    void sendCertificateVerify() throws IOException {
        this.certificateVerify = CertificateVerify.getCertificateVerify(ProtocolVersion.SSL3);
        this.certificateVerify.initialize(this.handshakeParams.getMessageRecord(), this.record.getSessionState().getMasterSecret(), this.record.getSessionState().getCert().getPrivateKey(), this.handshakeParams.getRNG(), this.sslCrypto, this.record.getSessionState());
        this.record.addToSend(new HandshakeMessage(this.certificateVerify), this.handshakeParams);
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("CertificateVerify sent: " + this.certificateVerify);
        }
    }

    void sendChangeCipherSpec() throws IOException {
        if (this.record.isAvailable() && this.record.isAlertType()) {
            this.record.receive();
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.record.send(new ChangeCipherSpec());
        this.record.getConnectionState().resetSeqOut();
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("ChangeCipherSpec sent");
        }
    }

    void sendClientCertificate() throws IOException {
        Vector vector = this.handshakeParams.getSSLParams().getClientCerts();
        X500Name[] x500NameArray = this.certificateRequest.cas();
        if (vector == null || vector.size() == 0) {
            this.record.getSessionState().setCert(null);
        } else if (x500NameArray.length == 0 && this.handshakeParams.getSSLParams().getRequireAcceptableClientRootCAs()) {
            this.record.getSessionState().setCert(null);
        } else if (x500NameArray.length == 0 && !this.handshakeParams.getSSLParams().getRequireAcceptableClientRootCAs()) {
            this.record.getSessionState().setCert((SSLCertificate)vector.elementAt(0));
        } else {
            boolean bl = false;
            int n = 0;
            while (n < vector.size() && !bl) {
                SSLCertificate sSLCertificate = (SSLCertificate)vector.elementAt(n);
                int n2 = 0;
                while (n2 < x500NameArray.length && !bl) {
                    if (x500NameArray[n2].equals((Object)sSLCertificate.rootCA().getSubject())) {
                        this.record.getSessionState().setCert(sSLCertificate);
                        bl = true;
                    }
                    ++n2;
                }
                ++n;
            }
            if (!bl && this.handshakeParams.getSSLParams().getRequireAcceptableClientRootCAs()) {
                this.record.getSessionState().setCert(null);
            } else if (!bl && !this.handshakeParams.getSSLParams().getRequireAcceptableClientRootCAs()) {
                this.record.getSessionState().setCert((SSLCertificate)vector.elementAt(0));
            }
        }
        if (this.record.getSessionState().getCert() == null) {
            this.record.send(new Alert(Alert.Level.WARNING, Alert.Error.NO_CERTIFICATE));
        } else {
            this.record.addToSend(new HandshakeMessage(this.record.getSessionState().getCert()), this.handshakeParams);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Certificate sent: " + this.record.getSessionState().getCert());
            }
        }
    }

    void sendClientKeyExchange() throws IOException {
        this.clientKeyExchange = ClientKeyExchange.getClientKeyExchange(ProtocolVersion.SSL3);
        if (this.record.getSessionState().getPendingCS().getKeyExchange() != 0) {
            if (this.record.getSessionState().getPendingCS().getKeyExchange() == 2) {
                this.clientKeyExchange.initialize(this.serverKeyExchange.getP(), this.serverKeyExchange.getG(), this.serverKeyExchange.getGx(), this.handshakeParams.getRNG(), this.sslCrypto);
            } else {
                this.clientKeyExchange.initialize((PublicKey)(this.serverKeyExchange == null ? this.record.getSessionState().getPeerCert().getPublicKey() : this.serverKeyExchange.getPublicKey()), this.handshakeParams.getLatestClientVersion(), this.handshakeParams.getRNG(), this.sslCrypto);
            }
            this.record.addToSend(new HandshakeMessage(this.clientKeyExchange), this.handshakeParams);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("ClientKeyExchange sent: " + this.clientKeyExchange);
            }
        }
    }

    void sendFinished() throws IOException {
        this.finished = new FinishedV3(this.handshakeParams.isClient(), this.handshakeParams.getMessageRecord(), this.record.getSessionState().getMasterSecret(), this.sslCrypto);
        if (this.record.isAvailable() && this.record.isAlertType()) {
            this.record.receive();
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.record.send(new HandshakeMessage(this.finished), this.handshakeParams);
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Finished sent: " + this.finished);
        }
    }

    void sendServerCertificate() throws IOException {
        if (this.record.getSessionState().getPendingCS().getServerCertType() != 0) {
            if (this.record.getSessionState().getCert() == null) {
                throw new AlertException("No server certificate set", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
            if (this.record.getSessionState().getPendingCS().getServerCertType() == 1 && !this.record.getSessionState().getCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID())) {
                throw new AlertException("RSA server certificate expected, " + this.record.getSessionState().getCert().getPublicKey().getAlgID() + " present", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
            if (this.record.getSessionState().getPendingCS().getServerCertType() == 3 && !this.record.getSessionState().getCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsaOld.getOID()) && !this.record.getSessionState().getCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsa.getOID())) {
                throw new AlertException("DSA server certificate expected, " + this.record.getSessionState().getCert().getPublicKey().getAlgID() + " present", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
            this.record.addToSend(new HandshakeMessage(this.record.getSessionState().getCert()), this.handshakeParams);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Server certificate sent: " + this.record.getSessionState().getCert());
            }
        }
    }

    void sendServerHelloDone() throws IOException {
        this.record.addToSend(new HandshakeMessage(new ServerHelloDone()), this.handshakeParams);
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("ServerHelloDone sent");
        }
    }

    void sendServerKeyExchange() throws IOException {
        if (this.record.getSessionState().getPendingCS().getKeyExchange() == 2) {
            this.serverKeyExchange = new ServerKeyExchange(this.handshakeParams.getRNG(), this.handshakeParams.getSSLParams().getDHModulus(), this.handshakeParams.getSSLParams().getDHGenerator(), this.record.getSessionState().getPendingCS(), this.record.getSessionState().getCert(), this.record.getConnectionState().getOwnRandom(), this.record.getConnectionState().getPeerRandom(), this.sslCrypto);
            this.record.addToSend(new HandshakeMessage(this.serverKeyExchange), this.handshakeParams);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Server key exchange sent: " + this.serverKeyExchange);
            }
        } else if (this.record.getSessionState().getPendingCS().getKeyExchange() == 1 && this.record.getSessionState().getPendingCS().getWriteCipher().getIsExportable() && Utils.length((BigInteger)((RSAPublicKey)this.record.getSessionState().getCert().getBottomCert().getPublicKey()).getModulus()) > this.record.getSessionState().getPendingCS().getWriteCipher().getMaxExportableKeySize() && this.handshakeParams.getSSLParams().getTempKey() != null) {
            RSAPrivateKey rSAPrivateKey = this.handshakeParams.getSSLParams().getTempKey();
            RSAPublicKey rSAPublicKey = new RSAPublicKey(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent());
            this.serverKeyExchange = new ServerKeyExchange(rSAPublicKey, this.record.getSessionState().getPendingCS(), this.record.getSessionState().getCert(), this.record.getConnectionState().getOwnRandom(), this.record.getConnectionState().getPeerRandom(), this.sslCrypto);
            this.record.addToSend(new HandshakeMessage(this.serverKeyExchange), this.handshakeParams);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Server key exchange sent: " + this.serverKeyExchange);
            }
        }
    }

    private void serverFinishHandshake() throws IOException {
        if (!this.resumed) {
            this.sendServerCertificate();
            this.sendServerKeyExchange();
            this.sendCertificateRequest();
            this.sendServerHelloDone();
            this.record.sendBufferedMessages();
            this.receiveClientMessages();
            this.computeMasterSecret();
            this.receiveCertificateVerify();
            this.computeSecrets();
            this.receiveChangeCipherSpec();
            this.setPendingReadCS(false);
            this.receiveFinished();
            this.sendChangeCipherSpec();
            this.setPendingWriteCS(true);
            this.sendFinished();
            if (this.handshakeParams.getSSLParams().getResumableSessions()) {
                this.cacheServerSession();
            }
        } else {
            this.computeSecrets();
            this.sendChangeCipherSpec();
            this.setPendingWriteCS(false);
            this.sendFinished();
            this.receiveChangeCipherSpec();
            this.setPendingReadCS(true);
            this.receiveFinished();
        }
    }

    void setPendingReadCS(boolean bl) throws IOException {
        CipherSpec cipherSpec = this.record.getSessionState().getPendingCS();
        SSLCipher sSLCipher = cipherSpec.getReadCipher();
        sSLCipher.setReadKeyMaterials(this.record.getConnectionState());
        if (bl) {
            this.record.getSessionState().getCurrentCS().getReadCipher().erase();
            this.record.getSessionState().setCurrentCS(this.record.getSessionState().getPendingCS());
            this.record.getSessionState().setPendingCS(null);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("cipherSpec = " + this.record.getSessionState().getCurrentCS());
            }
        } else {
            this.record.getSessionState().getCurrentCS().getReadCipher().erase();
            this.record.getSessionState().getCurrentCS().setReadCipher(sSLCipher);
        }
    }

    void setPendingWriteCS(boolean bl) throws IOException {
        CipherSpec cipherSpec = this.record.getSessionState().getPendingCS();
        SSLCipher sSLCipher = cipherSpec.getWriteCipher();
        sSLCipher.setWriteKeyMaterials(this.record.getConnectionState());
        if (bl) {
            this.record.getSessionState().getCurrentCS().getWriteCipher().erase();
            this.record.getSessionState().setCurrentCS(this.record.getSessionState().getPendingCS());
            this.record.getSessionState().setPendingCS(null);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("cipherSpec = " + this.record.getSessionState().getCurrentCS());
            }
        } else {
            this.record.getSessionState().getCurrentCS().getWriteCipher().erase();
            this.record.getSessionState().getCurrentCS().setWriteCipher(sSLCipher);
        }
    }

    public void setServerNameAndPort(String string, int n) {
        this.serverName = string;
        this.port = n;
    }

    void verifyCertificate(SSLCertificate sSLCertificate) throws IOException {
        block16: {
            Object object;
            Object object2;
            if (sSLCertificate.getCertificateList().size() == 0) {
                return;
            }
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Verifying certificate chain: \n");
                int n = 0;
                while (n < sSLCertificate.getCertificateList().size()) {
                    this.record.getSessionState().debugln(String.valueOf(String.valueOf(sSLCertificate.getCertificateList().elementAt(n))) + "\n");
                    ++n;
                }
            }
            X509 x509 = sSLCertificate.getBottomCert();
            if (this.handshakeParams.getSSLParams().getVerifyHostName() && this.handshakeParams.isClient()) {
                object2 = sSLCertificate.getHostName();
                object = ((X500Name)x509.getHolder()).getCommonName();
                if (object == null || !((String)object2).equals(object)) {
                    throw new AlertException("Certificate contains invalid host name", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.BAD_CERTIFICATE));
                }
            }
            if ((object2 = this.handshakeParams.getSSLParams().getCertificateTrustPolicy()) != null) {
                try {
                    object = object2.makeCertificateVerifier(sSLCertificate.getCertificateList(), null).getValidCertificate(new IssuerAndSerialNo(x509.getIssuer(), x509.getSerialNo()));
                    if (object == null) {
                        throw new AlertException("Certificate is missing", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.CERTIFICATE_UNKNOWN));
                    }
                    break block16;
                }
                catch (AuthenticationException authenticationException) {
                    throw new AlertException(authenticationException.toString(), "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.BAD_CERTIFICATE));
                }
            }
            object = this.handshakeParams.getSSLParams().getCertVerifier();
            ((SSLCertificateVerifier)object).setDebug(this.handshakeParams.getSSLParams().getDebug());
            ((SSLCertificateVerifier)object).setDebugOutputStream(this.handshakeParams.getSSLParams().getDebugOutputStream());
            int n = ((SSLCertificateVerifier)object).verifyCertificate(sSLCertificate);
            switch (n) {
                case 0: {
                    if (!this.record.getSessionState().getDebug()) break;
                    this.record.getSessionState().debugln("Certificate is valid");
                    break;
                }
                case 1: {
                    throw new AlertException("Certificate is invalid", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.BAD_CERTIFICATE));
                }
                case 2: {
                    throw new AlertException("Certificate is unsupported", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNSUPPORTED_CERTIFICATE));
                }
                case 3: {
                    throw new AlertException("Certificate has been revoked", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.CERTIFICATE_REVOKED));
                }
                case 4: {
                    throw new AlertException("Certificate has expired", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.CERTIFICATE_EXPIRED));
                }
                default: {
                    throw new AlertException("Unknown error processing certificate", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.CERTIFICATE_UNKNOWN));
                }
            }
        }
    }
}

