/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.CertificateVerify;
import com.phaos.SSL.ClientHello;
import com.phaos.SSL.ClientKeyExchange;
import com.phaos.SSL.FinishedV31;
import com.phaos.SSL.HandshakeMessage;
import com.phaos.SSL.HandshakeParams;
import com.phaos.SSL.HandshakeV3;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Record;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.Secrets;
import com.phaos.SSL.ServerHello;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.PublicKey;
import java.io.IOException;

class HandshakeV31
extends HandshakeV3 {
    public HandshakeV31(Record record, HandshakeParams handshakeParams, ClientHello clientHello, ServerHello serverHello, boolean bl, SSLCrypto sSLCrypto) throws IOException {
        super(record, handshakeParams, clientHello, serverHello, bl, sSLCrypto);
    }

    void createSecrets() throws IOException {
        this.secrets = Secrets.getSecret(ProtocolVersion.TLS1, this.sslCrypto, this.record.getSessionState());
    }

    void receiveClientCertificate() throws IOException {
        if (!this.handshakeParams.getSSLParams().getRequestClientCert() || this.record.getSessionState().getPendingCS().getServerCertType() == 0) {
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        if (this.record.getSessionState().getPeerCert().getCertificateList().size() == 0) {
            this.record.getSessionState().setPeerCert(null);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("The client certificate chain is empty.");
            }
            return;
        }
        if (!(this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID()) || this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsaOld.getOID()) || this.record.getSessionState().getPeerCert().getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsa.getOID()))) {
            throw new AlertException("Certificate of type " + this.record.getSessionState().getPeerCert().getPublicKey().getAlgID() + " was received instead of RSA or DSA", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNSUPPORTED_CERTIFICATE));
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Client certificate received: " + this.record.getSessionState().getPeerCert());
        }
        this.verifyCertificate(this.record.getSessionState().getPeerCert());
        this.handshakeParams.setLatestClientVersion(this.record.getProtocolVersionIn());
    }

    void sendCertificateVerify() throws IOException {
        this.certificateVerify = CertificateVerify.getCertificateVerify(ProtocolVersion.TLS1);
        this.certificateVerify.initialize(this.handshakeParams.getMessageRecord(), this.record.getSessionState().getMasterSecret(), this.record.getSessionState().getCert().getPrivateKey(), this.handshakeParams.getRNG(), this.sslCrypto, this.record.getSessionState());
        this.record.addToSend(new HandshakeMessage(this.certificateVerify), this.handshakeParams);
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("CertificateVerify sent: " + this.certificateVerify);
        }
    }

    void sendClientKeyExchange() throws IOException {
        if (this.record.getSessionState().getPendingCS().getKeyExchange() != 0) {
            this.clientKeyExchange = ClientKeyExchange.getClientKeyExchange(ProtocolVersion.TLS1);
            if (this.record.getSessionState().getPendingCS().getKeyExchange() == 2) {
                this.clientKeyExchange.initialize(this.serverKeyExchange.getP(), this.serverKeyExchange.getG(), this.serverKeyExchange.getGx(), this.handshakeParams.getRNG(), this.sslCrypto);
            } else {
                this.clientKeyExchange.initialize((PublicKey)(this.serverKeyExchange == null ? this.record.getSessionState().getPeerCert().getPublicKey() : this.serverKeyExchange.getPublicKey()), this.handshakeParams.getLatestClientVersion(), this.handshakeParams.getRNG(), this.sslCrypto);
            }
            this.record.addToSend(new HandshakeMessage(this.clientKeyExchange), this.handshakeParams);
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("ClientKeyExchange sent: " + this.clientKeyExchange);
            }
        }
    }

    void sendFinished() throws IOException {
        this.finished = new FinishedV31(this.handshakeParams.isClient(), this.handshakeParams.getMessageRecord(), this.record.getSessionState().getMasterSecret(), this.sslCrypto);
        if (this.record.isAvailable() && this.record.isAlertType()) {
            this.record.receiveMessage();
            throw new AlertException("Unexpected message", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
        }
        this.record.send(new HandshakeMessage(this.finished), this.handshakeParams);
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Finished sent: " + this.finished);
        }
    }
}

