/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.ClientSessionCache;
import com.phaos.SSL.ServerSessionCache;
import com.phaos.SSL.SessionID;
import com.phaos.SSL.SessionParams;
import com.phaos.utils.Utils;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HashtableSessionCache
implements ClientSessionCache,
ServerSessionCache,
Serializable {
    private long expirationTime;
    private static final long defaultExpirationTime = 86400L;
    private long checkInterval;
    private static final long defaultCheckInterval = 3600L;
    private long nextCheck;
    private Hashtable clientCache;
    private Vector timeOutClientCache;
    private Hashtable serverCache;
    private Vector timeOutServerCache;
    private Object lockServer = new Object();
    private Object lockClient = new Object();
    private Object lockCheck = new Object();

    public HashtableSessionCache() {
        this.setExpirationTime(86400L);
        this.setCheckInterval(3600L);
    }

    public HashtableSessionCache(boolean bl, Hashtable hashtable) {
        this();
        if (bl) {
            this.clientCache = hashtable;
        } else {
            this.serverCache = hashtable;
        }
    }

    public void addSession(SessionParams sessionParams) {
        if (this.serverCache == null) {
            this.serverCache = new Hashtable();
        }
        this.serverCache.put(Utils.toHexString((byte[])sessionParams.sessionID.getID()), sessionParams);
        if (this.timeOutServerCache == null) {
            this.timeOutServerCache = new Vector();
        }
        sessionParams.setExpirationDate(this.expirationTime * 1000L);
        this.timeOutServerCache.addElement(sessionParams);
    }

    public void addSession(String string, int n, SessionParams sessionParams) {
        String string2 = String.valueOf(string) + ":" + n;
        if (this.clientCache == null) {
            this.clientCache = new Hashtable();
        }
        this.clientCache.put(string2, sessionParams);
        if (this.timeOutClientCache == null) {
            this.timeOutClientCache = new Vector();
        }
        sessionParams.setExpirationDate(this.expirationTime * 1000L);
        sessionParams.setServerNameAndPort(string2);
        this.timeOutClientCache.addElement(sessionParams);
    }

    void check() {
        if (this.checkInterval == 0L) {
            return;
        }
        Object object = this.lockCheck;
        synchronized (object) {
            if (new Date().getTime() >= this.nextCheck) {
                this.checkNow();
            }
        }
    }

    public void checkNow() {
        SessionParams sessionParams;
        Object object = this.lockServer;
        synchronized (object) {
            if (this.serverCache == null) {
                this.clearServerSessionCache();
                Object var2_2 = null;
                return;
            }
            if (this.timeOutServerCache != null) {
                while (this.timeOutServerCache.size() > 0 && !(sessionParams = (SessionParams)this.timeOutServerCache.elementAt(0)).verifyExpiration()) {
                    this.serverCache.remove(Utils.toHexString((byte[])sessionParams.getSessionID().getID()));
                    this.timeOutServerCache.removeElementAt(0);
                }
            }
        }
        object = this.lockClient;
        synchronized (object) {
            if (this.clientCache == null) {
                this.clearClientSessionCache();
                Object var2_3 = null;
                return;
            }
            if (this.timeOutClientCache != null) {
                while (this.timeOutClientCache.size() > 0 && !(sessionParams = (SessionParams)this.timeOutClientCache.elementAt(0)).verifyExpiration()) {
                    this.clientCache.remove(sessionParams.getServerNameAndPort());
                    this.timeOutClientCache.removeElement(sessionParams);
                }
            }
        }
        if (this.checkInterval != 0L) {
            this.nextCheck = new Date().getTime() + this.checkInterval * 1000L;
        }
    }

    public synchronized void clearClientSessionCache() {
        Enumeration<Object> enumeration;
        if (this.clientCache != null) {
            enumeration = this.clientCache.elements();
            while (enumeration.hasMoreElements()) {
                ((SessionParams)enumeration.nextElement()).erase();
            }
            this.clientCache.clear();
        }
        if (this.timeOutClientCache != null) {
            enumeration = this.timeOutClientCache.elements();
            while (enumeration.hasMoreElements()) {
                ((SessionParams)enumeration.nextElement()).erase();
            }
            this.timeOutClientCache.removeAllElements();
        }
    }

    public synchronized void clearServerSessionCache() {
        Enumeration<Object> enumeration;
        if (this.serverCache != null) {
            enumeration = this.serverCache.elements();
            while (enumeration.hasMoreElements()) {
                ((SessionParams)enumeration.nextElement()).erase();
            }
            this.serverCache.clear();
        }
        if (this.timeOutServerCache != null) {
            enumeration = this.timeOutServerCache.elements();
            while (enumeration.hasMoreElements()) {
                ((SessionParams)enumeration.nextElement()).erase();
            }
            this.timeOutServerCache.removeAllElements();
        }
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public Hashtable getClientCache() {
        return this.clientCache;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public Hashtable getServerCache() {
        return this.serverCache;
    }

    public SessionParams getSession(SessionID sessionID) {
        if (this.serverCache == null) {
            return null;
        }
        this.check();
        SessionParams sessionParams = (SessionParams)this.serverCache.get(Utils.toHexString((byte[])sessionID.getID()));
        if (sessionParams != null) {
            return sessionParams.verifyExpiration() ? sessionParams : null;
        }
        return null;
    }

    public SessionParams getSession(String string, int n) {
        if (this.clientCache == null) {
            return null;
        }
        this.check();
        String string2 = String.valueOf(string) + ":" + n;
        SessionParams sessionParams = (SessionParams)this.clientCache.get(string2);
        if (sessionParams != null) {
            return sessionParams.verifyExpiration() ? sessionParams : null;
        }
        return null;
    }

    public void removeSession(SessionID sessionID) {
        SessionParams sessionParams;
        if (this.serverCache != null && (sessionParams = (SessionParams)this.serverCache.remove(Utils.toHexString((byte[])sessionID.getID()))) != null) {
            if (this.timeOutServerCache != null) {
                this.timeOutServerCache.removeElement(sessionParams);
            }
            sessionParams.erase();
        }
    }

    public void removeSession(String string, int n) {
        String string2;
        SessionParams sessionParams;
        if (this.clientCache != null && (sessionParams = (SessionParams)this.clientCache.remove(string2 = String.valueOf(string) + ":" + n)) != null) {
            if (this.timeOutClientCache != null) {
                this.timeOutClientCache.removeElement(sessionParams);
            }
            sessionParams.erase();
        }
    }

    public void setCheckInterval(long l) {
        this.checkInterval = l;
        if (l != 0L) {
            this.nextCheck = new Date().getTime() + l * 1000L;
        }
    }

    public void setClientCache(Hashtable hashtable) {
        this.clientCache = hashtable;
    }

    public void setExpirationTime(long l) {
        this.expirationTime = l;
    }

    public void setServerCache(Hashtable hashtable) {
        this.serverCache = hashtable;
    }
}

