/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.MACHashV3;
import com.phaos.SSL.MACHashV31;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.SymmetricKey;
import java.io.IOException;

public abstract class MACHash {
    public static final int NULL = 0;
    public static final int MD5 = 1;
    public static final int SHA = 2;
    public static final int[] hashSize;
    public static final AlgorithmIdentifier[] algID;
    private int mac;
    protected SSLCrypto sslCrypto;
    private static Class macHashClassMD5;
    private static Class macHashClassSHA1;

    static {
        int[] nArray = new int[3];
        nArray[1] = 16;
        nArray[2] = 20;
        hashSize = nArray;
        algID = new AlgorithmIdentifier[]{null, AlgID.md5, AlgID.sha1};
    }

    protected MACHash() {
    }

    protected MACHash(int n, SSLCrypto sSLCrypto) {
        this.mac = n;
        this.sslCrypto = sSLCrypto;
    }

    public abstract void erase();

    public abstract byte[] generateMAC(long var1, int var3, int var4, byte[] var5);

    public AlgorithmIdentifier getAlgID() {
        return algID[this.mac];
    }

    public int getHashSize() {
        return hashSize[this.mac];
    }

    public static MACHash getInstance(int n, ProtocolVersion protocolVersion, SSLCrypto sSLCrypto) throws AlgorithmIdentifierException {
        if (protocolVersion.equals(ProtocolVersion.TLS1)) {
            return new MACHashV31(n, sSLCrypto);
        }
        if (n == 1 && macHashClassMD5 == null || n == 0 || n == 2 && macHashClassSHA1 == null) {
            return new MACHashV3(n, sSLCrypto);
        }
        Class clazz = n == 1 ? macHashClassMD5 : macHashClassSHA1;
        try {
            MACHash mACHash = (MACHash)clazz.newInstance();
            mACHash.setSSLCrypto(sSLCrypto);
            mACHash.setMac(n);
            return mACHash;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException(instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException(classCastException.toString());
        }
    }

    public int getMac() {
        return this.mac;
    }

    public int length() {
        return this.getHashSize();
    }

    protected static void setClass(int n, Class clazz) {
        if (n == 1) {
            macHashClassMD5 = clazz;
        } else if (n == 2) {
            macHashClassSHA1 = clazz;
        }
    }

    public void setMac(int n) throws AlgorithmIdentifierException {
        this.mac = n;
    }

    public abstract void setReadKey(SymmetricKey var1) throws IOException;

    protected void setSSLCrypto(SSLCrypto sSLCrypto) {
        this.sslCrypto = sSLCrypto;
    }

    public abstract void setWriteKey(SymmetricKey var1) throws IOException;

    public String toString() {
        if (this.mac == 0) {
            return "NULL";
        }
        if (this.mac == 1) {
            return "MD5";
        }
        if (this.mac == 2) {
            return "SHA 1";
        }
        return "UNKNOWN";
    }

    public abstract boolean verifyInputMAC(byte[] var1, long var2, int var4, int var5, byte[] var6);
}

