/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.MACHash;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.io.IOException;

public class MACHashV3
extends MACHash {
    public static byte[][] pad1 = new byte[3][];
    public static byte[][] pad2 = new byte[3][];
    private MessageDigest mdRead;
    private MessageDigest mdWrite;
    private byte[] writeSecret;
    private byte[] readSecret;

    static {
        MACHashV3.pad1[1] = new byte[48];
        MACHashV3.pad2[1] = new byte[48];
        Utils.setArray((byte[])pad1[1], (byte)54);
        Utils.setArray((byte[])pad2[1], (byte)92);
        MACHashV3.pad1[2] = new byte[40];
        MACHashV3.pad2[2] = new byte[40];
        Utils.setArray((byte[])pad1[2], (byte)54);
        Utils.setArray((byte[])pad2[2], (byte)92);
    }

    public MACHashV3() {
    }

    public MACHashV3(int n, SSLCrypto sSLCrypto) throws AlgorithmIdentifierException {
        super(n, sSLCrypto);
        this.initialize();
    }

    public void erase() {
        this.mdWrite = null;
        this.mdRead = null;
        Utils.setArray((byte[])this.writeSecret, (byte)0);
        Utils.setArray((byte[])this.readSecret, (byte)0);
    }

    public byte[] generateMAC(long l, int n, int n2, byte[] byArray) {
        if (this.mdWrite == null) {
            return null;
        }
        this.mdWrite.init();
        this.mdWrite.update(this.writeSecret);
        this.mdWrite.update(pad1[this.getMac()]);
        this.mdWrite.update(l);
        this.mdWrite.update((byte)n);
        this.mdWrite.update((short)n2);
        this.mdWrite.update(byArray);
        this.mdWrite.computeCurrent();
        byte[] byArray2 = this.mdWrite.digestBits;
        this.mdWrite.init();
        this.mdWrite.update(this.writeSecret);
        this.mdWrite.update(pad2[this.getMac()]);
        this.mdWrite.update(byArray2);
        this.mdWrite.computeCurrent();
        return this.mdWrite.digestBits;
    }

    public byte[] generateMAC(SymmetricKey symmetricKey, byte[] byArray) throws IOException {
        if (this.mdWrite == null) {
            try {
                this.initialize();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new AlertException(algorithmIdentifierException.toString(), "SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
        }
        byte[] byArray2 = symmetricKey.getBytes();
        if (this.mdWrite == null) {
            return null;
        }
        this.mdWrite.init();
        this.mdWrite.update(byArray);
        this.mdWrite.update(byArray2);
        this.mdWrite.update(pad1[this.getMac()]);
        this.mdWrite.computeCurrent();
        byte[] byArray3 = this.mdWrite.digestBits;
        this.mdWrite.init();
        this.mdWrite.update(byArray2);
        this.mdWrite.update(pad2[this.getMac()]);
        this.mdWrite.update(byArray3);
        this.mdWrite.computeCurrent();
        return this.mdWrite.digestBits;
    }

    public byte[] generateMAC(SymmetricKey symmetricKey, byte[] byArray, byte[] byArray2) throws IOException {
        if (this.mdWrite == null) {
            try {
                this.initialize();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new AlertException(algorithmIdentifierException.toString(), "SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
        }
        byte[] byArray3 = symmetricKey.getBytes();
        if (this.mdWrite == null) {
            return null;
        }
        this.mdWrite.init();
        this.mdWrite.update(byArray2);
        this.mdWrite.update(byArray);
        this.mdWrite.update(byArray3);
        this.mdWrite.update(pad1[this.getMac()]);
        this.mdWrite.computeCurrent();
        byte[] byArray4 = this.mdWrite.digestBits;
        this.mdWrite.init();
        this.mdWrite.update(byArray3);
        this.mdWrite.update(pad2[this.getMac()]);
        this.mdWrite.update(byArray4);
        this.mdWrite.computeCurrent();
        return this.mdWrite.digestBits;
    }

    public void initialize() throws AlgorithmIdentifierException {
        if (this.getMac() == 1) {
            this.mdRead = this.sslCrypto.getMessageDigestInstance(AlgID.md5);
            this.mdWrite = this.sslCrypto.getMessageDigestInstance(AlgID.md5);
        } else if (this.getMac() == 2) {
            this.mdRead = this.sslCrypto.getMessageDigestInstance(AlgID.sha_1);
            this.mdWrite = this.sslCrypto.getMessageDigestInstance(AlgID.sha_1);
        } else if (this.getMac() == 0) {
            this.mdRead = null;
            this.mdWrite = null;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized hashing algorithm");
        }
    }

    public void setReadKey(SymmetricKey symmetricKey) throws IOException {
        if (symmetricKey != null) {
            this.readSecret = new byte[symmetricKey.getBytes().length];
            System.arraycopy(symmetricKey.getBytes(), 0, this.readSecret, 0, this.readSecret.length);
        } else {
            this.readSecret = new byte[0];
        }
        if (this.mdRead == null) {
            try {
                this.initialize();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new AlertException(algorithmIdentifierException.toString(), "SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
        }
    }

    public void setWriteKey(SymmetricKey symmetricKey) throws IOException {
        if (symmetricKey != null) {
            this.writeSecret = new byte[symmetricKey.getBytes().length];
            System.arraycopy(symmetricKey.getBytes(), 0, this.writeSecret, 0, this.writeSecret.length);
        } else {
            this.writeSecret = new byte[0];
        }
        if (this.mdWrite == null) {
            try {
                this.initialize();
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new AlertException(algorithmIdentifierException.toString(), "SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
        }
    }

    public boolean verifyInputMAC(byte[] byArray, long l, int n, int n2, byte[] byArray2) {
        byte[] byArray3 = null;
        if (this.mdRead != null) {
            this.mdRead.init();
            this.mdRead.update(this.readSecret);
            this.mdRead.update(pad1[this.getMac()]);
            this.mdRead.update(l);
            this.mdRead.update((byte)n);
            this.mdRead.update((short)n2);
            this.mdRead.update(byArray2);
            this.mdRead.computeCurrent();
            byte[] byArray4 = this.mdRead.digestBits;
            this.mdRead.init();
            this.mdRead.update(this.readSecret);
            this.mdRead.update(pad2[this.getMac()]);
            this.mdRead.update(byArray4);
            this.mdRead.computeCurrent();
            byArray3 = this.mdRead.digestBits;
        }
        if (byArray3 == null && byArray != null || !Utils.areEqual(byArray3, (byte[])byArray)) {
            System.out.println("input mac: " + Utils.toHexString((byte[])byArray) + ", comp MAC: " + Utils.toHexString(byArray3));
            return false;
        }
        return true;
    }
}

