/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.MACHash;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.HMAC;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;

class MACHashV31
extends MACHash {
    private HMAC hmacWrite;
    private HMAC hmacRead;
    private byte[] writeSecret;
    private byte[] readSecret;
    private static final ProtocolVersion versionMAC = ProtocolVersion.TLS1;

    public MACHashV31(int n, SSLCrypto sSLCrypto) throws AlgorithmIdentifierException {
        super(n, sSLCrypto);
        if (n == 1) {
            this.hmacWrite = (HMAC)sSLCrypto.getMessageDigestInstance(AlgID.hmacMD5);
            this.hmacRead = (HMAC)sSLCrypto.getMessageDigestInstance(AlgID.hmacMD5);
        } else if (n == 2) {
            this.hmacWrite = (HMAC)sSLCrypto.getMessageDigestInstance(AlgID.hmacSHA);
            this.hmacRead = (HMAC)sSLCrypto.getMessageDigestInstance(AlgID.hmacSHA);
        } else if (n != 0) {
            throw new AlgorithmIdentifierException("Unrecognized hashing algorithm");
        }
    }

    public static byte[] PRF(SymmetricKey symmetricKey, byte[] byArray, byte[] byArray2, int n, SSLCrypto sSLCrypto) throws AlgorithmIdentifierException {
        MACHashV31 mACHashV31 = new MACHashV31(1, sSLCrypto);
        byte[] byArray3 = mACHashV31.generateMACFinished(symmetricKey, byArray, byArray2, n);
        MACHashV31 mACHashV312 = new MACHashV31(2, sSLCrypto);
        byte[] byArray4 = mACHashV312.generateMACFinished(symmetricKey, byArray, byArray2, n);
        int n2 = 0;
        while (n2 < byArray3.length) {
            int n3 = n2;
            byArray3[n3] = (byte)(byArray3[n3] ^ byArray4[n2]);
            ++n2;
        }
        return byArray3;
    }

    public void erase() {
        this.hmacWrite = null;
        this.hmacRead = null;
        if (this.writeSecret != null) {
            Utils.setArray((byte[])this.writeSecret, (byte)0);
        }
        if (this.readSecret != null) {
            Utils.setArray((byte[])this.readSecret, (byte)0);
        }
    }

    private byte[] generateInputMAC(long l, int n, int n2, byte[] byArray) {
        if (this.hmacRead == null) {
            return null;
        }
        this.hmacRead.init();
        this.hmacRead.update(l);
        this.hmacRead.update((byte)n);
        this.hmacRead.update(Utils.toBytes((Streamable)versionMAC));
        this.hmacRead.update((short)n2);
        this.hmacRead.update(byArray);
        this.hmacRead.computeCurrent();
        return this.hmacRead.digestBits;
    }

    public byte[] generateMAC(long l, int n, int n2, byte[] byArray) {
        if (this.hmacWrite == null) {
            return null;
        }
        this.hmacWrite.init();
        this.hmacWrite.update(l);
        this.hmacWrite.update((byte)n);
        this.hmacWrite.update(Utils.toBytes((Streamable)versionMAC));
        this.hmacWrite.update((short)n2);
        this.hmacWrite.update(byArray);
        this.hmacWrite.computeCurrent();
        return this.hmacWrite.digestBits;
    }

    private byte[] generateMACFinished(SymmetricKey symmetricKey, byte[] byArray, byte[] byArray2, int n) {
        if (this.hmacWrite == null) {
            return null;
        }
        byte[] byArray3 = symmetricKey.getBytes();
        int n2 = (byArray3.length + 1) / 2;
        byte[] byArray4 = new byte[n2];
        if (this.getMac() == 1) {
            System.arraycopy(byArray3, 0, byArray4, 0, n2);
        } else if (this.getMac() == 2) {
            System.arraycopy(byArray3, byArray3.length - n2, byArray4, 0, n2);
        }
        this.hmacWrite.setKey(byArray4);
        this.hmacWrite.init();
        this.hmacWrite.update(byArray);
        this.hmacWrite.update(byArray2);
        this.hmacWrite.computeCurrent();
        byte[] byArray5 = this.hmacWrite.getDigestBits();
        int n3 = n;
        int n4 = 0;
        byte[] byArray6 = new byte[n3];
        while (n3 > 0) {
            this.hmacWrite.init();
            this.hmacWrite.update(byArray5);
            this.hmacWrite.update(byArray);
            this.hmacWrite.update(byArray2);
            this.hmacWrite.computeCurrent();
            int n5 = this.hmacWrite.digestBits.length > n3 ? n3 : this.hmacWrite.digestBits.length;
            System.arraycopy(this.hmacWrite.digestBits, 0, byArray6, n4, n5);
            n4 += n5;
            if ((n3 -= n5) <= 0) continue;
            this.hmacWrite.init();
            this.hmacWrite.update(byArray5);
            this.hmacWrite.computeCurrent();
            System.arraycopy(this.hmacWrite.digestBits, 0, byArray5, 0, this.hmacWrite.digestBits.length);
        }
        return byArray6;
    }

    public void setReadKey(SymmetricKey symmetricKey) throws IOException {
        byte[] byArray = null;
        if (symmetricKey != null) {
            byArray = new byte[symmetricKey.getBytes().length];
            System.arraycopy(symmetricKey.getBytes(), 0, byArray, 0, byArray.length);
        }
        if (this.getMac() == 0 || byArray == null) {
            this.readSecret = null;
        } else if (this.readSecret == null && byArray != null || this.readSecret != null && byArray != null && !Utils.areEqual((byte[])byArray, (byte[])this.readSecret)) {
            this.hmacRead.setKey(byArray);
            this.readSecret = (byte[])byArray.clone();
        }
    }

    public void setWriteKey(SymmetricKey symmetricKey) throws IOException {
        byte[] byArray = null;
        if (symmetricKey != null) {
            byArray = new byte[symmetricKey.getBytes().length];
            System.arraycopy(symmetricKey.getBytes(), 0, byArray, 0, byArray.length);
        }
        if (this.getMac() == 0 || byArray == null) {
            this.writeSecret = null;
        } else if (this.writeSecret == null && byArray != null || this.writeSecret != null && byArray != null && !Utils.areEqual((byte[])byArray, (byte[])this.writeSecret)) {
            this.hmacWrite.setKey(byArray);
            this.writeSecret = (byte[])byArray.clone();
        }
    }

    public boolean verifyInputMAC(byte[] byArray, long l, int n, int n2, byte[] byArray2) {
        byte[] byArray3 = this.generateInputMAC(l, n, n2, byArray2);
        return (byArray3 != null || byArray == null) && Utils.areEqual((byte[])byArray3, (byte[])byArray);
    }
}

