/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ApplicationData;
import com.phaos.SSL.ChangeCipherSpec;
import com.phaos.SSL.ClientHelloV2;
import com.phaos.SSL.ConnectionState;
import com.phaos.SSL.HandshakeMessage;
import com.phaos.SSL.HandshakeParams;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SessionState;
import com.phaos.utils.Streamable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class Message
implements Streamable {
    public static final int CLIENT_HELLO_V2 = 1;
    public static final int SERVER_HELLO_V2 = 4;
    public static final int CHANGE_CIPHER_SPEC = 20;
    public static final int ALERT = 21;
    public static final int HANDSHAKE = 22;
    public static final int APPLICATION_DATA = 23;

    Message() {
    }

    public abstract int getType();

    public abstract void input(InputStream var1) throws IOException;

    public static Message inputInstance(int n, InputStream inputStream) throws IOException {
        switch (n) {
            case 23: {
                return new ApplicationData(inputStream);
            }
            case 20: {
                return new ChangeCipherSpec(inputStream);
            }
            case 21: {
                return new Alert(inputStream);
            }
            case 22: {
                return new HandshakeMessage(inputStream);
            }
            case 1: {
                return new ClientHelloV2(inputStream);
            }
        }
        throw new AlertException("Unrecognized type: " + n, "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
    }

    public static Message inputInstance(int n, InputStream inputStream, ProtocolVersion protocolVersion, SessionState sessionState, ConnectionState connectionState, HandshakeParams handshakeParams) throws IOException {
        switch (n) {
            case 23: {
                return new ApplicationData(inputStream);
            }
            case 20: {
                return new ChangeCipherSpec(inputStream);
            }
            case 21: {
                return new Alert(inputStream);
            }
            case 22: {
                return new HandshakeMessage(inputStream, protocolVersion, sessionState, connectionState, handshakeParams);
            }
            case 1: {
                return new ClientHelloV2(inputStream);
            }
        }
        throw new AlertException("Unrecognized type: " + n, "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
    }

    public abstract int length();

    public abstract void output(OutputStream var1) throws IOException;

    public abstract String toString();
}

