/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.SSLSocket;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ProtocolVersion
implements Streamable {
    public static final ProtocolVersion SSL2 = new ProtocolVersion(0, 2);
    public static final ProtocolVersion SSL3 = new ProtocolVersion(3, 0);
    public static final ProtocolVersion TLS1 = new ProtocolVersion(3, 1);
    private int major;
    private int minor;

    public ProtocolVersion(int n, int n2) {
        this.major = n;
        this.minor = n2;
    }

    public ProtocolVersion(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ProtocolVersion(boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (bl2 || bl3) {
            this.major = 3;
            this.minor = bl3 ? 1 : 0;
        } else if (bl && SSLSocket.supportsSSL2()) {
            this.major = 0;
            this.minor = 2;
        } else {
            if (bl && !SSLSocket.supportsSSL2()) {
                throw new AlertException("SSLv2 was enabled, but the SSLv2 plugin is not present.", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            }
            throw new AlertException("No protocol version specified", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProtocolVersion protocolVersion = (ProtocolVersion)object;
        return this.major == protocolVersion.major && this.minor == protocolVersion.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void input(InputStream inputStream) throws IOException {
        this.major = Utils.inputByte((InputStream)inputStream);
        this.minor = Utils.inputByte((InputStream)inputStream);
    }

    public int length() {
        return 2;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.major);
        outputStream.write(this.minor);
    }

    public String toString() {
        if (this.major == 0 && this.minor == 2) {
            return "2.0";
        }
        return String.valueOf(this.major) + "." + this.minor;
    }
}

