/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class Random
implements Streamable {
    private static final int RANDOM_LENGTH = 28;
    private int gmtUnixTime;
    private byte[] randomBytes = new byte[28];

    public Random() {
        this(RandomBitsSource.getDefault());
    }

    public Random(RandomBitsSource randomBitsSource) {
        this.gmtUnixTime = (int)(new Date().getTime() / 1000L);
        randomBitsSource.randomBytes(this.randomBytes);
    }

    public Random(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public void erase() {
        this.gmtUnixTime = 0;
        Utils.setArray((byte[])this.randomBytes, (byte)0);
    }

    public void input(InputStream inputStream) throws IOException {
        this.gmtUnixTime = Utils.inputWord((InputStream)inputStream);
        Utils.inputByteArray((byte[])this.randomBytes, (InputStream)inputStream);
    }

    public int length() {
        return 4 + this.randomBytes.length;
    }

    public void output(OutputStream outputStream) throws IOException {
        Utils.outputWord((int)this.gmtUnixTime, (OutputStream)outputStream);
        outputStream.write(this.randomBytes);
    }

    public String toString() {
        try {
            return "Date = " + new Date((long)this.gmtUnixTime * 1000L) + ", randomBytes = " + Utils.toHexString((byte[])this.randomBytes);
        }
        catch (Exception exception) {
            return "Date = " + this.gmtUnixTime + ", randomBytes =" + Utils.toHexString((byte[])this.randomBytes);
        }
    }
}

