/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ClientHelloV2;
import com.phaos.SSL.ConnectionState;
import com.phaos.SSL.HandshakeMessage;
import com.phaos.SSL.HandshakeParams;
import com.phaos.SSL.Message;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.RecordCipherText;
import com.phaos.SSL.RecordInputStream;
import com.phaos.SSL.SSLByteArrayInputStream;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.ServerHelloV2;
import com.phaos.SSL.SessionParams;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.CipherException;
import com.phaos.utils.Streamable;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

final class Record {
    public static final int OPENED = 1;
    public static final int CLOSED = 2;
    public static final int ABORTED = 3;
    private static final int OUTPUT_BUFFER_SIZE = 256;
    private int status;
    private boolean closeSent;
    private RecordCipherText recordCipher;
    private Message messageIn;
    private Message messageOut;
    private BufferedInputStream is;
    private BufferedOutputStream os;
    private InputStream socketInputStream;
    private OutputStream socketOutputStream;
    private SSLByteArrayInputStream bis;
    private UnsyncByteArrayOutputStream bosBuffer;
    private int typeBuffer;
    private byte[] buffMaxSize = new byte[16384];

    public Record(ProtocolVersion protocolVersion, SessionState sessionState, ConnectionState connectionState) throws IOException {
        this.recordCipher = new RecordCipherText(protocolVersion, sessionState, connectionState);
        this.bosBuffer = new UnsyncByteArrayOutputStream();
        this.status = 1;
    }

    public Record(ProtocolVersion protocolVersion, SessionState sessionState, ConnectionState connectionState, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.recordCipher = new RecordCipherText(protocolVersion, sessionState, connectionState);
        this.bosBuffer = new UnsyncByteArrayOutputStream();
        this.setIS(inputStream);
        this.setOS(outputStream);
        this.status = 1;
    }

    public void addToSend(Message message, HandshakeParams handshakeParams) throws IOException {
        if (this.bosBuffer.size() > 0 && this.typeBuffer != message.getType()) {
            this.sendBufferedMessages();
        }
        byte[] byArray = Utils.toBytes((Streamable)message);
        this.bosBuffer.write(byArray);
        this.typeBuffer = message.getType();
        if (this.typeBuffer == 22 && ((HandshakeMessage)message).getBody().getHandshakeType() != 0) {
            handshakeParams.addMessage(byArray);
        }
    }

    public final int availability() throws IOException {
        if (this.status != 1) {
            return 0;
        }
        if (this.is.available() >= 5) {
            return this.recordCipher.getLengthInput(this.is);
        }
        return 0;
    }

    public final void checkStatus() throws IOException {
        if (this.status != 1 || this.os == null || this.is == null) {
            throw new SSLException("Connection closed");
        }
    }

    public final void emptyIS(RecordInputStream recordInputStream) throws IOException {
        while (RecordCipherText.getType(this.is) != 22 || this.bis.available() > 0 && this.recordCipher.getTypeIn() != 22) {
            recordInputStream.emptyIS();
        }
    }

    public void erase() throws IOException {
        this.os.flush();
        this.os.close();
        this.is.close();
        if (this.getSessionState() != null) {
            this.getSessionState().erase();
        }
        if (this.getConnectionState() != null) {
            this.getConnectionState().erase();
        }
    }

    final BufferedInputStream getBufferedInputStream() {
        return this.is;
    }

    public final ConnectionState getConnectionState() {
        return this.recordCipher.getConnectionState();
    }

    public final InputStream getIS() {
        return this.socketInputStream;
    }

    public final OutputStream getOS() {
        return this.socketOutputStream;
    }

    public final ProtocolVersion getProtocolVersionIn() {
        return this.recordCipher.getProtocolVersionIn();
    }

    public final ProtocolVersion getProtocolVersionOut() {
        return this.recordCipher.getProtocolVersionOut();
    }

    public final SessionParams getSessionParams() {
        return this.getSessionState().getSessionParams(this.getProtocolVersionOut());
    }

    public final SessionState getSessionState() {
        return this.recordCipher.getSessionState();
    }

    public final int getStatus() {
        return this.status;
    }

    public final boolean isAlertType() throws IOException {
        if (this.bis != null && this.bis.available() > 0) {
            return this.recordCipher.getTypeIn() == 21;
        }
        this.is.mark(18438);
        int n = 0;
        try {
            n = this.is.read();
        }
        finally {
            Object var3_2 = null;
            if (n != -1) {
                this.is.reset();
            }
        }
        return n == 21;
    }

    public final boolean isAvailable() throws IOException {
        return this.is.available() > 0;
    }

    public final boolean isCloseSent() {
        return this.closeSent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isFinished() throws IOException {
        boolean bl;
        block10: {
            boolean bl2;
            block9: {
                boolean bl3;
                block8: {
                    if (this.status != 1) {
                        return true;
                    }
                    this.is.mark(18438);
                    try {
                        try {
                            if (this.bis != null && this.bis.available() > 0) {
                                bl3 = false;
                                Object var3_6 = null;
                                break block8;
                            }
                            int n = this.is.read();
                            if (n == -1) {
                                bl2 = true;
                                break block9;
                            }
                            bl = false;
                            break block10;
                        }
                        catch (SocketException socketException) {
                            boolean bl4 = true;
                            Object var3_9 = null;
                            this.is.reset();
                            return bl4;
                        }
                        catch (EOFException eOFException) {
                            boolean bl5 = true;
                            Object var3_10 = null;
                            this.is.reset();
                            return bl5;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_11 = null;
                        this.is.reset();
                        throw throwable;
                    }
                }
                this.is.reset();
                return bl3;
            }
            Object var3_7 = null;
            this.is.reset();
            return bl2;
        }
        Object var3_8 = null;
        this.is.reset();
        return bl;
    }

    public final boolean isHandshakeType() throws IOException {
        if (this.bis != null && this.bis.available() > 0) {
            return this.recordCipher.getTypeIn() == 22;
        }
        this.is.mark(18438);
        int n = 0;
        try {
            n = this.is.read();
        }
        finally {
            Object var3_2 = null;
            if (n != -1) {
                this.is.reset();
            }
        }
        return n == 22;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isNoCipherErrorV2() throws IOException {
        block21: {
            boolean bl;
            block29: {
                boolean bl2;
                block28: {
                    boolean bl3;
                    block27: {
                        boolean bl4;
                        block26: {
                            boolean bl5;
                            block25: {
                                boolean bl6;
                                block24: {
                                    boolean bl7;
                                    block23: {
                                        boolean bl8;
                                        block22: {
                                            boolean bl9;
                                            block20: {
                                                boolean bl10;
                                                block19: {
                                                    boolean bl11;
                                                    block18: {
                                                        boolean bl12;
                                                        block17: {
                                                            boolean bl13;
                                                            block16: {
                                                                boolean bl14;
                                                                block15: {
                                                                    this.is.mark(6);
                                                                    try {
                                                                        int n = this.is.read();
                                                                        if (n == -1) {
                                                                            bl14 = false;
                                                                            Object var3_16 = null;
                                                                            break block15;
                                                                        }
                                                                        if ((n & 0x80) != 0) {
                                                                            if (this.is.available() != 4) {
                                                                                bl13 = false;
                                                                                break block16;
                                                                            }
                                                                            if ((n & 0x7F) != 0) {
                                                                                bl12 = false;
                                                                                break block17;
                                                                            }
                                                                            if (this.is.read() != 3) {
                                                                                bl11 = false;
                                                                                break block18;
                                                                            }
                                                                            if (this.is.read() != 0) {
                                                                                bl10 = false;
                                                                                break block19;
                                                                            }
                                                                            if (this.is.read() != 0) {
                                                                                bl9 = false;
                                                                                break block20;
                                                                            }
                                                                            if (this.is.read() == 1) break block21;
                                                                            bl8 = false;
                                                                            break block22;
                                                                        }
                                                                        if (this.is.available() != 5) {
                                                                            bl7 = false;
                                                                            break block23;
                                                                        }
                                                                        if ((n & 0x3F) != 0) {
                                                                            bl6 = false;
                                                                            break block24;
                                                                        }
                                                                        if (this.is.read() != 3) {
                                                                            bl5 = false;
                                                                            break block25;
                                                                        }
                                                                        if (this.is.read() != 0) {
                                                                            bl4 = false;
                                                                            break block26;
                                                                        }
                                                                        if (this.is.read() != 0) {
                                                                            bl3 = false;
                                                                            break block27;
                                                                        }
                                                                        if (this.is.read() != 0) {
                                                                            bl2 = false;
                                                                            break block28;
                                                                        }
                                                                        if (this.is.read() == 1) break block21;
                                                                        bl = false;
                                                                        break block29;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        Object var3_31 = null;
                                                                        this.is.reset();
                                                                        throw throwable;
                                                                    }
                                                                }
                                                                this.is.reset();
                                                                return bl14;
                                                            }
                                                            Object var3_17 = null;
                                                            this.is.reset();
                                                            return bl13;
                                                        }
                                                        Object var3_18 = null;
                                                        this.is.reset();
                                                        return bl12;
                                                    }
                                                    Object var3_19 = null;
                                                    this.is.reset();
                                                    return bl11;
                                                }
                                                Object var3_20 = null;
                                                this.is.reset();
                                                return bl10;
                                            }
                                            Object var3_21 = null;
                                            this.is.reset();
                                            return bl9;
                                        }
                                        Object var3_22 = null;
                                        this.is.reset();
                                        return bl8;
                                    }
                                    Object var3_23 = null;
                                    this.is.reset();
                                    return bl7;
                                }
                                Object var3_24 = null;
                                this.is.reset();
                                return bl6;
                            }
                            Object var3_25 = null;
                            this.is.reset();
                            return bl5;
                        }
                        Object var3_26 = null;
                        this.is.reset();
                        return bl4;
                    }
                    Object var3_27 = null;
                    this.is.reset();
                    return bl3;
                }
                Object var3_28 = null;
                this.is.reset();
                return bl2;
            }
            Object var3_29 = null;
            this.is.reset();
            return bl;
        }
        Object var3_30 = null;
        this.is.reset();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isServerHelloV2() throws IOException {
        boolean bl;
        block22: {
            boolean bl2;
            block21: {
                boolean bl3;
                block20: {
                    boolean bl4;
                    block19: {
                        boolean bl5;
                        block18: {
                            boolean bl6;
                            block17: {
                                boolean bl7;
                                block16: {
                                    boolean bl8;
                                    block15: {
                                        boolean bl9;
                                        block14: {
                                            boolean bl10;
                                            block13: {
                                                boolean bl11;
                                                block12: {
                                                    this.is.mark(6);
                                                    try {
                                                        int n = this.is.read();
                                                        if (n == -1) {
                                                            bl11 = false;
                                                            Object var3_13 = null;
                                                            break block12;
                                                        }
                                                        if (n != 22) {
                                                            bl10 = true;
                                                            break block13;
                                                        }
                                                        int n2 = this.is.read();
                                                        if (n2 == -1) {
                                                            bl9 = false;
                                                            break block14;
                                                        }
                                                        if (n2 != 3) {
                                                            bl8 = true;
                                                            break block15;
                                                        }
                                                        int n3 = this.is.read();
                                                        if (n3 == -1) {
                                                            bl7 = false;
                                                            break block16;
                                                        }
                                                        int n4 = this.is.read();
                                                        if (n4 == -1) {
                                                            bl6 = false;
                                                            break block17;
                                                        }
                                                        int n5 = this.is.read();
                                                        if (n5 == -1) {
                                                            bl5 = false;
                                                            break block18;
                                                        }
                                                        int n6 = this.is.read();
                                                        if (n6 == -1) {
                                                            bl4 = false;
                                                            break block19;
                                                        }
                                                        if (n6 == 2) {
                                                            bl3 = false;
                                                            break block20;
                                                        }
                                                        if (n6 == 0 || n6 == 1) {
                                                            bl2 = true;
                                                            break block21;
                                                        }
                                                        bl = false;
                                                        break block22;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var3_24 = null;
                                                        this.is.reset();
                                                        throw throwable;
                                                    }
                                                }
                                                this.is.reset();
                                                return bl11;
                                            }
                                            Object var3_14 = null;
                                            this.is.reset();
                                            return bl10;
                                        }
                                        Object var3_15 = null;
                                        this.is.reset();
                                        return bl9;
                                    }
                                    Object var3_16 = null;
                                    this.is.reset();
                                    return bl8;
                                }
                                Object var3_17 = null;
                                this.is.reset();
                                return bl7;
                            }
                            Object var3_18 = null;
                            this.is.reset();
                            return bl6;
                        }
                        Object var3_19 = null;
                        this.is.reset();
                        return bl5;
                    }
                    Object var3_20 = null;
                    this.is.reset();
                    return bl4;
                }
                Object var3_21 = null;
                this.is.reset();
                return bl3;
            }
            Object var3_22 = null;
            this.is.reset();
            return bl2;
        }
        Object var3_23 = null;
        this.is.reset();
        return bl;
    }

    protected ServerHelloV2 readServerHelloV2() throws IOException {
        return this.recordCipher.readServerHelloV2(this.is);
    }

    public Message receive() throws IOException {
        this.receiveMessage();
        return Message.inputInstance(this.recordCipher.getTypeIn(), this.bis);
    }

    public Message receive(HandshakeParams handshakeParams) throws IOException {
        this.receiveMessage();
        if (this.recordCipher.getTypeIn() != 22) {
            return Message.inputInstance(this.recordCipher.getTypeIn(), this.bis);
        }
        this.bis.setRecordOS(true);
        Message message = Message.inputInstance(this.recordCipher.getTypeIn(), this.bis, this.recordCipher.getProtocolVersionIn(), this.recordCipher.getSessionState(), this.recordCipher.getConnectionState(), handshakeParams);
        if (((HandshakeMessage)message).getBody().getHandshakeType() != 0) {
            handshakeParams.addMessage(this.bis.getOSBufferAndReset());
        }
        if (this.recordCipher.getSessionState().getDebug()) {
            this.recordCipher.getSessionState().debugln("received: " + ((HandshakeMessage)message).getBody());
        }
        return message;
    }

    public void receiveMessage() throws IOException {
        this.checkStatus();
        while (this.bis == null || this.bis.available() == 0 || this.is.available() >= 5 && this.recordCipher.getTypeIn() == 22 && this.recordCipher.getTypeIn() == RecordCipherText.getType(this.is)) {
            this.recordCipher.input(this.is);
            byte[] byArray = this.recordCipher.getDataIn();
            if (this.bis != null) {
                this.bis.add(byArray);
                continue;
            }
            this.bis = new SSLByteArrayInputStream(byArray);
            this.bis.setRecordLayer(this);
        }
    }

    public Message receiveV2(HandshakeParams handshakeParams) throws IOException {
        Object object;
        this.checkStatus();
        if (this.bis == null || this.bis.available() == 0) {
            this.recordCipher.inputV2(this.is);
            object = this.recordCipher.getDataIn();
            if (this.bis != null) {
                this.bis.add((byte[])object);
            } else {
                this.bis = new SSLByteArrayInputStream((byte[])object);
                this.bis.setRecordLayer(this);
            }
        }
        this.bis.setRecordOS(true);
        object = Message.inputInstance(this.recordCipher.getTypeIn(), this.bis, this.recordCipher.getProtocolVersionIn(), this.recordCipher.getSessionState(), this.recordCipher.getConnectionState(), handshakeParams);
        handshakeParams.addMessage(this.bis.getOSBufferAndReset());
        if (this.recordCipher.getSessionState().getDebug()) {
            this.recordCipher.getSessionState().debugln("received: " + object);
        }
        return object;
    }

    public void send(Message message) throws IOException {
        this.sendMessage(message.getType(), Utils.toBytes((Streamable)message));
    }

    public void send(Message message, HandshakeParams handshakeParams) throws IOException {
        int n = message.getType();
        byte[] byArray = Utils.toBytes((Streamable)message);
        this.sendMessage(n, byArray);
        if (n == 22 && ((HandshakeMessage)message).getBody().getHandshakeType() != 0) {
            handshakeParams.addMessage(byArray);
        }
    }

    public void sendBufferedMessages() throws IOException {
        if (this.bosBuffer.size() > 0) {
            this.sendMessage(this.typeBuffer, this.bosBuffer.toByteArray());
        }
        this.bosBuffer.reset();
    }

    public void sendClientHelloV2(ClientHelloV2 clientHelloV2, HandshakeParams handshakeParams) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(clientHelloV2.length());
        clientHelloV2.output((OutputStream)unsyncByteArrayOutputStream);
        handshakeParams.addMessage(unsyncByteArrayOutputStream.toByteArray());
        this.recordCipher.outputClientHelloV2(this.os, clientHelloV2);
    }

    private void sendMessage(int n, byte[] byArray) throws IOException {
        this.checkStatus();
        try {
            int n2 = (byArray.length - 1) / 16384;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                System.arraycopy(byArray, n3, this.buffMaxSize, 0, 16384);
                n3 += 16384;
                this.recordCipher.updateOut(n, this.buffMaxSize);
                this.recordCipher.output(this.os);
                ++n4;
            }
            byte[] byArray2 = new byte[byArray.length - n3];
            System.arraycopy(byArray, n3, byArray2, 0, byArray.length - n3);
            this.recordCipher.updateOut(n, byArray2);
            this.recordCipher.output(this.os);
            this.os.flush();
        }
        catch (CipherException cipherException) {
            AlertException alertException = new AlertException(cipherException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public final void setCloseSent(boolean bl) {
        this.closeSent = bl;
    }

    public final void setIS(InputStream inputStream) {
        this.is = new BufferedInputStream(inputStream);
        this.is.mark(1);
        this.socketInputStream = inputStream;
    }

    public final void setOS(OutputStream outputStream) {
        this.os = new BufferedOutputStream(outputStream, 256);
        this.socketOutputStream = outputStream;
    }

    public final void setProtocolVersionOut(ProtocolVersion protocolVersion) {
        this.recordCipher.setProtocolVersionOut(protocolVersion);
    }

    public final void setSessionParams(SessionParams sessionParams) throws IOException {
        this.recordCipher.setProtocolVersionOut(sessionParams.getProtocolVersion());
        this.getSessionState().setSessionParams(sessionParams);
    }

    public final void setStatus(int n) {
        this.status = n;
    }
}

