/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ClientHelloV2;
import com.phaos.SSL.ConnectionState;
import com.phaos.SSL.NoMoreDataException;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.RecordCompressed;
import com.phaos.SSL.SSLCipher;
import com.phaos.SSL.ServerHelloV2;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.CipherException;
import com.phaos.utils.Streamable;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class RecordCipherText
extends RecordCompressed
implements Streamable {
    static final int MAX_LENGTH = 18432;
    private SessionState sessionState;
    private ConnectionState connectionState;
    private byte[] encryptedDataIn;
    private byte[] MACIn;
    private byte[] encryptedDataOut;
    private byte[] MACOut;

    public RecordCipherText(ProtocolVersion protocolVersion, SessionState sessionState, ConnectionState connectionState) throws IOException {
        super(protocolVersion, sessionState.getCompressionMethod());
        this.sessionState = sessionState;
        this.connectionState = connectionState;
    }

    public final ConnectionState getConnectionState() {
        return this.connectionState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLengthInput(BufferedInputStream bufferedInputStream) throws IOException {
        short s;
        block22: {
            int n;
            block21: {
                int n2;
                block20: {
                    int n3;
                    block19: {
                        int n4;
                        block18: {
                            int n5;
                            block17: {
                                int n6;
                                block16: {
                                    int n7;
                                    block15: {
                                        int n8;
                                        block14: {
                                            int n9;
                                            block13: {
                                                bufferedInputStream.mark(18438);
                                                try {
                                                    int n10 = bufferedInputStream.read();
                                                    if (n10 == -1) {
                                                        n9 = -1;
                                                        Object var5_13 = null;
                                                        break block13;
                                                    }
                                                    if (bufferedInputStream.read() == -1) {
                                                        n8 = -1;
                                                        break block14;
                                                    }
                                                    if (bufferedInputStream.read() == -1) {
                                                        n7 = -1;
                                                        break block15;
                                                    }
                                                    int n11 = bufferedInputStream.read();
                                                    if (n11 == -1) {
                                                        n6 = -1;
                                                        break block16;
                                                    }
                                                    int n12 = bufferedInputStream.read();
                                                    if (n12 == -1) {
                                                        n5 = -1;
                                                        break block17;
                                                    }
                                                    short s2 = Utils.bytesToShort((int)n11, (int)n12);
                                                    int n13 = bufferedInputStream.available();
                                                    if (n13 < s2) {
                                                        int n14 = n13;
                                                        while (n14 < s2) {
                                                            bufferedInputStream.skip(n13);
                                                            n13 = bufferedInputStream.available();
                                                            if (n13 == 0) {
                                                                n4 = 0;
                                                                break block18;
                                                            }
                                                            n14 += n13;
                                                        }
                                                    }
                                                    SSLCipher sSLCipher = this.sessionState.getCurrentCS().getReadCipher();
                                                    s2 = (short)(s2 - sSLCipher.getMAClength());
                                                    int n15 = sSLCipher.getIVSize();
                                                    if (n15 > 1) {
                                                        if (s2 > n15) {
                                                            n3 = s2 - n15;
                                                            break block19;
                                                        }
                                                        if (s2 > 0) {
                                                            n2 = 1;
                                                            break block20;
                                                        }
                                                        n = 0;
                                                        break block21;
                                                    }
                                                    s = s2;
                                                    break block22;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var5_23 = null;
                                                    bufferedInputStream.reset();
                                                    throw throwable;
                                                }
                                            }
                                            bufferedInputStream.reset();
                                            return n9;
                                        }
                                        Object var5_14 = null;
                                        bufferedInputStream.reset();
                                        return n8;
                                    }
                                    Object var5_15 = null;
                                    bufferedInputStream.reset();
                                    return n7;
                                }
                                Object var5_16 = null;
                                bufferedInputStream.reset();
                                return n6;
                            }
                            Object var5_17 = null;
                            bufferedInputStream.reset();
                            return n5;
                        }
                        Object var5_18 = null;
                        bufferedInputStream.reset();
                        return n4;
                    }
                    Object var5_19 = null;
                    bufferedInputStream.reset();
                    return n3;
                }
                Object var5_20 = null;
                bufferedInputStream.reset();
                return n2;
            }
            Object var5_21 = null;
            bufferedInputStream.reset();
            return n;
        }
        Object var5_22 = null;
        bufferedInputStream.reset();
        return s;
    }

    public final SessionState getSessionState() {
        return this.sessionState;
    }

    public static int getType(BufferedInputStream bufferedInputStream) throws IOException {
        int n;
        bufferedInputStream.mark(18438);
        try {
            n = bufferedInputStream.read();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            bufferedInputStream.reset();
            throw throwable;
        }
        bufferedInputStream.reset();
        return n;
    }

    public void input(InputStream inputStream) throws IOException {
        short s;
        try {
            inputStream.mark(18438);
            if (RecordCipherText.getType((BufferedInputStream)inputStream) == -1) {
                throw new NoMoreDataException("Tried to receive another message, but stream has no more data.");
            }
            this.setTypeIn(inputStream.read());
            this.setProtocolVersionIn(new ProtocolVersion(inputStream));
            s = Utils.inputShort((InputStream)inputStream);
            if (s > 18432) {
                throw new AlertException("Input SSLCipherText.fragment too large.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.RECORD_OVERFLOW));
            }
            this.encryptedDataIn = new byte[s];
            Utils.inputByteArray((byte[])this.encryptedDataIn, (InputStream)inputStream);
            inputStream.mark(18438);
        }
        catch (InterruptedIOException interruptedIOException) {
            ((BufferedInputStream)inputStream).reset();
            throw interruptedIOException;
        }
        try {
            super.input(this.getSessionState().getCurrentCS().getReadCipher().digestAndDecrypt(this.encryptedDataIn, this.getConnectionState().getSeqIn(), this.getTypeIn()));
        }
        catch (CipherException cipherException) {
            AlertException alertException = new AlertException(cipherException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPTION_FAILED));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        if (!this.getSessionState().getCurrentCS().getReadCipher().verifyMAC()) {
            throw new AlertException("Received Bad MAC", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.BAD_RECORD_MAC), 1);
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("Received " + s + " bytes: " + Utils.toHexString((byte[])this.encryptedDataIn) + "\nReceived MAC: " + Utils.toHexString((byte[])this.getSessionState().getCurrentCS().getReadCipher().getMACValue()));
        }
        this.connectionState.incrSeqIn();
    }

    public void inputV2(InputStream inputStream) throws IOException {
        Object object;
        int n;
        try {
            inputStream.mark(18438);
            if (RecordCipherText.getType((BufferedInputStream)inputStream) == -1) {
                throw new NoMoreDataException("Tried to receive another message, but stream has no more data.");
            }
            n = (Utils.inputByte((InputStream)inputStream) & 0x7F) << 8 | Utils.inputByte((InputStream)inputStream) & 0xFF;
            if (n > 18432) {
                throw new AlertException("Input SSLCipherText.fragment too large.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.RECORD_OVERFLOW));
            }
            this.setTypeIn(inputStream.read());
            this.setProtocolVersionIn(new ProtocolVersion(inputStream));
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            object = new byte[n - 3];
            Utils.inputByteArray((byte[])object, (InputStream)inputStream);
            unsyncByteArrayOutputStream.write(this.getTypeIn());
            this.getProtocolVersionIn().output((OutputStream)unsyncByteArrayOutputStream);
            unsyncByteArrayOutputStream.write((byte[])object);
            this.encryptedDataIn = unsyncByteArrayOutputStream.toByteArray();
        }
        catch (InterruptedIOException interruptedIOException) {
            ((BufferedInputStream)inputStream).reset();
            throw interruptedIOException;
        }
        try {
            super.input(this.getSessionState().getCurrentCS().getReadCipher().digestAndDecrypt(this.encryptedDataIn, this.getConnectionState().getSeqIn(), this.getTypeIn()));
        }
        catch (CipherException cipherException) {
            object = new AlertException(cipherException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPTION_FAILED));
            ((AlertException)object).addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw object;
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("SSL2 packet received = " + n + " bytes: " + Utils.toHexString((byte[])this.encryptedDataIn) + "\nReceived MAC: " + Utils.toHexString((byte[])this.getSessionState().getCurrentCS().getReadCipher().getMACValue()));
        }
        if (!this.getSessionState().getCurrentCS().getReadCipher().verifyMAC()) {
            throw new AlertException("Received Bad MAC", "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.BAD_RECORD_MAC));
        }
        this.connectionState.incrSeqIn();
    }

    public int length() {
        return this.encryptedDataOut != null ? this.encryptedDataOut.length : 0;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getTypeOut());
        this.getProtocolVersionOut().output(outputStream);
        Utils.outputShort((int)this.encryptedDataOut.length, (OutputStream)outputStream);
        outputStream.write(this.encryptedDataOut);
        outputStream.flush();
        this.connectionState.incrSeqOut();
    }

    public void outputClientHelloV2(OutputStream outputStream, ClientHelloV2 clientHelloV2) throws IOException {
        int n = clientHelloV2.length();
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        byte[] byArray = new byte[2];
        byArray[0] = (byte)(byArray[0] | 0x80);
        byArray[0] = (byte)(n >> 8 | byArray[0]);
        byArray[1] = (byte)n;
        unsyncByteArrayOutputStream.write(byArray);
        clientHelloV2.output((OutputStream)unsyncByteArrayOutputStream);
        byte[] byArray2 = unsyncByteArrayOutputStream.toByteArray();
        outputStream.write(byArray2);
        outputStream.flush();
        this.connectionState.incrSeqOut();
    }

    protected ServerHelloV2 readServerHelloV2(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        int n = 0;
        inputStream.mark(32769);
        try {
            int n2 = inputStream.read();
            int n3 = 0;
            if (n2 == -1) {
                throw new IOException("InputStream has no more data to be read");
            }
            byte by = (byte)n2;
            if ((by & 0x80) != 0) {
                n = (by & 0x7F) << 8 | inputStream.read();
            } else {
                n = (by & 0x3F) << 8 | inputStream.read();
                n3 = inputStream.read();
                n -= n3;
            }
            byArray = new byte[n];
            try {
                Utils.inputByteArray((byte[])byArray, (InputStream)inputStream);
                if (n3 > 0) {
                    byte[] byArray2 = new byte[n3];
                    Utils.inputByteArray((byte[])byArray2, (InputStream)inputStream);
                }
            }
            catch (IOException iOException) {
                inputStream.reset();
                throw new IOException("Stream closed before entire record could be received.  expected " + n + " bytes");
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            inputStream.reset();
            throw interruptedIOException;
        }
        ServerHelloV2 serverHelloV2 = new ServerHelloV2();
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(byArray);
            serverHelloV2.input((InputStream)unsyncByteArrayInputStream);
        }
        catch (IOException iOException) {
            inputStream.reset();
            throw iOException;
        }
        return serverHelloV2;
    }

    public void updateOut(int n, byte[] byArray) throws CipherException, IOException {
        this.updateCompressedOut(n, byArray);
        this.encryptedDataOut = this.getSessionState().getCurrentCS().getWriteCipher().digestAndEncrypt(this.getCompressedDataOut(), this.getConnectionState().getSeqOut(), n, this.getCompressedDataOut().length);
        if (this.encryptedDataOut.length > 18432) {
            throw new IllegalStateException("SSLCipherText.fragment too large.");
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("MAC: " + Utils.toHexString((byte[])this.getSessionState().getCurrentCS().getWriteCipher().getMACValue()) + "\nSending " + this.encryptedDataOut.length + " bytes : " + Utils.toHexString((byte[])this.encryptedDataOut));
        }
    }
}

