/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.Compression;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.RecordPlainText;
import java.io.IOException;

class RecordCompressed
extends RecordPlainText {
    static final int MAX_LENGTH = 17408;
    private Compression compressionMethod;

    RecordCompressed(ProtocolVersion protocolVersion, Compression compression) throws IOException {
        super(protocolVersion);
        this.compressionMethod = compression;
        if (compression.getValue() != Compression.NULL.getValue()) {
            AlertException alertException = new AlertException("Unrecognized compression method", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public byte[] getCompressedDataIn() {
        return this.getDataIn();
    }

    public byte[] getCompressedDataOut() {
        return this.getDataOut();
    }

    public void input(byte[] byArray) throws IOException {
        if (byArray.length > 17408) {
            AlertException alertException = new AlertException("Input SSLCompressed.fragment too large.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.RECORD_OVERFLOW));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.DECOMPRESSION_FAILURE));
            throw alertException;
        }
        super.input(byArray);
    }

    void updateCompressedOut(int n, byte[] byArray) throws IOException {
        if (byArray.length > 17408) {
            AlertException alertException = new AlertException("Input SSLCompressed.fragment too large.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        this.updatePlainOut(n, byArray);
    }
}

