/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ApplicationData;
import com.phaos.SSL.BadMACException;
import com.phaos.SSL.HandshakeMessage;
import com.phaos.SSL.NoMoreDataException;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.SSLSocket;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class RecordInputStream
extends InputStream {
    private SSLSocket socket;
    private byte[] buf;
    private int count;
    private int pos;
    private boolean currentlyEmptyingIS = false;
    private boolean closed = false;
    private boolean hasMoreData = true;

    public RecordInputStream(SSLSocket sSLSocket) {
        this.socket = sSLSocket;
        this.buf = new byte[0];
    }

    public int available() throws IOException {
        this.checkClosed();
        if (!this.hasMoreData) {
            return 0;
        }
        if (this.socket.getRecord().isAvailable()) {
            while (this.socket.getRecord().isAvailable() && (this.socket.getRecord().isHandshakeType() || this.socket.getRecord().isAlertType())) {
                this.computeIS(false);
            }
        }
        return this.count - this.pos + this.socket.getRecord().availability();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    /*
     * Unable to fully structure code
     */
    byte[] computeIS(boolean var1_1) throws IOException {
        if (this.socket.getRecord().isFinished()) {
            this.hasMoreData = false;
            return new byte[0];
        }
        if (this.socket.handshakeInProgress() && !this.currentlyEmptyingIS) {
            return new byte[0];
        }
        try {
            while (!this.socket.getRecord().isFinished()) {
                var2_2 = this.socket.getRecord().receive();
                switch (var2_2.getType()) {
                    case 23: {
                        return ((ApplicationData)var2_2).getData();
                    }
                    case 20: {
                        throw new SSLException("Unexpected message: " + var2_2);
                    }
                    case 21: {
                        var3_6 = (Alert)var2_2;
                        if (var3_6.getError().getValue() != Alert.Error.CLOSE_NOTIFY.getValue()) ** GOTO lbl30
                        if (this.socket.getRecord().getSessionState().getDebug()) {
                            this.socket.getRecord().getSessionState().debugln("Close notify received: " + var3_6);
                        }
                        this.socket.setCloseNotifyReceived();
                        try {
                            this.socket.sendCloseNotify();
                        }
                        catch (IOException v0) {
                            if (!this.socket.getRecord().getSessionState().getDebug()) ** GOTO lbl26
                            this.socket.getRecord().getSessionState().debugln("Peer did wait to receive the close notify message response");
                        }
lbl26:
                        // 3 sources

                        this.socket.disableOutputStream();
                        this.socket.disableInputStream();
                        this.socket.eraseRecordSecrets();
                        return new byte[0];
lbl30:
                        // 1 sources

                        if (var1_1) break;
                        return new byte[0];
                    }
                    case 22: {
                        var4_7 = ((HandshakeMessage)var2_2).getBody();
                        if (var4_7.getHandshakeType() == 0) {
                            this.socket.renegotiate();
                        } else if (var4_7.getHandshakeType() == 1) {
                            this.socket.renegotiateServer(var2_2);
                        } else {
                            throw new AlertException("Unexpected message: " + var2_2, "SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.UNEXPECTED_MESSAGE));
                        }
                        if (var1_1) break;
                        return new byte[0];
                    }
                }
            }
        }
        catch (AlertException var2_3) {
            if (this.socket.getRecord().getProtocolVersionOut().equals(ProtocolVersion.TLS1)) {
                if (var2_3.getAlertSSL_TLS() != null) {
                    this.socket.getRecord().send(var2_3.getAlertSSL_TLS());
                } else if (var2_3.getAlertTLS1() != null) {
                    this.socket.getRecord().send(var2_3.getAlertTLS1());
                }
            } else if (var2_3.getAlertSSL_TLS() != null) {
                this.socket.getRecord().send(var2_3.getAlertSSL_TLS());
            } else if (var2_3.getAlertSSL3() != null) {
                this.socket.getRecord().send(var2_3.getAlertSSL3());
            }
            this.socket.internalClose();
            this.socket.getRecord().setStatus(3);
            if (var2_3.getExceptionType() == 0) {
                throw new SSLException(var2_3.toString());
            }
            if (var2_3.getExceptionType() == 1) {
                throw new BadMACException(var2_3.toString());
            }
            throw new RuntimeException(var2_3.toString());
        }
        catch (InterruptedIOException var2_4) {
            throw var2_4;
        }
        catch (NoMoreDataException v1) {
            if (!this.socket.getParams().getIgnoreUnexpectedEOF()) {
                this.socket.internalClose();
                this.socket.getRecord().setStatus(3);
                throw new EOFException("End of stream encountered without receiving expected close notify message from peer");
            }
            this.socket.disableOutputStream();
            this.socket.disableInputStream();
            this.socket.eraseRecordSecrets();
            return new byte[0];
        }
        catch (IOException var2_5) {
            this.socket.internalClose();
            this.socket.getRecord().setStatus(3);
            throw var2_5;
        }
        return new byte[0];
    }

    void disable() {
        this.hasMoreData = false;
    }

    synchronized void emptyIS() throws IOException {
        if (this.closed) {
            return;
        }
        this.currentlyEmptyingIS = true;
        byte[] byArray = this.computeIS(true);
        byte[] byArray2 = new byte[this.count - this.pos + byArray.length];
        System.arraycopy(this.buf, this.pos, byArray2, 0, this.count - this.pos);
        System.arraycopy(byArray, 0, byArray2, this.count - this.pos, byArray.length);
        this.buf = byArray2;
        this.pos = 0;
        this.count = this.buf.length;
        this.currentlyEmptyingIS = false;
    }

    /*
     * Unable to fully structure code
     */
    public int read() throws IOException {
        this.checkClosed();
        if (this.hasMoreData) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            if (!this.hasMoreData) {
                return -1;
            }
            this.buf = this.computeIS(true);
            this.count = this.buf.length;
            this.pos = 0;
lbl9:
            // 2 sources

            ** while (this.count - this.pos == 0)
        }
lbl10:
        // 1 sources

        return this.buf[this.pos++] & 255;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (n < 0) {
            throw new IndexOutOfBoundsException("Offset parameter cannnot be negative: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Length parameter cannnot be negative: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Length + Offset is larger than the length of the destination array");
        }
        if (!this.hasMoreData) {
            return -1;
        }
        int n3 = 0;
        if (this.count - this.pos < n2) {
            int n4;
            if (this.count - this.pos == 0) {
                this.buf = this.computeIS(true);
                this.count = this.buf.length;
                this.pos = 0;
                n4 = n2 > this.count ? this.count : n2;
                System.arraycopy(this.buf, this.pos, byArray, n, n4);
                n += n4;
                n2 -= n4;
                n3 += n4;
                this.pos = n4;
            } else {
                System.arraycopy(this.buf, this.pos, byArray, n, this.count - this.pos);
                n += this.count - this.pos;
                n2 -= this.count - this.pos;
                n3 += this.count - this.pos;
                this.pos = this.count;
            }
            while (n2 > 0 && this.socket.getRecord().availability() > 0 && !this.socket.getRecord().isHandshakeType() && !this.socket.getRecord().isAlertType()) {
                this.buf = this.computeIS(true);
                this.count = this.buf.length;
                this.pos = 0;
                n4 = n2 > this.count ? this.count : n2;
                System.arraycopy(this.buf, this.pos, byArray, n, n4);
                n += n4;
                n2 -= n4;
                n3 += n4;
                this.pos = n4;
            }
        } else {
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
            this.pos += n2;
            n3 += n2;
        }
        if (!this.hasMoreData && n3 == 0 && n2 > 0) {
            return -1;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        this.checkClosed();
        if (!this.hasMoreData) {
            return 0L;
        }
        long l2 = 0L;
        if ((long)(this.count - this.pos) < l) {
            long l3;
            if (this.count - this.pos == 0) {
                this.buf = this.computeIS(true);
                this.count = this.buf.length;
                l3 = l > (long)this.count ? (long)this.count : l;
                l -= l3;
                l2 += l3;
                this.pos = (int)l3;
            } else {
                l -= (long)(this.count - this.pos);
                l2 += (long)(this.count - this.pos);
                this.pos = 0;
                this.count = 0;
            }
            while (l > 0L && this.socket.getRecord().availability() > 0 && !this.socket.getRecord().isHandshakeType() && !this.socket.getRecord().isAlertType()) {
                this.buf = this.computeIS(true);
                this.count = this.buf.length;
                this.pos = 0;
                l3 = l > (long)this.count ? (long)this.count : l;
                l -= l3;
                l2 += l3;
                this.pos = (int)l3;
            }
        } else {
            this.pos = (int)((long)this.pos + l);
            l2 += l;
        }
        return l2;
    }

    void socketClose() throws IOException {
        this.hasMoreData = false;
        this.closed = true;
    }
}

