/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.AlertException;
import com.phaos.SSL.ApplicationData;
import com.phaos.SSL.BadMACException;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.SSLSocket;
import com.phaos.SSL.SSLSocketOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class RecordOutputStream
extends SSLSocketOutputStream {
    private boolean closed = false;
    private boolean peerClosed = false;
    protected SSLSocket socket;

    public RecordOutputStream(SSLSocket sSLSocket) {
        this.socket = sSLSocket;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            if (this.peerClosed) {
                throw new IOException("Stream closed by peer");
            }
            throw new IOException("Stream closed");
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    void disable() {
        this.closed = true;
        this.peerClosed = true;
    }

    private void sendData(byte[] byArray) throws IOException {
        try {
            if (byArray.length > 0) {
                this.socket.getRecord().send(new ApplicationData(byArray));
            }
        }
        catch (AlertException alertException) {
            if (this.socket.getRecord().getProtocolVersionOut().equals(ProtocolVersion.TLS1)) {
                if (alertException.getAlertSSL_TLS() != null) {
                    this.socket.getRecord().send(alertException.getAlertSSL_TLS());
                } else if (alertException.getAlertTLS1() != null) {
                    this.socket.getRecord().send(alertException.getAlertTLS1());
                }
            } else if (alertException.getAlertSSL_TLS() != null) {
                this.socket.getRecord().send(alertException.getAlertSSL_TLS());
            } else if (alertException.getAlertSSL3() != null) {
                this.socket.getRecord().send(alertException.getAlertSSL3());
            }
            this.socket.internalClose();
            this.socket.getRecord().setStatus(3);
            if (alertException.getExceptionType() == 0) {
                throw new SSLException(alertException.toString());
            }
            if (alertException.getExceptionType() == 1) {
                throw new BadMACException(alertException.toString());
            }
            throw new RuntimeException(alertException.toString());
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            this.socket.internalClose();
            this.socket.getRecord().setStatus(3);
            throw iOException;
        }
    }

    void socketClose() throws IOException {
        this.closed = true;
        this.peerClosed = false;
    }

    public void write(int n) throws IOException {
        this.checkClosed();
        byte[] byArray = new byte[]{(byte)n};
        this.sendData(byArray);
    }

    public void write(byte[] byArray) throws IOException {
        this.checkClosed();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this.sendData(byArray2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (n < 0) {
            throw new IndexOutOfBoundsException("Offset parameter cannnot be negative: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Length parameter cannnot be negative: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Length + Offset is larger than the length of the source array");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.sendData(byArray2);
    }
}

