/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ProtocolVersion;
import java.io.IOException;

class RecordPlainText {
    static final int MAX_LENGTH = 16384;
    private int typeOut;
    private ProtocolVersion versionOut;
    private byte[] dataOut;
    private int typeIn;
    private ProtocolVersion versionIn;
    private byte[] dataIn;

    RecordPlainText(ProtocolVersion protocolVersion) {
        this.versionOut = protocolVersion;
    }

    public byte[] getDataIn() {
        return this.dataIn;
    }

    public byte[] getDataOut() {
        return this.dataOut;
    }

    public ProtocolVersion getProtocolVersionIn() {
        return this.versionIn;
    }

    public ProtocolVersion getProtocolVersionOut() {
        return this.versionOut;
    }

    public int getTypeIn() {
        return this.typeIn;
    }

    public int getTypeOut() {
        return this.typeOut;
    }

    void input(byte[] byArray) throws IOException {
        if (byArray.length > 16384) {
            AlertException alertException = new AlertException("Input SSLPlainText.fragment too large.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.RECORD_OVERFLOW));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.DECOMPRESSION_FAILURE));
            throw alertException;
        }
        this.dataIn = byArray;
    }

    void setProtocolVersionIn(ProtocolVersion protocolVersion) {
        this.versionIn = protocolVersion;
    }

    void setProtocolVersionOut(ProtocolVersion protocolVersion) {
        this.versionOut = protocolVersion;
    }

    void setTypeIn(int n) {
        this.typeIn = n;
    }

    void updatePlainOut(int n, byte[] byArray) throws IOException {
        if (byArray.length > 16384) {
            AlertException alertException = new AlertException("Input SSLPlainText.fragment too large.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        this.dataOut = byArray;
        this.typeOut = n;
    }
}

