/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Record;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class SSLByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;
    private boolean isClosed;
    private UnsyncByteArrayOutputStream os = new UnsyncByteArrayOutputStream();
    private boolean rec = false;
    private Record record;

    public SSLByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.count = byArray.length;
    }

    public SSLByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = this.mark = n;
        this.count = Math.min(n + n2, byArray.length);
    }

    public void add(byte[] byArray) {
        byte[] byArray2 = this.buf;
        this.buf = new byte[this.count - this.pos + byArray.length];
        System.arraycopy(byArray2, this.pos, this.buf, 0, this.count - this.pos);
        System.arraycopy(byArray, 0, this.buf, this.count - this.pos, byArray.length);
        this.pos = 0;
        this.count = this.buf.length;
    }

    private void assertOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("input stream closed");
        }
    }

    public int available() throws IOException {
        this.assertOpen();
        return this.count - this.pos;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    void computeIS() throws IOException {
        if (this.record.isHandshakeType()) {
            this.record.receiveMessage();
        }
    }

    public byte[] getOSBuffer() {
        return this.os.toByteArray();
    }

    public byte[] getOSBufferAndReset() throws IOException {
        byte[] byArray = this.os.toByteArray();
        this.resetOS();
        this.rec = false;
        return byArray;
    }

    public boolean getRecordOS() {
        return this.rec;
    }

    public void mark(int n) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        int n;
        this.assertOpen();
        if (this.rec && this.count - this.pos == 0) {
            this.computeIS();
        }
        int n2 = n = this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        if (this.rec && n != -1) {
            this.os.write(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.assertOpen();
        if (this.rec && this.count - this.pos == 0) {
            this.computeIS();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        if (this.rec) {
            this.os.write(this.buf, this.pos, n2);
        }
        this.pos += n2;
        return n2;
    }

    public void reset() throws IOException {
        this.assertOpen();
        this.pos = this.mark;
    }

    public void reset(byte[] byArray) throws IOException {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
        this.resetOS();
    }

    public void resetOS() throws IOException {
        this.assertOpen();
        this.os.reset();
    }

    public void setRecordLayer(Record record) {
        this.record = record;
    }

    public void setRecordOS(boolean bl) {
        this.rec = bl;
    }

    public long skip(long l) throws IOException {
        this.assertOpen();
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l <= 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }
}

