/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.HandshakeBody;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SSLException;
import com.phaos.cert.KeyPairPKCS12;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class SSLCertificate
extends HandshakeBody
implements Cloneable,
Serializable {
    private static final int handshakeType = 11;
    private static final int LENGTH_SIZE = 3;
    private static final int CERT_LENGTH_SIZE = 3;
    public Vector certificateList;
    public PrivateKey privateKey;
    private byte[][] fingerPrints;
    private String hostName;
    private SSLCrypto sslCrypto;

    public SSLCertificate() {
        this.certificateList = new Vector();
    }

    public SSLCertificate(KeyPairPKCS12 keyPairPKCS12) throws IOException {
        this.certificateList = keyPairPKCS12.getCertificateChain();
        this.privateKey = keyPairPKCS12.getPrivateKey();
        if (this.privateKey == null) {
            throw new IOException("Private key not found in PKCS#12 key pair.");
        }
        if (this.certificateList == null) {
            Vector vector = keyPairPKCS12.getAuthSafes();
            if (vector == null || vector.size() == 0) {
                throw new IOException("Certificate chain not found in PKCS#12 key pair.");
            }
            this.orderCertificateChain(vector);
            if (this.certificateList == null || this.certificateList.size() == 0) {
                throw new IOException("Certificate chain not found in PKCS#12 key pair.");
            }
        }
    }

    SSLCertificate(String string, SSLCrypto sSLCrypto, InputStream inputStream) throws IOException {
        this(null, string, sSLCrypto, inputStream);
    }

    SSLCertificate(byte[][] byArray, SSLCrypto sSLCrypto, InputStream inputStream) throws IOException {
        this(byArray, null, sSLCrypto, inputStream);
    }

    SSLCertificate(byte[][] byArray, String string, SSLCrypto sSLCrypto, InputStream inputStream) throws IOException {
        this();
        this.fingerPrints = byArray;
        this.hostName = string;
        this.sslCrypto = sSLCrypto;
        this.input(inputStream);
    }

    public void addCertificate(X509 x509) {
        if (this.certificateList == null) {
            this.certificateList = new Vector();
        }
        this.certificateList.addElement(x509);
    }

    public Object clone() {
        SSLCertificate sSLCertificate = new SSLCertificate();
        sSLCertificate.privateKey = this.privateKey;
        sSLCertificate.certificateList = this.certificateList;
        if (this.fingerPrints != null) {
            sSLCertificate.fingerPrints = (byte[][])this.fingerPrints.clone();
        }
        if (this.hostName != null) {
            sSLCertificate.hostName = new String(this.hostName);
        }
        return sSLCertificate;
    }

    public X509 getBottomCert() {
        return (X509)this.certificateList.elementAt(0);
    }

    public Vector getCertificateList() {
        return this.certificateList;
    }

    public int getHandshakeType() {
        return 11;
    }

    public String getHostName() {
        return this.hostName;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.getBottomCert().getPublicKey();
    }

    public void input(InputStream inputStream) throws IOException {
        int n = Utils.input24bit((InputStream)inputStream);
        int n2 = 0;
        while (n - n2 > 0) {
            n2 += 3 + Utils.input24bit((InputStream)inputStream);
            try {
                X509 x509 = new X509(inputStream);
                this.certificateList.addElement(x509);
            }
            catch (IOException iOException) {
                throw new SSLException(iOException.toString());
            }
        }
    }

    public int length() {
        int n = 3;
        int n2 = this.certificateList.size();
        int n3 = 0;
        while (n3 < n2) {
            n += 3 + ((X509)this.certificateList.elementAt(n3)).length();
            ++n3;
        }
        return n;
    }

    private void orderCertificateChain(Vector vector) throws InvalidInputException {
        X509 x509;
        Hashtable<X500Name, X509> hashtable = new Hashtable<X500Name, X509>();
        Hashtable<X500Name, X509> hashtable2 = new Hashtable<X500Name, X509>();
        int n = 0;
        Vector<X509> vector2 = new Vector<X509>();
        Hashtable<X509, X509> hashtable3 = new Hashtable<X509, X509>();
        int n2 = 0;
        int n3 = vector.size();
        while (n2 < n3) {
            x509 = (X509)vector.elementAt(n2);
            if (x509.getIssuer().equals((Object)x509.getSubject())) {
                vector2.addElement(x509);
                hashtable3.put(x509, x509);
            } else {
                if (hashtable.put(x509.getIssuer(), x509) != null) {
                    throw new InvalidInputException("Multiple certificates with same issuer");
                }
                if (hashtable2.put(x509.getSubject(), x509) != null) {
                    throw new InvalidInputException("Multiple certificates with same subject");
                }
            }
            ++n;
            ++n2;
        }
        if (vector2.size() == 0 && hashtable.size() > 0) {
            x509 = (X509)hashtable.get((X500Name)hashtable.keys().nextElement());
            if (x509 != null) {
                vector2.addElement(x509);
                hashtable3.put(x509, x509);
            }
        } else if (vector2.size() > 1) {
            throw new InvalidInputException("Certificate chain contains more than 1 self-signed cert");
        }
        if (vector2.size() == 1) {
            x509 = (X509)vector2.elementAt(0);
            X509 x5092 = (X509)hashtable2.get(x509.getIssuer());
            X509 x5093 = (X509)hashtable.get(x509.getSubject());
            while (x5092 != null) {
                if (hashtable3.put(x5092, x5092) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                vector2.addElement(x5092);
                x5092 = (X509)hashtable2.get(x5092.getIssuer());
            }
            while (x5093 != null) {
                if (hashtable3.put(x5093, x5093) != null) {
                    throw new InvalidInputException("Certificate chain contains a cycle");
                }
                vector2.insertElementAt(x5093, 0);
                x5093 = (X509)hashtable.get(x5093.getSubject());
            }
            if (vector2.size() != n) {
                throw new InvalidInputException("Certificate chain cannot be ordered");
            }
        }
        this.certificateList = vector2;
    }

    public void output(OutputStream outputStream) throws IOException {
        Utils.output24bit((int)(this.length() - 3), (OutputStream)outputStream);
        int n = this.certificateList.size();
        int n2 = 0;
        while (n2 < n) {
            X509 x509 = (X509)this.certificateList.elementAt(n2);
            Utils.output24bit((int)x509.length(), (OutputStream)outputStream);
            x509.output(outputStream);
            ++n2;
        }
    }

    public X509 rootCA() {
        return (X509)this.certificateList.elementAt(this.certificateList.size() - 1);
    }

    public boolean rootCAvalid() {
        return this.rootCAvalid(this.fingerPrints);
    }

    public boolean rootCAvalid(byte[][] byArray) {
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = this.rootCA().getFingerprint();
        int n = 0;
        while (n < byArray.length) {
            if (Utils.areEqual((byte[])byArray2, (byte[])byArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setCertificateList(Vector vector) {
        this.certificateList = vector;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String toString() {
        int n = this.certificateList.size();
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(n) + " certificate(s)" + (n > 0 ? ":\n" : ""));
        int n2 = 0;
        while (n2 < n) {
            X509 x509 = (X509)this.certificateList.elementAt(n2);
            stringBuffer.append(String.valueOf(Utils.toHexString((byte[])Utils.toBytes((Streamable)x509))) + "\n");
            stringBuffer.append("  " + x509 + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

