/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.SSLCertificate;
import com.phaos.cert.X509;
import com.phaos.crypto.AuthenticationException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class SSLCertificateVerifier {
    private boolean requireKnownCA;
    public static final int OK = 0;
    public static final int BAD = 1;
    public static final int UNSUPPORTED = 2;
    public static final int REVOKED = 3;
    public static final int EXPIRED = 4;
    public static final int UNKNOWN_ERROR = 5;
    protected boolean debug;
    protected PrintWriter debugOut;

    public SSLCertificateVerifier() {
        this(true);
    }

    public SSLCertificateVerifier(boolean bl) {
        this.requireKnownCA = bl;
        this.debugOut = new PrintWriter(System.out, true);
        this.debug = false;
    }

    public boolean getRequireKnownCA() {
        return this.requireKnownCA;
    }

    void setDebug(boolean bl) {
        this.debug = bl;
    }

    void setDebugOutputStream(OutputStream outputStream) {
        this.debugOut = outputStream == null ? new PrintWriter(System.out, true) : new PrintWriter(outputStream, true);
    }

    public void setRequireKnownCA(boolean bl) {
        this.requireKnownCA = bl;
    }

    public int verifyCertificate(SSLCertificate sSLCertificate) {
        int n = 0;
        while (n < sSLCertificate.certificateList.size()) {
            X509 x509 = (X509)sSLCertificate.certificateList.elementAt(n);
            try {
                if (n != sSLCertificate.certificateList.size() - 1) {
                    x509.setIssuerCertificate((X509)sSLCertificate.certificateList.elementAt(n + 1));
                    if (!x509.verify()) {
                        if (!x509.verifyCertDate()) {
                            return 4;
                        }
                        if (this.debug) {
                            this.debugOut.println("Bad certificate:");
                            Thread.dumpStack();
                        }
                        return 1;
                    }
                } else if (!x509.verifyCertDate()) {
                    return 4;
                }
            }
            catch (AuthenticationException authenticationException) {
                if (this.debug) {
                    this.debugOut.println("Bad certificate:");
                    Thread.dumpStack();
                }
                return 1;
            }
            ++n;
        }
        if (this.requireKnownCA && !sSLCertificate.rootCAvalid()) {
            if (this.debug) {
                this.debugOut.println("Bad certificate:");
                Thread.dumpStack();
            }
            return 1;
        }
        return 0;
    }
}

