/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.ConnectionState;
import com.phaos.SSL.MACHash;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCrypto;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.NullCipher;
import com.phaos.crypto.RC2AlgorithmIdentifier;
import com.phaos.utils.Utils;
import java.io.IOException;

public class SSLCipher {
    private static Class sslCipherClass;
    protected ProtocolVersion version;
    protected MACHash MACalgorithm;
    protected Cipher cipher;
    protected AlgorithmIdentifier algID;
    protected int IVSize;
    protected boolean isExportable;
    protected int maxExportableKeySize;
    protected byte[] content;
    protected byte[] mac;
    protected boolean macVerification;
    protected SSLCrypto sslCrypto;

    private void createAlgID(byte[] byArray) {
        if (this.IVSize > 0 && this.algID.getOID().equals((Object)AlgID.RC2_CBC.getOID())) {
            this.algID = new RC2AlgorithmIdentifier(byArray, 0);
        } else if (this.IVSize > 0) {
            this.algID = new CBCAlgorithmIdentifier(this.algID.getOID(), byArray);
        }
    }

    private byte[] decrypt(byte[] byArray, int n) throws CipherException, IOException {
        int n2;
        byte[] byArray2 = this.cipher.decrypt(byArray);
        if (this.cipher.getBlockSize() > 1) {
            int n3 = byArray2.length;
            int n4 = byArray2[n3 - 1] & 0xFF;
            n2 = n3 - n - n4 - 1;
            if (this.version.equals(ProtocolVersion.TLS1)) {
                int n5 = n2 + n;
                while (n5 < n2 + n + n4) {
                    if (byArray2[n5] != (byte)n4) {
                        throw new AlertException("Incorrect padding values", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPTION_FAILED));
                    }
                    ++n5;
                }
            }
        } else {
            int n6 = byArray2.length;
            n2 = n6 - n;
        }
        this.content = new byte[n2];
        System.arraycopy(byArray2, 0, this.content, 0, n2);
        if (n != 0) {
            this.mac = new byte[n];
            System.arraycopy(byArray2, n2, this.mac, 0, n);
        } else {
            this.mac = null;
        }
        return this.content;
    }

    public byte[] digestAndDecrypt(byte[] byArray, long l, int n) throws CipherException, IOException {
        this.content = this.decrypt(byArray, this.getMAClength());
        this.macVerification = this.MACalgorithm.verifyInputMAC(this.mac, l, n, this.content != null ? this.content.length : 0, this.content);
        return this.content;
    }

    public byte[] digestAndEncrypt(byte[] byArray, long l, int n, int n2) throws CipherException {
        this.mac = this.MACalgorithm.generateMAC(l, n, n2, byArray);
        return this.encrypt(byArray);
    }

    private byte[] encrypt(byte[] byArray) throws CipherException {
        byte[] byArray2;
        int n = byArray != null ? byArray.length : 0;
        int n2 = this.mac != null ? this.mac.length : 0;
        this.content = byArray;
        this.mac = this.mac;
        int n3 = this.cipher.getBlockSize();
        if (n3 > 1) {
            int n4 = n + n2 + 1;
            int n5 = n3 - n4 % n3;
            if (n5 == n3) {
                n5 = 0;
            }
            int n6 = n4 + n5;
            byArray2 = new byte[n6];
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
            if (this.mac != null) {
                System.arraycopy(this.mac, 0, byArray2, n, n2);
            }
            if (this.version.equals(ProtocolVersion.TLS1)) {
                int n7 = n + n2;
                while (n7 < n + n2 + n5) {
                    byArray2[n7] = (byte)n5;
                    ++n7;
                }
            } else {
                int n8 = n + n2;
                while (n8 < n + n2 + n5) {
                    byArray2[n8] = 0;
                    ++n8;
                }
            }
            byArray2[n + n2 + n5] = (byte)n5;
        } else {
            int n9 = n + n2;
            byArray2 = new byte[n9];
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray2, 0, n);
            }
            if (this.mac != null) {
                System.arraycopy(this.mac, 0, byArray2, n, n2);
            }
        }
        return this.cipher.encrypt(byArray2);
    }

    public void erase() {
        if (this.cipher != null) {
            this.cipher.erase();
        }
        if (this.MACalgorithm != null) {
            this.MACalgorithm.erase();
        }
        this.cipher = null;
        Utils.setArray((byte[])this.content, (byte)0);
        Utils.setArray((byte[])this.mac, (byte)0);
    }

    public AlgorithmIdentifier getAlgID() {
        return this.algID;
    }

    public final int getIVSize() {
        return this.IVSize;
    }

    public static SSLCipher getInstance(AlgorithmIdentifier algorithmIdentifier, boolean bl, int n, int n2, int n3, ProtocolVersion protocolVersion, SSLCrypto sSLCrypto) throws AlgorithmIdentifierException {
        SSLCipher sSLCipher;
        if (protocolVersion.equals(ProtocolVersion.TLS1)) {
            sSLCipher = new SSLCipher();
        } else if (sslCipherClass == null || n3 == 0 || algorithmIdentifier == null) {
            sSLCipher = new SSLCipher();
        } else {
            try {
                sSLCipher = (SSLCipher)sslCipherClass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AlgorithmIdentifierException(illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new AlgorithmIdentifierException(instantiationException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException(classCastException.toString());
            }
        }
        sSLCipher.initialize(algorithmIdentifier, bl, n, n2, n3, protocolVersion, sSLCrypto);
        return sSLCipher;
    }

    public final boolean getIsExportable() {
        return this.isExportable;
    }

    public final byte[] getMACValue() {
        return this.mac;
    }

    public int getMAClength() {
        return this.MACalgorithm.getHashSize();
    }

    public final int getMaxExportableKeySize() {
        return this.maxExportableKeySize;
    }

    protected void initialize(AlgorithmIdentifier algorithmIdentifier, boolean bl, int n, int n2, int n3, ProtocolVersion protocolVersion, SSLCrypto sSLCrypto) throws AlgorithmIdentifierException {
        this.algID = algorithmIdentifier;
        if (algorithmIdentifier == null) {
            this.cipher = new NullCipher();
        }
        this.isExportable = bl;
        this.maxExportableKeySize = n;
        this.IVSize = n2;
        this.MACalgorithm = MACHash.getInstance(n3, protocolVersion, sSLCrypto);
        this.version = protocolVersion;
        this.sslCrypto = sSLCrypto;
    }

    protected static void setClass(Class clazz) {
        sslCipherClass = clazz;
    }

    public void setReadKeyMaterials(ConnectionState connectionState) throws IOException {
        try {
            this.createAlgID(connectionState.getReadIV());
            if (this.cipher == null) {
                this.cipher = this.sslCrypto.getCipherInstance(this.algID, (Key)connectionState.getReadKey());
            } else {
                this.cipher.initialize(this.algID, (Key)connectionState.getReadKey());
            }
            this.MACalgorithm.setReadKey(connectionState.getReadMACSecret());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (InvalidKeyException invalidKeyException) {
            AlertException alertException = new AlertException(invalidKeyException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (CipherException cipherException) {
            AlertException alertException = new AlertException(cipherException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public void setWriteKeyMaterials(ConnectionState connectionState) throws IOException {
        try {
            this.createAlgID(connectionState.getWriteIV());
            if (this.cipher == null) {
                this.cipher = this.sslCrypto.getCipherInstance(this.algID, (Key)connectionState.getWriteKey());
            } else {
                this.cipher.initialize(this.algID, (Key)connectionState.getWriteKey());
            }
            this.MACalgorithm.setWriteKey(connectionState.getWriteMACSecret());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (InvalidKeyException invalidKeyException) {
            AlertException alertException = new AlertException(invalidKeyException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (CipherException cipherException) {
            AlertException alertException = new AlertException(cipherException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.cipher)) + " IVSize: " + this.IVSize + " isExportable: " + this.isExportable + " MAC: " + this.MACalgorithm.toString();
    }

    public boolean verifyMAC() {
        return this.macVerification;
    }
}

