/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DiffieHellman;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import java.io.IOException;
import java.math.BigInteger;

public class SSLCrypto {
    private static Class sslCryptoClass;

    public Cipher getCipherInstance(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        return Cipher.getInstance((AlgorithmIdentifier)algorithmIdentifier, (Key)key);
    }

    public DiffieHellman getDiffieHellmanInstance() throws AlgorithmIdentifierException {
        return DiffieHellman.getInstance();
    }

    public DiffieHellman getDiffieHellmanInstance(RandomBitsSource randomBitsSource, int n) throws AlgorithmIdentifierException {
        return DiffieHellman.getInstance((RandomBitsSource)randomBitsSource, (int)n);
    }

    public DiffieHellman getDiffieHellmanInstance(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        return DiffieHellman.getInstance((BigInteger)bigInteger, (BigInteger)bigInteger2, (RandomBitsSource)randomBitsSource);
    }

    public static SSLCrypto getInstance() throws IOException {
        if (sslCryptoClass == null) {
            return new SSLCrypto();
        }
        try {
            return (SSLCrypto)sslCryptoClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            AlertException alertException = new AlertException("Unable to instantiate " + sslCryptoClass.getName() + ":" + illegalAccessException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (InstantiationException instantiationException) {
            AlertException alertException = new AlertException("Unable to instantiate " + sslCryptoClass.getName() + ":" + instantiationException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (ClassCastException classCastException) {
            AlertException alertException = new AlertException("Class does not implement  " + sslCryptoClass.getName() + ":" + classCastException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public MessageDigest getMessageDigestInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        return MessageDigest.getInstance((AlgorithmIdentifier)algorithmIdentifier);
    }

    public RandomBitsSource getRBS(RandomBitsSource randomBitsSource) {
        if (randomBitsSource == null) {
            return RandomBitsSource.getDefault();
        }
        return randomBitsSource;
    }

    public Signature getSignatureInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        return Signature.getInstance((AlgorithmIdentifier)algorithmIdentifier);
    }

    public Signature getSignatureInstance(PrivateKey privateKey) throws SignatureException {
        return Signature.getInstance((PrivateKey)privateKey);
    }

    public Signature getSignatureInstance(PublicKey publicKey) throws AuthenticationException {
        return Signature.getInstance((PublicKey)publicKey);
    }

    protected static void setClass(Class clazz) {
        sslCryptoClass = clazz;
    }
}

