/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.ClientSessionCache;
import com.phaos.SSL.HashtableSessionCache;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLCertificateVerifier;
import com.phaos.SSL.ServerSessionCache;
import com.phaos.SSL.SessionParams;
import com.phaos.cert.CertificateTrustPolicy;
import com.phaos.cert.X500Name;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RandomBitsSource;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;

public class SSLParams
implements Cloneable {
    public static final short SSL_NULL_WITH_NULL_NULL = 0;
    public static final short SSL_RSA_WITH_NULL_MD5 = 1;
    public static final short SSL_RSA_WITH_NULL_SHA = 2;
    public static final short SSL_RSA_EXPORT_WITH_RC4_40_MD5 = 3;
    public static final short SSL_RSA_WITH_RC4_128_MD5 = 4;
    public static final short SSL_RSA_WITH_RC4_128_SHA = 5;
    public static final short SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6;
    public static final short SSL_RSA_EXPORT_WITH_DES_40_CBC_SHA = 8;
    public static final short SSL_RSA_WITH_DES_CBC_SHA = 9;
    public static final short SSL_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    public static final short SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17;
    public static final short SSL_DHE_DSS_WITH_DES_CBC_SHA = 18;
    public static final short SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    public static final short SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20;
    public static final short SSL_DHE_RSA_WITH_DES_CBC_SHA = 21;
    public static final short SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    public static final short SSL_DH_anon_EXPORT_WITH_RC4_40_MD5 = 23;
    public static final short SSL_DH_anon_WITH_RC4_128_MD5 = 24;
    public static final short SSL_DH_anon_EXPORT_WITH_DES_40_CBC_SHA = 25;
    public static final short SSL_DH_anon_WITH_DES_CBC_SHA = 26;
    public static final short SSL_DH_anon_WITH_3DES_EDE_CBC_SHA = 27;
    public static final short TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    public static final short TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    public static final short TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    public static final short TLS_DH_anon_WITH_AES_128_CBC_SHA = 52;
    public static final short TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    public static final short TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    public static final short TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;
    public static final short TLS_DH_anon_WITH_AES_256_CBC_SHA = 58;
    public static final short TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA = 98;
    public static final short TLS_RSA_EXPORT1024_WITH_RC4_56_SHA = 100;
    public static final short TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 99;
    public static final short TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 101;
    public static final short TLS_DHE_DSS_WITH_RC4_128_SHA = 102;
    public static final int SSL2_CK_RC4_128_WITH_MD5 = 65664;
    public static final int SSL2_CK_RC4_128_EXPORT40_WITH_MD5 = 131200;
    public static final int SSL2_CK_RC2_128_CBC_WITH_MD5 = 196736;
    public static final int SSL2_CK_RC2_128_CBC_EXPORT40_WITH_MD5 = 262272;
    public static final int SSL2_CK_DES_64_CBC_WITH_MD5 = 393280;
    public static final int SSL2_CK_DES_192_EDE3_CBC_WITH_MD5 = 458944;
    public static final short SSL_RSA_WITH_BLOWFISH_CBC_MD5 = -255;
    public static final short SSL_RSA_WITH_BLOWFISH_CBC_SHA = -254;
    public static final short SSL_DHE_DSS_WITH_BLOWFISH_CBC_MD5 = -253;
    public static final short SSL_DHE_DSS_WITH_BLOWFISH_CBC_SHA = -252;
    public static final short SSL_DHE_RSA_WITH_BLOWFISH_CBC_MD5 = -251;
    public static final short SSL_DHE_RSA_WITH_BLOWFISH_CBC_SHA = -250;
    public static final short SSL_DH_anon_WITH_BLOWFISH_CBC_MD5 = -249;
    public static final short SSL_DH_anon_WITH_BLOWFISH_CBC_SHA = -248;
    public static final int rsa_sign = 1;
    public static final int dss_sign = 2;
    public static final int rsa_fixed_dh = 3;
    public static final int dss_fixed_dh = 4;
    public static final int rsa_ephemeral_dh = 5;
    public static final int dss_ephemeral_dh = 6;
    public static final int fortezza_dms = 20;
    private boolean useV2Hello = true;
    private boolean requestClientCert;
    private boolean requireClientCert;
    private short[] clientCipherSuites = new short[]{5, 4, 53, 47, 10, 9, 3, 6, 8, 56, 50, 19, 18, 58, 52, 26, 27};
    private short[] serverCipherSuites = new short[]{5, 4, 53, 47, 10, 9, 100, 98, 8, 3, 6, 2, 1, 57, 51, 22, 21, 20, 56, 50, 19, 18, 17, 58, 52, 24, 27, 26, 25, 23};
    private int[] ssl2ClientCipherKinds = new int[]{65664, 131200, 196736};
    private int[] ssl2ServerCipherKinds = new int[]{65664, 196736, 131200};
    private SSLCertificate serverCert;
    private SSLCertificate serverCertDSA;
    private Vector clientCerts;
    private boolean requireAcceptableClientRootCAs;
    private CertificateTrustPolicy trustPolicy;
    private boolean verifyHostName;
    private byte[][] rootCAFingerprints;
    private SSLCertificateVerifier certVerifier = new SSLCertificateVerifier();
    private X500Name[] clientRootCAs = new X500Name[0];
    private byte[] clientCertTypes = new byte[]{1, 2};
    private BigInteger dhModulus = new BigInteger("120643146720241146742674304125842117998143805514448411061865279761243058990649481072105630130828388727635875191903594522667236243814198374174583764874551505977117158828808948871254284977481256982921449561013872693509294426425418748315498252459326106907106292694972398318898182271154478282562159489207828934059");
    private BigInteger dhGenerator = BigInteger.valueOf(4L);
    private static ClientSessionCache globalClientSessionCache = new HashtableSessionCache();
    private ClientSessionCache clientSessionCache = globalClientSessionCache;
    private ServerSessionCache serverSessionCache;
    private boolean resumableSessions;
    private SessionParams sessionParams;
    private RandomBitsSource rng;
    private RSAPrivateKey tempKey;
    private boolean use16ByteChallenge;
    private boolean use16ByteConnectionID;
    private boolean ssl2DESKeyCompatibility;
    private OutputStream debugOut = System.out;
    private boolean debug;
    private boolean allowSSL2 = false;
    private boolean allowTLS1;
    private boolean allowSSL3 = true;
    private boolean ignoreUnexpectedEOF;
    private boolean pmsCompatibility;

    public void addClientCert(SSLCertificate sSLCertificate) {
        if (this.clientCerts == null) {
            this.clientCerts = new Vector();
        }
        this.clientCerts.addElement(sSLCertificate);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void configureForMaximumCompatibility() {
        this.setIgnoreUnexpectedEOF(true);
        this.setPMSCompatibility(true);
        this.setSSL2Use16ByteChallenge(true);
        this.setSSL2Use16ByteConnectionID(true);
        this.setSSL2DESKeyCompatibility(true);
    }

    public boolean getAllowSSL2() {
        return this.allowSSL2;
    }

    public boolean getAllowSSL3() {
        return this.allowSSL3;
    }

    public boolean getAllowTLS1() {
        return this.allowTLS1;
    }

    public SSLCertificateVerifier getCertVerifier() {
        return this.certVerifier;
    }

    public CertificateTrustPolicy getCertificateTrustPolicy() {
        return this.trustPolicy;
    }

    public SSLCertificate getClientCert() {
        return this.clientCerts != null ? (SSLCertificate)this.clientCerts.elementAt(0) : null;
    }

    public byte[] getClientCertTypes() {
        return this.clientCertTypes;
    }

    public Vector getClientCerts() {
        return this.clientCerts;
    }

    public short[] getClientCipherSuites() {
        return this.clientCipherSuites;
    }

    public X500Name[] getClientRootCAs() {
        return this.clientRootCAs;
    }

    public ClientSessionCache getClientSessionCache() {
        return this.clientSessionCache;
    }

    public BigInteger getDHGenerator() {
        return this.dhGenerator;
    }

    public BigInteger getDHModulus() {
        return this.dhModulus;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public OutputStream getDebugOutputStream() {
        return this.debugOut;
    }

    public static ClientSessionCache getGlobalClientSessionCache() {
        return globalClientSessionCache;
    }

    public boolean getIgnoreUnexpectedEOF() {
        return this.ignoreUnexpectedEOF;
    }

    public boolean getPMSCompatibility() {
        return this.pmsCompatibility;
    }

    ProtocolVersion getProtocolVersion() throws IOException {
        return new ProtocolVersion(this.allowSSL2, this.allowSSL3, this.allowTLS1);
    }

    public RandomBitsSource getRNG() {
        return this.rng;
    }

    public boolean getRequestClientCert() {
        return this.requestClientCert;
    }

    public boolean getRequireAcceptableClientRootCAs() {
        return this.requireAcceptableClientRootCAs;
    }

    public boolean getRequireClientCert() {
        return this.requireClientCert;
    }

    public boolean getResumableSessions() {
        return this.resumableSessions;
    }

    public byte[][] getRootCAFingerprints() {
        return this.rootCAFingerprints;
    }

    public int[] getSSL2ClientCipherKinds() {
        return this.ssl2ClientCipherKinds;
    }

    public boolean getSSL2DESKeyCompatibility() {
        return this.ssl2DESKeyCompatibility;
    }

    public int[] getSSL2ServerCipherKinds() {
        return this.ssl2ServerCipherKinds;
    }

    public boolean getSSL2Use16ByteChallenge() {
        return this.use16ByteChallenge;
    }

    public boolean getSSL2Use16ByteConnectionID() {
        return this.use16ByteConnectionID;
    }

    public SSLCertificate getServerCert() {
        return this.serverCert;
    }

    public SSLCertificate getServerCertDSA() {
        return this.serverCertDSA;
    }

    public short[] getServerCipherSuites() {
        return this.serverCipherSuites;
    }

    public ServerSessionCache getServerSessionCache() {
        return this.serverSessionCache;
    }

    public Hashtable getSessionCache() {
        if (this.getServerSessionCache() instanceof HashtableSessionCache) {
            return ((HashtableSessionCache)this.getServerSessionCache()).getServerCache();
        }
        throw new IllegalStateException("serverSessionCache is not an instance of HashtableSessionCache");
    }

    public SessionParams getSessionParams() {
        return this.sessionParams;
    }

    public RSAPrivateKey getTempKey() {
        return this.tempKey;
    }

    public boolean getUseV2Hello() {
        return this.useV2Hello;
    }

    public boolean getVerifyHostName() {
        return this.verifyHostName;
    }

    public void setAllowSSL2(boolean bl) {
        this.allowSSL2 = bl;
    }

    public void setAllowSSL3(boolean bl) {
        this.allowSSL3 = bl;
    }

    public void setAllowTLS1(boolean bl) {
        this.allowTLS1 = bl;
    }

    public void setCertVerifier(SSLCertificateVerifier sSLCertificateVerifier) {
        this.certVerifier = sSLCertificateVerifier;
    }

    public void setCertificateTrustPolicy(CertificateTrustPolicy certificateTrustPolicy) {
        this.trustPolicy = certificateTrustPolicy;
    }

    public void setClientCert(SSLCertificate sSLCertificate) {
        this.clientCerts = new Vector();
        this.clientCerts.addElement(sSLCertificate);
    }

    public void setClientCertTypes(byte[] byArray) {
        this.clientCertTypes = byArray;
    }

    public void setClientCerts(Vector vector) {
        this.clientCerts = vector;
    }

    public void setClientCipherSuites(short[] sArray) {
        this.clientCipherSuites = sArray;
    }

    public void setClientRootCAs(X500Name[] x500NameArray) {
        this.clientRootCAs = x500NameArray;
    }

    public void setClientSessionCache(ClientSessionCache clientSessionCache) {
        this.clientSessionCache = clientSessionCache;
        this.setResumableSessions(true);
    }

    public void setDHGenerator(BigInteger bigInteger) {
        this.dhGenerator = bigInteger;
    }

    public void setDHModulus(BigInteger bigInteger) {
        this.dhModulus = bigInteger;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDebugOutputStream(OutputStream outputStream) {
        this.debugOut = outputStream == null ? System.out : outputStream;
    }

    public static void setGlobalClientSessionCache(ClientSessionCache clientSessionCache) {
        globalClientSessionCache = clientSessionCache;
    }

    public void setIgnoreUnexpectedEOF(boolean bl) {
        this.ignoreUnexpectedEOF = bl;
    }

    public void setPMSCompatibility(boolean bl) {
        this.pmsCompatibility = bl;
    }

    public void setRNG(RandomBitsSource randomBitsSource) {
        this.rng = randomBitsSource;
    }

    public void setRequestClientCert(boolean bl) {
        this.requestClientCert = bl;
    }

    public void setRequireAcceptableClientRootCAs(boolean bl) {
        this.requireAcceptableClientRootCAs = bl;
    }

    public void setRequireClientCert(boolean bl) {
        this.requireClientCert = bl;
        if (this.requireClientCert) {
            this.requestClientCert = true;
        }
    }

    public void setResumableSessions(boolean bl) {
        this.resumableSessions = bl;
    }

    public void setRootCAFingerprints(byte[][] byArray) {
        this.rootCAFingerprints = byArray;
    }

    public void setSSL2ClientCipherKinds(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            switch (nArray[n2]) {
                case 65664: 
                case 131200: 
                case 196736: 
                case 262272: 
                case 393280: 
                case 458944: {
                    ++n;
                    break;
                }
            }
            ++n2;
        }
        if (n != nArray.length) {
            this.ssl2ClientCipherKinds = new int[n];
            int n3 = 0;
            int n4 = 0;
            while (n3 < nArray.length) {
                switch (nArray[n3]) {
                    case 65664: 
                    case 131200: 
                    case 196736: 
                    case 262272: 
                    case 393280: 
                    case 458944: {
                        this.ssl2ClientCipherKinds[n4++] = nArray[n3];
                        break;
                    }
                }
                ++n3;
            }
        } else {
            this.ssl2ClientCipherKinds = nArray;
        }
    }

    public void setSSL2DESKeyCompatibility(boolean bl) {
        this.ssl2DESKeyCompatibility = bl;
    }

    public void setSSL2ServerCipherKinds(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            switch (nArray[n2]) {
                case 65664: 
                case 131200: 
                case 196736: 
                case 262272: 
                case 393280: 
                case 458944: {
                    ++n;
                    break;
                }
            }
            ++n2;
        }
        if (n != nArray.length) {
            this.ssl2ServerCipherKinds = new int[n];
            int n3 = 0;
            int n4 = 0;
            while (n3 < nArray.length) {
                switch (nArray[n3]) {
                    case 65664: 
                    case 131200: 
                    case 196736: 
                    case 262272: 
                    case 393280: 
                    case 458944: {
                        this.ssl2ServerCipherKinds[n4++] = nArray[n3];
                        break;
                    }
                }
                ++n3;
            }
        } else {
            this.ssl2ServerCipherKinds = nArray;
        }
    }

    public void setSSL2Use16ByteChallenge(boolean bl) {
        this.use16ByteChallenge = bl;
    }

    public void setSSL2Use16ByteConnectionID(boolean bl) {
        this.use16ByteConnectionID = bl;
    }

    public void setServerCert(SSLCertificate sSLCertificate) {
        this.serverCert = sSLCertificate;
        short[] sArray = this.serverCipherSuites;
        int n = 0;
        int n2 = 0;
        while (n2 < sArray.length) {
            if (CipherSpec.matches(sArray[n2], sSLCertificate)) {
                ++n;
            }
            ++n2;
        }
        this.serverCipherSuites = new short[n];
        n = 0;
        int n3 = 0;
        while (n3 < sArray.length) {
            if (CipherSpec.matches(sArray[n3], sSLCertificate)) {
                this.serverCipherSuites[n++] = sArray[n3];
            }
            ++n3;
        }
    }

    public void setServerCerts(SSLCertificate sSLCertificate, SSLCertificate sSLCertificate2) {
        if (!sSLCertificate.getPublicKey().getAlgID().getOID().equals((Object)AlgID.rsaEncryption.getOID())) {
            throw new IllegalArgumentException("The first argument has to be an RSA certificate");
        }
        if (!sSLCertificate2.getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsaOld.getOID()) && !sSLCertificate2.getPublicKey().getAlgID().getOID().equals((Object)AlgID.dsa.getOID())) {
            throw new IllegalArgumentException("The second argument has to be a DSA certificate");
        }
        this.serverCert = sSLCertificate;
        this.serverCertDSA = sSLCertificate2;
    }

    public void setServerCipherSuites(short[] sArray) {
        this.serverCipherSuites = sArray;
    }

    public void setServerSessionCache(ServerSessionCache serverSessionCache) {
        this.serverSessionCache = serverSessionCache;
        this.setResumableSessions(true);
    }

    public void setSessionCache(Hashtable hashtable) {
        this.setServerSessionCache(new HashtableSessionCache(false, hashtable));
    }

    public void setSessionParams(SessionParams sessionParams) {
        this.sessionParams = sessionParams;
        this.clientCipherSuites = new short[]{sessionParams.cipherSuite};
    }

    public void setTempKey(RSAPrivateKey rSAPrivateKey) {
        this.tempKey = rSAPrivateKey;
    }

    public void setUseV2Hello(boolean bl) {
        this.useV2Hello = bl;
    }

    public void setVerifyHostName(boolean bl) {
        this.verifyHostName = bl;
    }
}

