/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.HashtableSessionCache;
import com.phaos.SSL.SSLParams;
import com.phaos.SSL.SSLSocket;
import com.phaos.SSL.ServerSessionCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class SSLServerSocket
extends ServerSocket {
    private SSLParams params;

    public SSLServerSocket(int n) throws IOException {
        this(n, new SSLParams());
    }

    public SSLServerSocket(int n, int n2) throws IOException {
        this(n, n2, new SSLParams());
    }

    public SSLServerSocket(int n, int n2, SSLParams sSLParams) throws IOException {
        super(n, n2);
        this.params = sSLParams;
        this.initialize();
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        this(n, n2, inetAddress, new SSLParams());
    }

    public SSLServerSocket(int n, int n2, InetAddress inetAddress, SSLParams sSLParams) throws IOException {
        super(n, n2, inetAddress);
        this.params = sSLParams;
        this.initialize();
    }

    public SSLServerSocket(int n, SSLParams sSLParams) throws IOException {
        super(n);
        this.params = sSLParams;
        this.initialize();
    }

    public Socket accept() throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.acceptNoHandshake();
        sSLSocket.performAcceptHandshake();
        return sSLSocket;
    }

    public Socket acceptNoHandshake() throws IOException {
        SSLSocket sSLSocket = new SSLSocket(this.params);
        this.implAccept(sSLSocket);
        sSLSocket.initialize();
        if (sSLSocket.getRecord().getSessionState().getDebug()) {
            sSLSocket.getRecord().getSessionState().debugln("Connection from " + sSLSocket.getInetAddress().getHostName());
        }
        return sSLSocket;
    }

    public void clearServerSessionCache() {
        this.params.getServerSessionCache().clearServerSessionCache();
    }

    public ServerSessionCache getServerSessionCache() {
        return this.params.getServerSessionCache();
    }

    private void initialize() throws IOException {
        if (this.params.getResumableSessions() && this.params.getServerSessionCache() == null) {
            this.params = (SSLParams)this.params.clone();
            this.params.setServerSessionCache(new HashtableSessionCache());
        }
    }
}

