/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.ClientHelloV2;
import com.phaos.SSL.ConnectionState;
import com.phaos.SSL.Handshake;
import com.phaos.SSL.Message;
import com.phaos.SSL.NoMoreDataException;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Record;
import com.phaos.SSL.RecordInputStream;
import com.phaos.SSL.RecordOutputStream;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SSLException;
import com.phaos.SSL.SSLParams;
import com.phaos.SSL.ServerHelloV2;
import com.phaos.SSL.SessionParams;
import com.phaos.SSL.SessionState;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SSLSocket
extends Socket {
    private boolean rawClient;
    protected String serverName;
    protected int port = -1;
    private Record record;
    private Handshake handshake;
    private RecordInputStream recordIS;
    private RecordOutputStream recordOS;
    private SSLParams params;
    private SSLCrypto sslCrypto;
    private static boolean closeNotifyReceived = false;
    private static boolean ssl2Supported = false;
    private static boolean checkedForSSL2Plugin = false;
    private SessionParams sessionParams;
    private SSLSocket sslSocketV2;
    private final Object lockRecordIS = new Object();
    private final Object lockRecordOS = new Object();
    static /* synthetic */ Class class$com$phaos$SSL$SSL2$SSLSocketV2;

    protected SSLSocket() throws IOException {
        this.sslCrypto = SSLCrypto.getInstance();
    }

    public SSLSocket(SSLParams sSLParams) throws IOException {
        this.params = sSLParams;
        this.sslCrypto = SSLCrypto.getInstance();
        this.record = new Record(sSLParams.getProtocolVersion(), new SessionState(false, this.sslCrypto, sSLParams.getDebug(), sSLParams.getDebugOutputStream()), new ConnectionState());
        this.handshake = new Handshake(this.record, sSLParams, false, this.sslCrypto, this);
        this.rawClient = true;
    }

    SSLSocket(SSLParams sSLParams, InputStream inputStream, OutputStream outputStream, String string, int n) throws IOException {
        this.params = sSLParams;
        this.serverName = string;
        this.port = n;
        this.sslCrypto = SSLCrypto.getInstance();
        this.record = new Record(sSLParams.getProtocolVersion(), new SessionState(false, this.sslCrypto, sSLParams.getDebug(), sSLParams.getDebugOutputStream()), new ConnectionState(), inputStream, outputStream);
        this.handshake = new Handshake(this.record, sSLParams, string, n, false, this.sslCrypto, this);
        this.rawClient = true;
    }

    public SSLSocket(String string, int n) throws UnknownHostException, IOException {
        this(string, n, new SSLParams());
    }

    public SSLSocket(String string, int n, SSLParams sSLParams) throws UnknownHostException, IOException {
        this(string, n, sSLParams, true);
    }

    public SSLSocket(String string, int n, SSLParams sSLParams, boolean bl) throws UnknownHostException, IOException {
        super(string, n);
        try {
            this.params = sSLParams;
            this.sslCrypto = SSLCrypto.getInstance();
            this.record = new Record(sSLParams.getProtocolVersion(), new SessionState(true, this.sslCrypto, sSLParams.getDebug(), sSLParams.getDebugOutputStream()), new ConnectionState(), super.getInputStream(), super.getOutputStream());
            this.serverName = string;
            this.port = n;
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Connected to " + string + ":" + n);
            }
            this.rawClient = bl ^ true;
            this.handshake = new Handshake(this.record, sSLParams, this.serverName, n, true, this.sslCrypto, this);
            if (bl) {
                this.handshake.startHandshake();
            }
            if (this.sslSocketV2 == null) {
                this.sessionParams = this.record.getSessionParams();
            }
            this.handshake.erase();
        }
        catch (IOException iOException) {
            if (this.record != null && this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("SSLSocket initialization to " + this.serverName + ":" + n + " failed.");
            }
            super.close();
            throw iOException;
        }
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2) throws UnknownHostException, IOException {
        this(string, n, inetAddress, n2, new SSLParams());
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2, SSLParams sSLParams) throws UnknownHostException, IOException {
        this(string, n, inetAddress, n2, sSLParams, true);
    }

    public SSLSocket(String string, int n, InetAddress inetAddress, int n2, SSLParams sSLParams, boolean bl) throws UnknownHostException, IOException {
        super(string, n, inetAddress, n2);
        try {
            this.params = sSLParams;
            this.sslCrypto = SSLCrypto.getInstance();
            this.record = new Record(sSLParams.getProtocolVersion(), new SessionState(true, this.sslCrypto, sSLParams.getDebug(), sSLParams.getDebugOutputStream()), new ConnectionState(), super.getInputStream(), super.getOutputStream());
            this.serverName = string;
            this.port = n;
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Connected to " + string + ":" + n);
            }
            this.rawClient = bl ^ true;
            this.handshake = new Handshake(this.record, sSLParams, this.serverName, n, true, this.sslCrypto, this);
            if (bl) {
                this.handshake.startHandshake();
            }
            if (this.sslSocketV2 == null) {
                this.sessionParams = this.record.getSessionParams();
            }
            this.handshake.erase();
        }
        catch (IOException iOException) {
            if (this.record != null && this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("SSLSocket initialization to " + this.serverName + ":" + n + " failed.");
            }
            super.close();
            throw iOException;
        }
    }

    public SSLSocket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress, n, new SSLParams());
    }

    public SSLSocket(InetAddress inetAddress, int n, SSLParams sSLParams) throws IOException {
        this(inetAddress, n, sSLParams, true);
    }

    public SSLSocket(InetAddress inetAddress, int n, SSLParams sSLParams, boolean bl) throws IOException {
        super(inetAddress, n);
        try {
            this.params = sSLParams;
            this.sslCrypto = SSLCrypto.getInstance();
            this.record = new Record(sSLParams.getProtocolVersion(), new SessionState(true, this.sslCrypto, sSLParams.getDebug(), sSLParams.getDebugOutputStream()), new ConnectionState(), super.getInputStream(), super.getOutputStream());
            this.serverName = inetAddress.getHostAddress();
            this.port = n;
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Connected to " + inetAddress + ":" + n);
            }
            this.rawClient = bl ^ true;
            this.handshake = new Handshake(this.record, sSLParams, this.serverName, n, true, this.sslCrypto, this);
            if (bl) {
                this.handshake.startHandshake();
            }
            if (this.sslSocketV2 == null) {
                this.sessionParams = this.record.getSessionParams();
            }
            this.handshake.erase();
        }
        catch (IOException iOException) {
            if (this.record != null && this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("SSLSocket initialization to " + this.serverName + ":" + n + " failed.");
            }
            super.close();
            throw iOException;
        }
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress, n, inetAddress2, n2, new SSLParams());
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, SSLParams sSLParams) throws IOException {
        this(inetAddress, n, inetAddress2, n2, sSLParams, true);
    }

    public SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, SSLParams sSLParams, boolean bl) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        try {
            this.params = sSLParams;
            this.sslCrypto = SSLCrypto.getInstance();
            this.record = new Record(sSLParams.getProtocolVersion(), new SessionState(true, this.sslCrypto, sSLParams.getDebug(), sSLParams.getDebugOutputStream()), new ConnectionState(), super.getInputStream(), super.getOutputStream());
            this.serverName = inetAddress.getHostAddress();
            this.port = n;
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Connected to " + inetAddress + ":" + n);
            }
            this.rawClient = bl ^ true;
            this.handshake = new Handshake(this.record, sSLParams, this.serverName, n, true, this.sslCrypto, this);
            if (bl) {
                this.handshake.startHandshake();
            }
            if (this.sslSocketV2 == null) {
                this.sessionParams = this.record.getSessionParams();
            }
            this.handshake.erase();
        }
        catch (IOException iOException) {
            if (this.record != null && this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("SSLSocket initialization to " + this.serverName + ":" + n + " failed.");
            }
            super.close();
            throw iOException;
        }
    }

    protected SSLSocket(boolean bl) throws IOException {
    }

    public void abort() throws IOException {
        if (this.sslSocketV2 != null) {
            this.sslSocketV2.abort();
            return;
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Aborting socket");
        }
        this.erase();
        this.internalClose();
        if (this.record == null) {
            return;
        }
        this.record.setStatus(3);
    }

    /*
     * Unable to fully structure code
     */
    public void awaitClose() throws IOException {
        if (this.sslSocketV2 != null) {
            this.sslSocketV2.awaitClose();
            return;
        }
        if (this.record == null) {
            return;
        }
        if (!SSLSocket.closeNotifyReceived) ** GOTO lbl33
        return;
lbl-1000:
        // 1 sources

        {
            try {
                var1_1 = this.record.receive();
                if (var1_1.getType() != 21 || (var2_4 = (Alert)var1_1).getError().getValue() != Alert.Error.CLOSE_NOTIFY.getValue()) continue;
                this.record.setStatus(2);
                if (this.record.getSessionState().getDebug()) {
                    this.record.getSessionState().debugln("Close notify received: " + var2_4);
                }
                this.setCloseNotifyReceived();
                continue;
            }
            catch (NoMoreDataException var1_2) {
                if (this.record.getSessionState().getDebug()) {
                    this.record.getSessionState().debugln("Problems waiting for the close notify: " + var1_2.getMessage());
                }
                if (!this.params.getIgnoreUnexpectedEOF()) {
                    throw new EOFException("End of stream encountered without receiving expected close notify message from peer");
                }
                this.record.setStatus(2);
                if (!this.record.getSessionState().getDebug()) continue;
                this.record.getSessionState().debugln("End of stream reached instead of close notify");
                continue;
            }
            catch (SocketException var1_3) {
                if (this.record.getSessionState().getDebug()) {
                    this.record.getSessionState().debugln("Problems waiting for the close notify: " + var1_3.getMessage());
                }
                if (!this.params.getIgnoreUnexpectedEOF()) {
                    throw new EOFException("End of stream encountered without receiving expected close notify message from peer");
                }
                this.record.setStatus(2);
                if (!this.record.getSessionState().getDebug()) continue;
                this.record.getSessionState().debugln("SocketException thrown instead of close notify");
            }
lbl33:
            // 7 sources

            ** while (this.record.getStatus() != 2)
        }
lbl34:
        // 1 sources

    }

    private static synchronized boolean checkForSSL2Plugin() {
        if (checkedForSSL2Plugin) {
            return ssl2Supported;
        }
        try {
            (class$com$phaos$SSL$SSL2$SSLSocketV2 != null ? class$com$phaos$SSL$SSL2$SSLSocketV2 : (class$com$phaos$SSL$SSL2$SSLSocketV2 = SSLSocket.class$("com.phaos.SSL.SSL2.SSLSocketV2"))).getName();
        }
        catch (Throwable throwable) {
            ssl2Supported = false;
            checkedForSSL2Plugin = true;
            return false;
        }
        ssl2Supported = true;
        checkedForSSL2Plugin = true;
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void clientSwap(ClientHelloV2 clientHelloV2, ServerHelloV2 serverHelloV2, SessionParams sessionParams) throws IOException {
        SSLSocket sSLSocket = null;
        if (!ssl2Supported) {
            throw new IOException("Unable to accept SSL2 connectionswithout the SSLava SSL2 plugin");
        }
        try {
            sSLSocket = (SSLSocket)Class.forName("com.phaos.SSL.SSL2.SSLSocketV2").newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Unable to load SSL2 libraries: " + exception.getMessage());
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Constructing the SSL2 socket.");
        }
        sSLSocket.constructV2Socket(this.record.getBufferedInputStream(), this.record.getOS(), this.params, this.sslCrypto, true, this.serverName, this.getPort());
        this.sslSocketV2 = sSLSocket;
        try {
            this.sslSocketV2.performV2ClientHandshake(clientHelloV2, serverHelloV2, sessionParams);
        }
        catch (IOException iOException) {
            this.sslSocketV2.abort();
            throw iOException;
        }
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean bl) throws IOException {
        if (this.sslSocketV2 != null) {
            this.sslSocketV2.close();
            return;
        }
        if (this.record == null || this.record.getStatus() == 3 || this.record.getStatus() == 2) {
            super.close();
            return;
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Closing " + (this.record.getProtocolVersionOut().equals(ProtocolVersion.TLS1) ? "TLS1" : "SSL") + " socket");
        }
        try {
            block10: {
                this.sendCloseNotify();
                if (bl) {
                    try {
                        this.awaitClose();
                    }
                    catch (EOFException eOFException) {
                        if (this.params.getIgnoreUnexpectedEOF()) break block10;
                        throw eOFException;
                    }
                }
            }
            Object var3_3 = null;
            this.erase();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.erase();
            this.internalClose();
            if (this.record != null) {
                this.record.setStatus(3);
            }
            throw throwable;
        }
        this.internalClose();
        if (this.record != null) {
            this.record.setStatus(3);
        }
    }

    protected void constructV2Socket(BufferedInputStream bufferedInputStream, OutputStream outputStream, SSLParams sSLParams, SSLCrypto sSLCrypto, boolean bl, String string, int n) throws IOException {
        throw new IllegalStateException("This method may not be called on the SSLSocket class.");
    }

    void disableInputStream() {
        this.recordIS.disable();
    }

    void disableOutputStream() {
        this.recordOS.disable();
    }

    void erase() {
        if (this.sessionParams != null) {
            this.sessionParams.erase();
            this.sessionParams = null;
        }
    }

    void eraseRecordSecrets() {
        if (this.record != null && this.record.getSessionState() != null) {
            this.record.getSessionState().erase();
        }
        if (this.record != null && this.record.getConnectionState() != null) {
            this.record.getConnectionState().erase();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            Object var2_1 = null;
            super.finalize();
        }
    }

    public SSLCertificate getClientCert() {
        if (this.handshakeInProgress()) {
            return null;
        }
        if (this.handshakePerformed()) {
            if (this.sslSocketV2 != null) {
                return this.sslSocketV2.getServerCert();
            }
            return this.record.getSessionState().isClient() ? this.record.getSessionState().getCert() : this.record.getSessionState().getPeerCert();
        }
        if (this.handshake != null && this.handshake.getHandshakeParams() != null && this.handshake.getHandshakeParams().getSSLParams().getClientCerts() != null) {
            return (SSLCertificate)this.handshake.getHandshakeParams().getSSLParams().getClientCerts().elementAt(0);
        }
        return null;
    }

    boolean getClientMode() {
        return this.record.getSessionState().isClient();
    }

    public InputStream getInputStream() throws IOException {
        if (this.handshake.isInProgress()) {
            return null;
        }
        if (this.handshake.isPerformed()) {
            if (this.sslSocketV2 != null) {
                return this.sslSocketV2.getInputStream();
            }
            if (this.record == null || this.record.getStatus() != 1) {
                throw new IOException("Streams of closed socket are not available");
            }
            Object object = this.lockRecordIS;
            synchronized (object) {
                if (this.recordIS == null) {
                    this.recordIS = new RecordInputStream(this);
                }
            }
            return this.recordIS;
        }
        if (this.rawClient) {
            try {
                return this.getRawInputStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this.sslSocketV2 != null) {
            return this.sslSocketV2.getInputStream();
        }
        Object object = this.lockRecordIS;
        synchronized (object) {
            if (this.recordIS == null) {
                this.recordIS = new RecordInputStream(this);
            }
        }
        return this.recordIS;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.handshake.isInProgress()) {
            return null;
        }
        if (this.rawClient && !this.handshake.isPerformed()) {
            try {
                return this.getRawOutputStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (this.sslSocketV2 != null) {
            return this.sslSocketV2.getOutputStream();
        }
        if (this.record == null || this.record.getStatus() != 1) {
            throw new IOException("Streams of closed socket are not available");
        }
        Object object = this.lockRecordOS;
        synchronized (object) {
            if (this.recordOS == null) {
                this.recordOS = new RecordOutputStream(this);
            }
        }
        return this.recordOS;
    }

    public SSLParams getParams() {
        return this.params != null ? (SSLParams)this.params.clone() : null;
    }

    public int getPort() {
        return this.port;
    }

    public InputStream getRawInputStream() throws IOException {
        if (this.handshake.isInProgress() || this.handshake.isPerformed()) {
            throw new SSLException("getRawInputStream() cannot be invoked after the handshake has started");
        }
        return this.record.getIS();
    }

    public OutputStream getRawOutputStream() throws IOException {
        if (this.handshake.isInProgress() || this.handshake.isPerformed()) {
            throw new SSLException("getRawOutputStream() cannot be invoked after the handshake has started");
        }
        return this.record.getOS();
    }

    Record getRecord() {
        return this.record;
    }

    public SSLCertificate getServerCert() {
        if (this.handshakeInProgress()) {
            return null;
        }
        if (this.handshakePerformed()) {
            if (this.sslSocketV2 != null) {
                return this.sslSocketV2.getServerCert();
            }
            return this.record.getSessionState().isClient() ? this.record.getSessionState().getPeerCert() : this.record.getSessionState().getCert();
        }
        if (this.handshake != null && this.handshake.getHandshakeParams() != null) {
            return this.handshake.getHandshakeParams().getSSLParams().getServerCert();
        }
        return null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public SessionParams getSessionParams() {
        if (this.handshakeInProgress() || !this.handshakePerformed()) {
            return null;
        }
        if (this.sslSocketV2 != null) {
            return this.sslSocketV2.getSessionParams();
        }
        if (this.sessionParams != null) {
            return (SessionParams)this.sessionParams.clone();
        }
        return null;
    }

    public boolean handshakeInProgress() {
        return this.handshake.isInProgress();
    }

    public boolean handshakePerformed() {
        return this.handshake.isPerformed();
    }

    void initialize() throws IOException {
        this.record.setIS(super.getInputStream());
        this.record.setOS(super.getOutputStream());
    }

    void internalClose() throws IOException {
        this.eraseRecordSecrets();
        if (this.recordIS != null) {
            this.recordIS.socketClose();
        }
        if (this.recordOS != null) {
            this.recordOS.socketClose();
        }
        super.close();
    }

    public void performAcceptHandshake() throws IOException {
        if (this.handshakePerformed()) {
            throw new IllegalStateException("performAcceptHandshake() may only be invoked on uninitialized sockets");
        }
        try {
            this.handshake.startHandshake();
            if (this.sslSocketV2 == null) {
                this.sessionParams = this.record.getSessionParams();
            }
            this.handshake.erase();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public void performClientHandshake() throws IOException {
        if (this.handshakePerformed() || this.handshakeInProgress()) {
            throw new IllegalStateException("performAcceptHandshake() may only be invoked on uninitialized sockets");
        }
        try {
            this.handshake.startHandshake();
            if (this.sslSocketV2 == null) {
                this.sessionParams = this.record.getSessionParams();
            }
            this.handshake.erase();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    protected void performV2ClientHandshake(ClientHelloV2 clientHelloV2, ServerHelloV2 serverHelloV2, SessionParams sessionParams) throws IOException {
        throw new IllegalStateException("This method may not be called on the SSLSocket class.");
    }

    protected void performV2ServerHandshake(ClientHelloV2 clientHelloV2) throws IOException {
        throw new IllegalStateException("This method may not be called on the SSLSocket class.");
    }

    public void renegotiate() throws IOException {
        if (this.sslSocketV2 != null) {
            this.sslSocketV2.renegotiate();
            return;
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Renegotiation beginning");
        }
        this.record.getSessionState().setSessionParams(this.record.getSessionState().getSessionParams(this.record.getProtocolVersionOut()));
        this.handshake = new Handshake(this.record, this.params, this.serverName, this.port, this.record.getSessionState().isClient(), this.sslCrypto, this);
        this.handshake.startRenegotiation(false, this.recordIS);
        this.sessionParams = this.record.getSessionParams();
        this.handshake.erase();
    }

    public void renegotiate(SSLParams sSLParams) throws IOException {
        if (this.sslSocketV2 != null) {
            this.sslSocketV2.renegotiate(sSLParams);
            return;
        }
        this.params = sSLParams;
        this.record.getSessionState().setSessionID(null);
        this.record.getSessionState().setDebug(sSLParams.getDebug());
        this.record.getSessionState().setDebugOutputStream(sSLParams.getDebugOutputStream());
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Renegotiation beginning");
        }
        this.handshake = new Handshake(this.record, sSLParams, this.serverName, this.port, this.record.getSessionState().isClient(), this.sslCrypto, this);
        this.handshake.startRenegotiation(false, this.recordIS);
        this.sessionParams = this.record.getSessionParams();
        this.handshake.erase();
    }

    void renegotiateServer(Message message) throws IOException {
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Renegotiation beginning");
        }
        this.record.getSessionState().setSessionID(null);
        this.handshake = new Handshake(this.record, this.params, this.serverName, this.port, this.record.getSessionState().isClient(), this.sslCrypto, this);
        this.handshake.setClientHello(message);
        this.handshake.startRenegotiation(true, this.recordIS);
        this.sessionParams = this.record.getSessionParams();
        this.handshake.erase();
    }

    protected void sendCloseNotify() throws IOException {
        if (this.recordOS == null || this.record == null) {
            return;
        }
        if (!this.record.isCloseSent()) {
            this.record.setCloseSent(true);
            this.record.send(new Alert(Alert.Level.WARNING, Alert.Error.CLOSE_NOTIFY));
            if (this.record.getSessionState().getDebug()) {
                this.record.getSessionState().debugln("Close notify sent");
            }
        }
    }

    protected void serverSwap(ClientHelloV2 clientHelloV2) throws IOException {
        SSLSocket sSLSocket = null;
        if (!ssl2Supported) {
            throw new IOException("Unable to accept SSL2 connectionswithout the SSLava SSL2 plugin");
        }
        try {
            sSLSocket = (SSLSocket)Class.forName("com.phaos.SSL.SSL2.SSLSocketV2").newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Unable to load SSL2 libraries: " + exception.getMessage());
        }
        if (this.record.getSessionState().getDebug()) {
            this.record.getSessionState().debugln("Constructing the SSL2 socket.");
        }
        sSLSocket.constructV2Socket(this.record.getBufferedInputStream(), this.record.getOS(), this.params, this.sslCrypto, false, this.serverName, this.getPort());
        this.sslSocketV2 = sSLSocket;
        try {
            this.sslSocketV2.performV2ServerHandshake(clientHelloV2);
        }
        catch (IOException iOException) {
            this.sslSocketV2.abort();
            throw iOException;
        }
    }

    void setClientMode(boolean bl) {
        if (this.handshakePerformed() || this.handshakeInProgress()) {
            throw new IllegalStateException("setClientMode may only be invoked on uninitialized sockets");
        }
        this.handshake.getHandshakeParams().setClient(bl);
        this.record.getSessionState().setClient(bl);
    }

    void setCloseNotifyReceived() {
        closeNotifyReceived = true;
    }

    public void setParams(SSLParams sSLParams) {
        if (this.handshakePerformed() || this.handshakeInProgress()) {
            throw new IllegalStateException("setParams may only be invoked on uninitialized sockets");
        }
        this.params = sSLParams;
        try {
            this.record.setProtocolVersionOut(sSLParams.getProtocolVersion());
            this.record.getSessionState().setDebug(sSLParams.getDebug());
            this.record.getSessionState().setDebugOutputStream(sSLParams.getDebugOutputStream());
            this.handshake.getHandshakeParams().setParams(sSLParams);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
    }

    protected void superClose() throws IOException {
        super.close();
    }

    protected static boolean supportsSSL2() {
        if (checkedForSSL2Plugin) {
            return ssl2Supported;
        }
        return SSLSocket.checkForSSL2Plugin();
    }
}

