/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.SSLParams;
import com.phaos.SSL.SSLSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class SSLSocketExtension
extends SSLSocket {
    private Socket socket;
    private boolean autoClose = true;

    public SSLSocketExtension(Socket socket, SSLParams sSLParams, boolean bl) throws IOException {
        super(sSLParams, socket.getInputStream(), socket.getOutputStream(), socket.getInetAddress().getHostAddress(), socket.getPort());
        this.socket = socket;
        this.autoClose = bl;
        super.setClientMode(true);
    }

    public void close() throws IOException {
        super.close();
        if (this.autoClose) {
            this.socket.close();
        }
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public boolean getUseClientMode() {
        return super.getClientMode();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.socket.setReceiveBufferSize(n);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.socket.setSendBufferSize(n);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.socket.setSoLinger(bl, n);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public void setUseClientMode(boolean bl) throws IOException {
        super.setClientMode(bl);
    }
}

