/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.SSLException;
import com.phaos.SSL.SSLParams;
import com.phaos.SSL.SSLSocket;
import com.phaos.SSL.SSLUtils;
import com.phaos.utils.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SSLTunneledSocket
extends SSLSocket {
    private int httpProxyVersionMinor = 1;
    private String host;
    private int port;
    private String proxyHost;
    private int proxyPort;
    private String headerLines;
    private boolean connected = false;
    private String respStatusLine;
    private String responseVersion;
    private int responseCode = -1;
    private String responseMsg;
    private Properties headersTable;
    private Vector headerFieldKeys;

    public SSLTunneledSocket(String string, int n, String string2, int n2) throws UnknownHostException, IOException {
        this(string, n, string2, n2, "", new SSLParams());
    }

    public SSLTunneledSocket(String string, int n, String string2, int n2, SSLParams sSLParams) throws UnknownHostException, IOException {
        this(string, n, string2, n2, "", sSLParams);
    }

    public SSLTunneledSocket(String string, int n, String string2, int n2, SSLParams sSLParams, boolean bl) throws UnknownHostException, IOException {
        this(string, n, string2, n2, "", sSLParams, bl);
    }

    public SSLTunneledSocket(String string, int n, String string2, int n2, String string3) throws UnknownHostException, IOException {
        this(string, n, string2, n2, string3, new SSLParams());
    }

    public SSLTunneledSocket(String string, int n, String string2, int n2, String string3, SSLParams sSLParams) throws UnknownHostException, IOException {
        this(string, n, string2, n2, string3, sSLParams, true);
    }

    public SSLTunneledSocket(String string, int n, String string2, int n2, String string3, SSLParams sSLParams, boolean bl) throws UnknownHostException, IOException {
        super(string2, n2, sSLParams, false);
        this.host = string;
        this.port = n;
        this.proxyHost = string2;
        this.proxyPort = n2;
        this.headerLines = string3;
        if (bl) {
            this.connectToProxy(string3);
            this.performClientHandshake();
        }
    }

    public void connectToProxy() throws IOException, ProtocolException {
        this.connectToProxy(this.headerLines);
    }

    public void connectToProxy(String string) throws IOException, ProtocolException {
        if (!this.connected) {
            PrintStream printStream = new PrintStream(this.getRawOutputStream(), true);
            printStream.print("CONNECT " + this.host + ":" + this.port + " HTTP/1." + this.httpProxyVersionMinor + "\r\n" + string + "\r\n");
            printStream.flush();
            InputStream inputStream = this.getRawInputStream();
            this.readProxyResponse(inputStream);
            if (this.responseCode < 200 || this.responseCode > 299) {
                throw new ProtocolException("Proxy error '" + this.responseCode + " " + this.responseMsg + "'");
            }
        }
        this.connected = true;
    }

    public int getHttpProxyVersionMinor() {
        return this.httpProxyVersionMinor;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getProxyHeaderField(int n) {
        if (this.respStatusLine == null) {
            return null;
        }
        if (n == 0) {
            return this.respStatusLine;
        }
        if (this.headersTable != null && n > 0 && n < this.headerFieldKeys.size()) {
            return this.headersTable.getProperty((String)this.headerFieldKeys.elementAt(n - 1));
        }
        return null;
    }

    public String getProxyHeaderField(String string) {
        return this.headersTable != null ? this.headersTable.getProperty(HttpUtils.toTitleCase((String)string)) : null;
    }

    public String getProxyHeaderFieldKey(int n) {
        if (this.headerFieldKeys != null && n > 0 && n <= this.headerFieldKeys.size()) {
            return (String)this.headerFieldKeys.elementAt(n - 1);
        }
        return null;
    }

    public int getProxyResponseCode() {
        return this.responseCode;
    }

    public String getProxyResponseMessage() {
        return this.responseMsg;
    }

    public String getProxyResponseVersion() {
        return this.responseVersion;
    }

    public String getServerName() {
        return this.host;
    }

    private void readProxyResponse(InputStream inputStream) throws IOException {
        this.headersTable = new Properties();
        this.headerFieldKeys = new Vector();
        this.respStatusLine = HttpUtils.readCanonicalLine((InputStream)inputStream);
        if (this.respStatusLine == null) {
            throw new SSLException("Response from proxy missing");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.respStatusLine);
        if (stringTokenizer.hasMoreTokens()) {
            this.responseVersion = stringTokenizer.nextToken();
            if (!this.responseVersion.startsWith("HTTP/1.")) {
                throw new SSLException("Invalid response from proxy '" + this.respStatusLine + "'");
            }
        } else {
            throw new SSLException("Invalid response from proxy '" + this.respStatusLine + "'");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new SSLException("Invalid response from proxy '" + this.respStatusLine + "'");
        }
        String string = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.responseMsg = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                this.responseMsg = String.valueOf(this.responseMsg) + " " + stringTokenizer.nextToken();
            }
        }
        try {
            this.responseCode = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SSLException("Invalid response from proxy '" + this.respStatusLine + "'");
        }
        SSLUtils.parseHeaderStream(inputStream, this.headersTable, this.headerFieldKeys);
        this.headerFieldKeys.addElement(null);
    }

    public void setHttpProxyVersionMinor(int n) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported HTTP 1.x minor version, must be 0 or 1");
        }
        this.httpProxyVersionMinor = n;
    }
}

