/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Random;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SecretsV3;
import com.phaos.SSL.SecretsV31;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.SymmetricKey;
import java.io.IOException;

public abstract class Secrets {
    private static Class secretsClassV3;
    protected SSLCrypto sslCrypto;
    protected SessionState sessionState;

    protected Secrets() {
    }

    protected Secrets(SSLCrypto sSLCrypto, SessionState sessionState) {
        this.sslCrypto = sSLCrypto;
        this.sessionState = sessionState;
    }

    protected abstract SymmetricKey computeMasterSecret(Random var1, Random var2) throws IOException;

    protected abstract void computeSecrets(SymmetricKey var1, CipherSpec var2, boolean var3, Random var4, Random var5) throws IOException;

    protected abstract void erase();

    protected abstract byte[] getClientIV();

    protected abstract SymmetricKey getClientKey();

    protected abstract SymmetricKey getClientMACsecret();

    static Secrets getSecret(ProtocolVersion protocolVersion, SSLCrypto sSLCrypto, SessionState sessionState) throws IOException {
        if (protocolVersion.equals(ProtocolVersion.TLS1)) {
            return new SecretsV31(sSLCrypto, sessionState);
        }
        if (secretsClassV3 == null) {
            return new SecretsV3(sSLCrypto, sessionState);
        }
        try {
            Secrets secrets = (Secrets)secretsClassV3.newInstance();
            secrets.setSSLCrypto(sSLCrypto);
            secrets.setSessionState(sessionState);
            return secrets;
        }
        catch (IllegalAccessException illegalAccessException) {
            AlertException alertException = new AlertException("Unable to instantiate " + secretsClassV3.getName() + ":" + illegalAccessException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (InstantiationException instantiationException) {
            AlertException alertException = new AlertException("Unable to instantiate " + secretsClassV3.getName() + ":" + instantiationException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        catch (ClassCastException classCastException) {
            AlertException alertException = new AlertException("Class does not implement CkiSecretsV3.", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    protected abstract byte[] getServerIV();

    protected abstract SymmetricKey getServerKey();

    protected abstract SymmetricKey getServerMACsecret();

    protected abstract boolean isClient();

    protected static void setClass(Class clazz) {
        secretsClassV3 = clazz;
    }

    protected abstract void setPreMasterSecret(SymmetricKey var1) throws IOException;

    protected void setSSLCrypto(SSLCrypto sSLCrypto) {
        this.sslCrypto = sSLCrypto;
    }

    protected void setSessionState(SessionState sessionState) {
        this.sessionState = sessionState;
    }
}

