/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.Random;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.Secrets;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;

public class SecretsV3
extends Secrets {
    protected byte[] preMasterSecret;
    protected byte[] masterSecret;
    protected byte[] clientMACsecret;
    protected byte[] serverMACsecret;
    protected byte[] clientKey;
    protected byte[] serverKey;
    protected byte[] clientIV;
    protected byte[] serverIV;
    protected boolean client;
    private MessageDigest md5;
    private MessageDigest sha;

    protected SecretsV3() {
    }

    public SecretsV3(SSLCrypto sSLCrypto, SessionState sessionState) throws IOException {
        super(sSLCrypto, sessionState);
    }

    protected SymmetricKey computeMasterSecret(Random random, Random random2) throws IOException {
        this.masterSecret = new byte[48];
        byte[] byArray = Utils.toBytes((Streamable)random);
        byte[] byArray2 = Utils.toBytes((Streamable)random2);
        try {
            this.md5 = this.sslCrypto.getMessageDigestInstance(AlgID.md5);
            this.sha = this.sslCrypto.getMessageDigestInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        int n = 0;
        while (n < 3) {
            this.md5.init();
            this.sha.init();
            int n2 = 0;
            while (n2 < n + 1) {
                this.sha.update((byte)(65 + n));
                ++n2;
            }
            this.sha.update(this.preMasterSecret);
            this.sha.update(byArray);
            this.sha.update(byArray2);
            this.sha.computeCurrent();
            this.md5.update(this.preMasterSecret);
            this.md5.update(this.sha.digestBits);
            this.md5.computeCurrent();
            System.arraycopy(this.md5.digestBits, 0, this.masterSecret, n * 16, 16);
            ++n;
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("Premaster secret = " + Utils.toHexString((byte[])this.preMasterSecret));
            this.sessionState.debugln("Master secret = " + Utils.toHexString((byte[])this.masterSecret));
        }
        Utils.setArray((byte[])this.preMasterSecret, (byte)0);
        return new SymmetricKey(this.masterSecret);
    }

    protected void computeSecrets(SymmetricKey symmetricKey, CipherSpec cipherSpec, boolean bl, Random random, Random random2) throws IOException {
        if (this.md5 == null) {
            try {
                this.md5 = this.sslCrypto.getMessageDigestInstance(AlgID.md5);
                this.sha = this.sslCrypto.getMessageDigestInstance(AlgID.sha_1);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
                alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                throw alertException;
            }
        }
        this.client = bl;
        int n = cipherSpec.getWriteCipher().getMAClength();
        int n2 = cipherSpec.getKeyMaterial();
        int n3 = cipherSpec.getExpKeyMaterial();
        int n4 = cipherSpec.getWriteCipher().getIVSize();
        boolean bl2 = cipherSpec.getWriteCipher().getIsExportable();
        byte[] byArray = bl ? Utils.toBytes((Streamable)random) : Utils.toBytes((Streamable)random2);
        byte[] byArray2 = bl ? Utils.toBytes((Streamable)random2) : Utils.toBytes((Streamable)random);
        this.clientMACsecret = new byte[n];
        this.serverMACsecret = new byte[n];
        this.clientKey = new byte[n2];
        this.serverKey = new byte[n2];
        this.clientIV = new byte[n4];
        this.serverIV = new byte[n4];
        byte[] byArray3 = null;
        int n5 = (2 * (n + n2 + (bl2 ? 0 : n4)) - 1) / 16 + 1;
        byArray3 = new byte[n5 * 16];
        int n6 = 0;
        while (n6 < n5) {
            int n7;
            this.md5.init();
            this.sha.init();
            if (this.sessionState.getDebug()) {
                n7 = 0;
                while (n7 < n6 + 1) {
                    this.sha.update((byte)(65 + n6));
                    this.sessionState.debug(String.valueOf((char)(65 + n6)));
                    ++n7;
                }
                this.sessionState.debug("\n");
            } else {
                n7 = 0;
                while (n7 < n6 + 1) {
                    this.sha.update((byte)(65 + n6));
                    ++n7;
                }
            }
            this.sha.update(symmetricKey.getBytes());
            this.sha.update(byArray2);
            this.sha.update(byArray);
            this.sha.computeCurrent();
            this.md5.update(symmetricKey.getBytes());
            this.md5.update(this.sha.digestBits);
            this.md5.computeCurrent();
            System.arraycopy(this.md5.digestBits, 0, byArray3, n6 * 16, 16);
            ++n6;
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("key block = " + Utils.toHexString((byte[])byArray3));
        }
        System.arraycopy(byArray3, 0, this.clientMACsecret, 0, n);
        System.arraycopy(byArray3, n, this.serverMACsecret, 0, n);
        System.arraycopy(byArray3, 2 * n, this.clientKey, 0, n2);
        System.arraycopy(byArray3, 2 * n + n2, this.serverKey, 0, n2);
        if (!bl2) {
            System.arraycopy(byArray3, 2 * (n + n2), this.clientIV, 0, n4);
            System.arraycopy(byArray3, 2 * (n + n2) + n4, this.serverIV, 0, n4);
        } else {
            this.md5.init();
            this.md5.update(byArray);
            this.md5.update(byArray2);
            this.md5.computeCurrent();
            System.arraycopy(this.md5.digestBits, 0, this.clientIV, 0, n4);
            this.md5.init();
            this.md5.update(byArray2);
            this.md5.update(byArray);
            this.md5.computeCurrent();
            System.arraycopy(this.md5.digestBits, 0, this.serverIV, 0, n4);
        }
        if (bl2) {
            this.md5.init();
            this.md5.update(this.clientKey);
            this.md5.update(byArray);
            this.md5.update(byArray2);
            this.md5.computeCurrent();
            this.clientKey = new byte[n3];
            System.arraycopy(this.md5.digestBits, 0, this.clientKey, 0, n3);
            this.md5.init();
            this.md5.update(this.serverKey);
            this.md5.update(byArray2);
            this.md5.update(byArray);
            this.md5.computeCurrent();
            this.serverKey = new byte[n3];
            System.arraycopy(this.md5.digestBits, 0, this.serverKey, 0, n3);
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("Client Key: " + Utils.toHexString((byte[])this.clientKey));
            this.sessionState.debugln("Server Key: " + Utils.toHexString((byte[])this.serverKey));
            this.sessionState.debugln("Client Mac: " + Utils.toHexString((byte[])this.clientMACsecret));
            this.sessionState.debugln("Server Mac: " + Utils.toHexString((byte[])this.serverMACsecret));
            this.sessionState.debugln("Client IV = " + Utils.toHexString((byte[])this.clientIV));
            this.sessionState.debugln("Server IV = " + Utils.toHexString((byte[])this.serverIV));
        }
    }

    protected void erase() {
        Utils.setArray((byte[])this.preMasterSecret, (byte)0);
        this.masterSecret = null;
        this.clientMACsecret = null;
        this.serverMACsecret = null;
        this.clientKey = null;
        this.serverKey = null;
        this.clientIV = null;
        this.serverIV = null;
        this.sessionState = null;
    }

    protected byte[] getClientIV() {
        return this.clientIV;
    }

    protected SymmetricKey getClientKey() {
        return new SymmetricKey(this.clientKey);
    }

    protected SymmetricKey getClientMACsecret() {
        return new SymmetricKey(this.clientMACsecret);
    }

    protected byte[] getServerIV() {
        return this.serverIV;
    }

    protected SymmetricKey getServerKey() {
        return new SymmetricKey(this.serverKey);
    }

    protected SymmetricKey getServerMACsecret() {
        return new SymmetricKey(this.serverMACsecret);
    }

    protected boolean isClient() {
        return this.client;
    }

    protected void setPreMasterSecret(SymmetricKey symmetricKey) throws IOException {
        this.preMasterSecret = (byte[])symmetricKey.getBytes().clone();
    }
}

