/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.MACHashV31;
import com.phaos.SSL.Random;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SecretsV3;
import com.phaos.SSL.SessionState;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;

public class SecretsV31
extends SecretsV3 {
    protected static final byte[] MASTER_SECRET = "master secret".getBytes();
    protected static final byte[] KEY_EXPANSION = "key expansion".getBytes();
    protected static final byte[] CLIENT_WRITE_KEY = "client write key".getBytes();
    protected static final byte[] SERVER_WRITE_KEY = "server write key".getBytes();
    protected static final byte[] IV_KEY = "".getBytes();
    protected static final byte[] IV_BLOCK = "IV block".getBytes();

    protected SecretsV31() {
    }

    public SecretsV31(SSLCrypto sSLCrypto, SessionState sessionState) throws IOException {
        super(sSLCrypto, sessionState);
    }

    protected SymmetricKey computeMasterSecret(Random random, Random random2) throws IOException {
        this.masterSecret = new byte[48];
        try {
            byte[] byArray = Utils.toBytes((Streamable)random);
            byte[] byArray2 = Utils.toBytes((Streamable)random2);
            byte[] byArray3 = new byte[64];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            this.masterSecret = MACHashV31.PRF(new SymmetricKey(this.preMasterSecret), MASTER_SECRET, byArray3, this.masterSecret.length, this.sslCrypto);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException("Message digest MD5 / SHA1 class not found", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("Premaster secret = " + Utils.toHexString((byte[])this.preMasterSecret));
            this.sessionState.debugln("Master secret = " + Utils.toHexString((byte[])this.masterSecret));
        }
        Utils.setArray((byte[])this.preMasterSecret, (byte)0);
        return new SymmetricKey(this.masterSecret);
    }

    protected void computeSecrets(SymmetricKey symmetricKey, CipherSpec cipherSpec, boolean bl, Random random, Random random2) throws IOException {
        byte[] byArray;
        int n;
        this.client = bl;
        int n2 = cipherSpec.getWriteCipher().getMAClength();
        int n3 = cipherSpec.getKeyMaterial();
        int n4 = cipherSpec.getExpKeyMaterial();
        int n5 = cipherSpec.getWriteCipher().getIVSize();
        boolean bl2 = cipherSpec.getWriteCipher().getIsExportable();
        byte[] byArray2 = bl ? Utils.toBytes((Streamable)random) : Utils.toBytes((Streamable)random2);
        byte[] byArray3 = bl ? Utils.toBytes((Streamable)random2) : Utils.toBytes((Streamable)random);
        this.clientMACsecret = new byte[n2];
        this.serverMACsecret = new byte[n2];
        this.clientKey = new byte[n3];
        this.serverKey = new byte[n3];
        this.clientIV = new byte[n5];
        this.serverIV = new byte[n5];
        byte[] byArray4 = null;
        try {
            n = 2 * (n2 + n3 + (bl2 ? 0 : n5));
            byArray = new byte[64];
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            System.arraycopy(byArray2, 0, byArray, byArray3.length, byArray2.length);
            byArray4 = MACHashV31.PRF(symmetricKey, KEY_EXPANSION, byArray, n, this.sslCrypto);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("Message digest MD5 / SHA1 class not found");
        }
        if (this.sessionState.getDebug()) {
            this.sessionState.debugln("key block = " + Utils.toHexString((byte[])byArray4));
        }
        System.arraycopy(byArray4, 0, this.clientMACsecret, 0, n2);
        System.arraycopy(byArray4, n2, this.serverMACsecret, 0, n2);
        System.arraycopy(byArray4, 2 * n2, this.clientKey, 0, n3);
        System.arraycopy(byArray4, 2 * n2 + n3, this.serverKey, 0, n3);
        if (!bl2) {
            System.arraycopy(byArray4, 2 * (n2 + n3), this.clientIV, 0, n5);
            System.arraycopy(byArray4, 2 * (n2 + n3) + n5, this.serverIV, 0, n5);
        } else {
            try {
                n = n4;
                byArray = new byte[64];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
                this.clientKey = MACHashV31.PRF(new SymmetricKey(this.clientKey), CLIENT_WRITE_KEY, byArray, n, this.sslCrypto);
                this.serverKey = MACHashV31.PRF(new SymmetricKey(this.serverKey), SERVER_WRITE_KEY, byArray, n, this.sslCrypto);
                byte[] byArray5 = MACHashV31.PRF(new SymmetricKey(IV_KEY), IV_BLOCK, byArray, 2 * n5, this.sslCrypto);
                System.arraycopy(byArray5, 0, this.clientIV, 0, n5);
                System.arraycopy(byArray5, n5, this.serverIV, 0, n5);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                AlertException alertException = new AlertException("Message digest MD5 / SHA1 class not found", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
                alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                throw alertException;
            }
        }
    }
}

