/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Compression;
import com.phaos.SSL.HandshakeBody;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.Random;
import com.phaos.SSL.SessionID;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ServerHello
extends HandshakeBody {
    private static final int handshakeType = 2;
    protected ProtocolVersion version;
    private Random random;
    private SessionID sessionID;
    private short cipherSuite;
    private Compression compressionMethod;

    protected ServerHello() {
    }

    public ServerHello(ProtocolVersion protocolVersion, short s, SessionID sessionID, RandomBitsSource randomBitsSource) {
        this(protocolVersion, s, sessionID, randomBitsSource, Compression.NULL);
    }

    public ServerHello(ProtocolVersion protocolVersion, short s, SessionID sessionID, RandomBitsSource randomBitsSource, Compression compression) {
        this.version = protocolVersion;
        this.random = new Random(randomBitsSource);
        this.sessionID = sessionID;
        this.cipherSuite = s;
        this.compressionMethod = compression;
    }

    public ServerHello(RandomBitsSource randomBitsSource) {
        this(randomBitsSource, Compression.NULL);
    }

    public ServerHello(RandomBitsSource randomBitsSource, Compression compression) {
        this.random = new Random(randomBitsSource);
        this.compressionMethod = compression;
    }

    public ServerHello(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void erase() {
        if (this.random != null) {
            this.random.erase();
        }
        if (this.sessionID != null) {
            this.sessionID.erase();
        }
    }

    public short getCipherSuite() {
        return this.cipherSuite;
    }

    public Compression getCompressionMethod() {
        return this.compressionMethod;
    }

    public int getHandshakeType() {
        return 2;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void input(InputStream inputStream) throws IOException {
        this.version = new ProtocolVersion(inputStream);
        this.random = new Random(inputStream);
        this.sessionID = new SessionID(inputStream);
        this.cipherSuite = Utils.inputShort((InputStream)inputStream);
        this.compressionMethod = new Compression(inputStream);
    }

    public int length() {
        return this.version.length() + this.random.length() + this.sessionID.length() + 2 + 1;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.version.output(outputStream);
        this.random.output(outputStream);
        this.sessionID.output(outputStream);
        Utils.outputShort((int)this.cipherSuite, (OutputStream)outputStream);
        this.compressionMethod.output(outputStream);
    }

    public void setParams(ProtocolVersion protocolVersion, short s, SessionID sessionID) {
        this.version = protocolVersion;
        this.sessionID = sessionID;
        this.cipherSuite = s;
    }

    public String toString() {
        return "Version = " + this.version + ", sessionID = " + this.sessionID + ", cipherSuite = " + Integer.toString(this.cipherSuite, 16) + ", compressionMethod = " + this.compressionMethod.getValue() + ", random = " + this.random;
    }
}

