/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.ServerHello;
import com.phaos.cert.Certificate;
import com.phaos.cert.X509;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ServerHelloV2
extends ServerHello {
    private boolean sessionIDHit;
    private int certificateType;
    private byte[] certificateData = new byte[0];
    private int[] cipherKinds = new int[0];
    private byte[] connectionIDData = new byte[0];
    private Certificate certificate;

    public void erase() {
        Utils.setArray((byte[])this.certificateData, (byte)0);
        Utils.setArray((int[])this.cipherKinds, (int)0);
        Utils.setArray((byte[])this.connectionIDData, (byte)0);
        this.certificateData = new byte[0];
        this.cipherKinds = new int[0];
        this.connectionIDData = new byte[0];
        this.certificate = null;
        this.certificateType = 0;
    }

    public Certificate getCertificate() throws IOException {
        if (this.certificate == null) {
            if (this.certificateData != null && this.certificateType == 1) {
                this.certificate = new X509(this.certificateData);
                return this.certificate;
            }
            if (this.certificateData != null) {
                throw new IOException("No certificate data is available to be parsed into a certificate");
            }
            throw new IOException("Certificate types other that X509 are not currently supported: certificate type is: " + this.certificateType);
        }
        return this.certificate;
    }

    public byte[] getCertificateData() {
        return this.certificateData;
    }

    public int getCertificateType() {
        return this.certificateType;
    }

    public int[] getCipherKinds() {
        return this.cipherKinds;
    }

    public byte[] getConnectionIDData() {
        return this.connectionIDData;
    }

    public final byte getType() {
        return 4;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void input(InputStream inputStream) throws IOException {
        byte by = (byte)inputStream.read();
        if (by != this.getType()) {
            throw new IOException("Attempted to fill a ServerHelloMessageV2 object with a different type message: " + by);
        }
        int n = inputStream.read();
        this.sessionIDHit = n != 0;
        this.certificateType = inputStream.read();
        if (this.version == null) {
            this.version = new ProtocolVersion(inputStream);
        } else {
            this.version.input(inputStream);
        }
        short s = Utils.inputShort((InputStream)inputStream);
        short s2 = Utils.inputShort((InputStream)inputStream);
        short s3 = Utils.inputShort((InputStream)inputStream);
        this.certificate = null;
        this.certificateData = new byte[s];
        this.cipherKinds = new int[s2 / 3];
        this.connectionIDData = new byte[s3];
        inputStream.read(this.certificateData);
        int n2 = 0;
        while (n2 < this.cipherKinds.length) {
            this.cipherKinds[n2] = Utils.input24bit((InputStream)inputStream);
            ++n2;
        }
        inputStream.read(this.connectionIDData);
    }

    public boolean isSessionIDHit() {
        return this.sessionIDHit;
    }

    public int length() {
        return 11 + this.certificateData.length + this.cipherKinds.length * 3 + this.connectionIDData.length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        if (this.sessionIDHit) {
            outputStream.write(1);
        } else {
            outputStream.write(0);
        }
        outputStream.write(this.certificateType);
        this.version.output(outputStream);
        Utils.outputShort((int)this.certificateData.length, (OutputStream)outputStream);
        Utils.outputShort((int)(this.cipherKinds.length * 3), (OutputStream)outputStream);
        Utils.outputShort((int)this.connectionIDData.length, (OutputStream)outputStream);
        outputStream.write(this.certificateData);
        int n = 0;
        while (n < this.cipherKinds.length) {
            Utils.output24bit((int)this.cipherKinds[n], (OutputStream)outputStream);
            ++n;
        }
        outputStream.write(this.connectionIDData);
    }

    public void setCertificateData(byte[] byArray) {
        this.certificateData = byArray == null ? new byte[0] : byArray;
        this.certificate = null;
    }

    public void setCertificateType(int n) {
        this.certificateType = n;
    }

    public void setCipherKinds(int[] nArray) {
        this.cipherKinds = nArray == null ? new int[0] : nArray;
    }

    public void setConnectionIDData(byte[] byArray) {
        this.connectionIDData = byArray == null ? new byte[0] : byArray;
    }

    public void setSessionIDHit(boolean bl) {
        this.sessionIDHit = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(ServerHelloV2){");
        stringBuffer.append("SessionIDHit=" + this.sessionIDHit + ", ");
        stringBuffer.append("CertificateType=" + this.certificateType + ", ");
        stringBuffer.append("ServerVersion=" + this.version + ", ");
        if (this.certificate == null) {
            stringBuffer.append("CertificateData=" + Utils.toHexString((byte[])this.certificateData) + ", ");
        } else {
            stringBuffer.append("CertificateData={" + this.certificate + "}, ");
        }
        stringBuffer.append("CipherKinds={");
        int n = 0;
        while (n < this.cipherKinds.length) {
            stringBuffer.append(this.cipherKinds[n]);
            if (n + 1 != this.cipherKinds.length) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}, ");
        stringBuffer.append("ConnectionIDData=" + Utils.toHexString((byte[])this.connectionIDData) + "}");
        return stringBuffer.toString();
    }
}

