/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.Alert;
import com.phaos.SSL.AlertException;
import com.phaos.SSL.Biguint;
import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.HandshakeBody;
import com.phaos.SSL.Random;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SSLException;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.DiffieHellman;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.utils.Streamable;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

class ServerKeyExchange
extends HandshakeBody {
    private static final int handshakeType = 12;
    private SSLCrypto sslCrypto;
    private Biguint p;
    private Biguint g;
    private Biguint gx;
    private DiffieHellman dh;
    private RandomBitsSource rbs;
    private Biguint modulus;
    private Biguint exponent;
    private byte[] paramBytes;
    private byte[] sigBytes = null;
    private CipherSpec pendingCS;
    private Random clientRandom;
    private Random serverRandom;
    private SSLCertificate serverCert;

    public ServerKeyExchange(CipherSpec cipherSpec, Random random, Random random2, SSLCertificate sSLCertificate, SSLCrypto sSLCrypto, InputStream inputStream) throws IOException {
        this.pendingCS = cipherSpec;
        this.clientRandom = random;
        this.serverRandom = random2;
        this.serverCert = sSLCertificate;
        this.sslCrypto = sSLCrypto;
        this.input(inputStream);
    }

    public ServerKeyExchange(RSAPublicKey rSAPublicKey, CipherSpec cipherSpec, SSLCertificate sSLCertificate, Random random, Random random2, SSLCrypto sSLCrypto) throws IOException {
        this.sslCrypto = sSLCrypto;
        this.modulus = new Biguint(rSAPublicKey.getModulus());
        this.exponent = new Biguint(rSAPublicKey.getExponent());
        this.pendingCS = cipherSpec;
        this.serverCert = sSLCertificate;
        this.clientRandom = random2;
        this.serverRandom = random;
        this.computeParamBytes();
        this.computeSigBytes();
    }

    public ServerKeyExchange(RandomBitsSource randomBitsSource, BigInteger bigInteger, BigInteger bigInteger2, CipherSpec cipherSpec, SSLCertificate sSLCertificate, Random random, Random random2, SSLCrypto sSLCrypto) throws IOException {
        this.rbs = randomBitsSource;
        this.sslCrypto = sSLCrypto;
        this.p = new Biguint(bigInteger);
        this.g = new Biguint(bigInteger2);
        try {
            this.dh = sSLCrypto.getDiffieHellmanInstance(this.p.getValue(), this.g.getValue(), randomBitsSource);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            AlertException alertException = new AlertException(algorithmIdentifierException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
        this.gx = new Biguint(this.dh.myValue());
        this.pendingCS = cipherSpec;
        this.serverCert = sSLCertificate;
        this.clientRandom = random2;
        this.serverRandom = random;
        this.computeParamBytes();
        this.computeSigBytes();
    }

    private void computeParamBytes() throws IOException {
        try {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            if (this.pendingCS.getKeyExchange() == 2) {
                this.p.output((OutputStream)unsyncByteArrayOutputStream);
                this.g.output((OutputStream)unsyncByteArrayOutputStream);
                this.gx.output((OutputStream)unsyncByteArrayOutputStream);
            } else {
                this.modulus.output((OutputStream)unsyncByteArrayOutputStream);
                this.exponent.output((OutputStream)unsyncByteArrayOutputStream);
            }
            this.paramBytes = unsyncByteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            AlertException alertException = new AlertException(iOException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR), 2);
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    private void computeSigBytes() throws SSLException {
        try {
            if (this.pendingCS.getServerCertType() == 1) {
                Signature signature = this.sslCrypto.getSignatureInstance(this.serverCert.getPrivateKey());
                MessageDigest messageDigest = this.sslCrypto.getMessageDigestInstance(AlgID.md5);
                messageDigest.init();
                messageDigest.update(Utils.toBytes((Streamable)this.clientRandom));
                messageDigest.update(Utils.toBytes((Streamable)this.serverRandom));
                messageDigest.update(this.paramBytes);
                messageDigest.computeCurrent();
                MessageDigest messageDigest2 = this.sslCrypto.getMessageDigestInstance(AlgID.sha_1);
                messageDigest2.init();
                messageDigest2.update(Utils.toBytes((Streamable)this.clientRandom));
                messageDigest2.update(Utils.toBytes((Streamable)this.serverRandom));
                messageDigest2.update(this.paramBytes);
                messageDigest2.computeCurrent();
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                unsyncByteArrayOutputStream.write(messageDigest.digestBits);
                unsyncByteArrayOutputStream.write(messageDigest2.digestBits);
                signature.setHash(unsyncByteArrayOutputStream.toByteArray());
                this.sigBytes = signature.sign();
            } else if (this.pendingCS.getServerCertType() == 3) {
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                this.clientRandom.output((OutputStream)unsyncByteArrayOutputStream);
                this.serverRandom.output((OutputStream)unsyncByteArrayOutputStream);
                unsyncByteArrayOutputStream.write(this.paramBytes);
                Signature signature = this.sslCrypto.getSignatureInstance(this.serverCert.getPrivateKey());
                signature.setAlgID(AlgID.dsaWithSHA1);
                signature.setRandomBitsSource(this.rbs);
                signature.setDocument(unsyncByteArrayOutputStream.toByteArray());
                this.sigBytes = signature.sign();
            }
        }
        catch (Exception exception) {
            AlertException alertException = new AlertException(exception.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.INTERNAL_ERROR));
            alertException.addAlert("SSL3", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
            throw alertException;
        }
    }

    public void erase() {
        this.gx = null;
        this.g = null;
        this.p = null;
        this.dh = null;
        this.exponent = null;
        this.modulus = null;
        Utils.setArray((byte[])this.paramBytes, (byte)0);
        if (this.clientRandom != null) {
            this.clientRandom.erase();
        }
        if (this.serverRandom != null) {
            this.serverRandom.erase();
        }
    }

    public DiffieHellman getDH() {
        return this.dh;
    }

    public BigInteger getG() {
        return this.g.getValue();
    }

    public BigInteger getGx() {
        return this.gx.getValue();
    }

    public int getHandshakeType() {
        return 12;
    }

    public BigInteger getP() {
        return this.p.getValue();
    }

    public RSAPublicKey getPublicKey() {
        return new RSAPublicKey(this.modulus.getValue(), this.exponent.getValue());
    }

    public void input(InputStream inputStream) throws IOException {
        if (this.pendingCS.getKeyExchange() == 2) {
            this.p = new Biguint(inputStream);
            this.g = new Biguint(inputStream);
            this.gx = new Biguint(inputStream);
        } else {
            this.modulus = new Biguint(inputStream);
            this.exponent = new Biguint(inputStream);
        }
        this.computeParamBytes();
        if (this.pendingCS.getServerCertType() != 0) {
            this.sigBytes = new byte[Utils.inputShort((InputStream)inputStream)];
            Utils.inputByteArray((byte[])this.sigBytes, (InputStream)inputStream);
            this.verifySignature();
        } else {
            this.sigBytes = null;
        }
    }

    public int length() {
        int n = 0;
        if (this.sigBytes != null && this.sigBytes.length != 0) {
            n = 2 + this.sigBytes.length;
        }
        return this.paramBytes.length + n;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.paramBytes);
        if (this.sigBytes != null) {
            Utils.outputShort((int)((short)this.sigBytes.length), (OutputStream)outputStream);
            outputStream.write(this.sigBytes);
        }
    }

    public String toString() {
        if (this.pendingCS.getKeyExchange() == 2) {
            return "p = " + this.p + ", g = " + this.g + ", gx = " + this.gx + ", dh = " + this.dh;
        }
        return "modulus = " + this.modulus + ", exponent = " + this.exponent;
    }

    private void verifySignature() throws IOException {
        block7: {
            try {
                Object object;
                PublicKey publicKey = this.serverCert.getPublicKey();
                if (this.pendingCS.getServerCertType() == 3) {
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    this.clientRandom.output((OutputStream)unsyncByteArrayOutputStream);
                    this.serverRandom.output((OutputStream)unsyncByteArrayOutputStream);
                    unsyncByteArrayOutputStream.write(this.paramBytes);
                    if (!this.serverCert.getBottomCert().verifySignature(unsyncByteArrayOutputStream.toByteArray(), this.sigBytes, new AlgorithmIdentifier(this.serverCert.getBottomCert().getSigAlgOID()))) {
                        AlertException alertException = new AlertException("Invalid signature", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
                        alertException.addAlert("SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                        throw alertException;
                    }
                    break block7;
                }
                if (this.pendingCS.getServerCertType() != 1) break block7;
                Signature signature = this.sslCrypto.getSignatureInstance(publicKey);
                try {
                    object = this.sslCrypto.getMessageDigestInstance(AlgID.md5);
                    object.init();
                    object.update(Utils.toBytes((Streamable)this.clientRandom));
                    object.update(Utils.toBytes((Streamable)this.serverRandom));
                    object.update(this.paramBytes);
                    object.computeCurrent();
                    MessageDigest messageDigest = this.sslCrypto.getMessageDigestInstance(AlgID.sha_1);
                    messageDigest.init();
                    messageDigest.update(Utils.toBytes((Streamable)this.clientRandom));
                    messageDigest.update(Utils.toBytes((Streamable)this.serverRandom));
                    messageDigest.update(this.paramBytes);
                    messageDigest.computeCurrent();
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    unsyncByteArrayOutputStream.write(((MessageDigest)object).digestBits);
                    unsyncByteArrayOutputStream.write(messageDigest.digestBits);
                    signature.setHash(unsyncByteArrayOutputStream.toByteArray());
                }
                catch (AlgorithmIdentifierException algorithmIdentifierException) {
                    throw new RuntimeException(algorithmIdentifierException.toString());
                }
                signature.setSigBytes(this.sigBytes);
                if (!signature.verify()) {
                    object = new AlertException("Invalid signature", "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
                    ((AlertException)object).addAlert("SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                    throw object;
                }
            }
            catch (AuthenticationException authenticationException) {
                AlertException alertException = new AlertException(authenticationException.toString(), "TLS1", new Alert(Alert.Level.FATAL, Alert.Error.DECRYPT_ERROR));
                alertException.addAlert("SSL_TLS", new Alert(Alert.Level.FATAL, Alert.Error.HANDSHAKE_FAILURE));
                throw alertException;
            }
        }
    }
}

