/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.SSLException;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Streamable;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SessionID
implements Streamable {
    private static final int MAX_LENGTH = 32;
    private static final int LENGTH_SIZE = 1;
    private byte[] id;

    public SessionID() {
        this.id = new byte[0];
    }

    public SessionID(RandomBitsSource randomBitsSource) {
        this.id = new byte[32];
        System.arraycopy(Utils.wordToBytes((int)((int)(System.currentTimeMillis() / 1000L))), 0, this.id, 0, 4);
        byte[] byArray = new byte[28];
        randomBitsSource.randomBytes(byArray);
        System.arraycopy(byArray, 0, this.id, 4, 28);
    }

    public SessionID(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public SessionID(byte[] byArray) {
        if (byArray.length > 32) {
            throw new IllegalStateException("SessionID too long: " + byArray.length);
        }
        this.id = byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SessionID)) {
            return false;
        }
        return Utils.areEqual((byte[])this.id, (byte[])((SessionID)object).getID());
    }

    public void erase() {
        Utils.setArray((byte[])this.id, (byte)0);
    }

    public byte[] getID() {
        byte[] byArray = (byte[])this.id.clone();
        return byArray;
    }

    public void input(InputStream inputStream) throws IOException {
        int n = Utils.inputByte((InputStream)inputStream) & 0xFF;
        if (n > 32) {
            throw new SSLException("Session ID too long: " + n);
        }
        this.id = new byte[n];
        Utils.inputByteArray((byte[])this.id, (InputStream)inputStream);
    }

    public boolean isEmpty() {
        return this.id.length == 0;
    }

    public int length() {
        return this.id.length + 1;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.id.length);
        outputStream.write(this.id);
    }

    public String toString() {
        return "Length = " + this.id.length + " " + Utils.toHexString((byte[])this.id);
    }
}

