/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SessionID;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.io.Serializable;
import java.util.Date;

public class SessionParams
implements Serializable,
Cloneable {
    public final SessionID sessionID;
    public final ProtocolVersion protocolVersion;
    public final SSLCertificate peerCertificate;
    private SSLCertificate cert;
    public final short cipherSuite;
    private int cipherKindV2;
    private byte[] initializationDataV2;
    public final SymmetricKey masterSecret;
    private long timeExp;
    private String serverNameAndPort;

    public SessionParams(SessionID sessionID, ProtocolVersion protocolVersion, SSLCertificate sSLCertificate, SSLCertificate sSLCertificate2, int n, byte[] byArray, SymmetricKey symmetricKey) {
        this.sessionID = sessionID != null ? new SessionID(sessionID.getID()) : new SessionID();
        this.protocolVersion = new ProtocolVersion(protocolVersion.getMajor(), protocolVersion.getMinor());
        this.cert = sSLCertificate;
        this.peerCertificate = sSLCertificate2 != null ? (SSLCertificate)sSLCertificate2.clone() : null;
        this.cipherSuite = 0;
        this.masterSecret = symmetricKey != null ? (SymmetricKey)symmetricKey.clone() : new SymmetricKey(new byte[0]);
        this.cipherKindV2 = n;
        this.initializationDataV2 = byArray != null ? (byte[])byArray.clone() : null;
    }

    public SessionParams(SessionID sessionID, ProtocolVersion protocolVersion, SSLCertificate sSLCertificate, SSLCertificate sSLCertificate2, short s, SymmetricKey symmetricKey) {
        this.sessionID = sessionID != null ? new SessionID(sessionID.getID()) : new SessionID();
        this.protocolVersion = new ProtocolVersion(protocolVersion.getMajor(), protocolVersion.getMinor());
        this.cert = sSLCertificate;
        this.peerCertificate = sSLCertificate2 != null ? (SSLCertificate)sSLCertificate2.clone() : null;
        this.cipherSuite = s;
        this.masterSecret = symmetricKey != null ? (SymmetricKey)symmetricKey.clone() : new SymmetricKey(new byte[0]);
        this.cipherKindV2 = 0;
    }

    public Object clone() {
        SessionParams sessionParams = this.cipherKindV2 == 0 ? new SessionParams(new SessionID((byte[])this.sessionID.getID().clone()), new ProtocolVersion(this.protocolVersion.getMajor(), this.protocolVersion.getMinor()), this.cert != null ? (SSLCertificate)this.cert.clone() : null, this.peerCertificate != null ? (SSLCertificate)this.peerCertificate.clone() : null, this.cipherSuite, this.masterSecret != null ? (SymmetricKey)this.masterSecret.clone() : new SymmetricKey(new byte[0])) : new SessionParams(new SessionID((byte[])this.sessionID.getID().clone()), new ProtocolVersion(this.protocolVersion.getMajor(), this.protocolVersion.getMinor()), this.cert != null ? (SSLCertificate)this.cert.clone() : null, this.peerCertificate != null ? (SSLCertificate)this.peerCertificate.clone() : null, this.cipherKindV2, (byte[])this.initializationDataV2.clone(), this.masterSecret != null ? (SymmetricKey)this.masterSecret.clone() : new SymmetricKey(new byte[0]));
        return sessionParams;
    }

    public void erase() {
        if (this.masterSecret != null) {
            this.masterSecret.erase();
        }
    }

    public void finalize() {
        this.erase();
    }

    public SSLCertificate getCert() {
        return this.cert;
    }

    public int getCipherKindV2() {
        return this.cipherKindV2;
    }

    public short getCipherSuite() {
        return this.cipherSuite;
    }

    public byte[] getInitializationDataV2() {
        return this.initializationDataV2 != null ? (byte[])this.initializationDataV2.clone() : null;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret.getBytes();
    }

    public SymmetricKey getMasterSecretKey() {
        return (SymmetricKey)this.masterSecret.clone();
    }

    public SSLCertificate getPeerCert() {
        return this.peerCertificate != null ? (SSLCertificate)this.peerCertificate.clone() : null;
    }

    public ProtocolVersion getProtocolVersion() {
        return new ProtocolVersion(this.protocolVersion.getMajor(), this.protocolVersion.getMinor());
    }

    String getServerNameAndPort() {
        return this.serverNameAndPort;
    }

    public SessionID getSessionID() {
        return new SessionID(this.sessionID.getID());
    }

    void setExpirationDate(long l) {
        this.timeExp = new Date().getTime() + l;
    }

    void setServerNameAndPort(String string) {
        this.serverNameAndPort = string;
    }

    public String toString() {
        return "(SessionParams){sessionID={" + this.sessionID + "}, protocolVersion={" + this.protocolVersion + "}, masterSecret={" + this.masterSecret + "}, cipherSuite=" + Integer.toString(this.cipherSuite, 16) + ", cipherKindV2=" + this.cipherKindV2 + ", initializationData={" + Utils.toHexString((byte[])this.initializationDataV2) + "}, peerCertificate={" + this.peerCertificate + "}" + "}";
    }

    boolean verifyExpiration() {
        long l;
        long l2 = this.peerCertificate != null && this.peerCertificate.certificateList != null && this.peerCertificate.certificateList.size() > 0 ? (this.timeExp < (l = this.peerCertificate.getBottomCert().getNotAfterDate().getTime()) ? this.timeExp : l) : this.timeExp;
        return new Date().getTime() < l2;
    }
}

