/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.SSL;

import com.phaos.SSL.CipherSpec;
import com.phaos.SSL.Compression;
import com.phaos.SSL.ProtocolVersion;
import com.phaos.SSL.SSLCertificate;
import com.phaos.SSL.SSLCrypto;
import com.phaos.SSL.SessionID;
import com.phaos.SSL.SessionParams;
import com.phaos.crypto.SymmetricKey;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public final class SessionState {
    private boolean debug = false;
    private SSLCrypto sslCrypto;
    private SessionID sessionID;
    private SSLCertificate peerCert;
    private SSLCertificate cert;
    private Compression compressionMethod;
    private CipherSpec currentCS;
    private CipherSpec pendingCS;
    private SymmetricKey masterSecret;
    private boolean resumable;
    private boolean client;
    private PrintWriter debugOut;

    public SessionState(boolean bl, SSLCrypto sSLCrypto, boolean bl2, OutputStream outputStream) throws IOException {
        this.client = bl;
        this.sslCrypto = sSLCrypto;
        this.compressionMethod = Compression.NULL;
        this.currentCS = new CipherSpec(sSLCrypto);
        this.pendingCS = new CipherSpec(sSLCrypto);
        this.debugOut = new PrintWriter(outputStream, true);
        this.debug = bl2;
    }

    public void debug(String string) {
        this.debugOut.print(string);
    }

    public void debugln(String string) {
        this.debugOut.println(string);
    }

    public void erase() {
        if (this.sessionID != null) {
            this.sessionID.erase();
        }
        if (this.currentCS != null) {
            this.currentCS.erase();
        }
        if (this.pendingCS != null) {
            this.pendingCS.erase();
        }
        if (this.masterSecret != null) {
            this.masterSecret.erase();
        }
    }

    public SSLCertificate getCert() {
        return this.cert;
    }

    public Compression getCompressionMethod() {
        return this.compressionMethod;
    }

    public CipherSpec getCurrentCS() {
        return this.currentCS;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public SymmetricKey getMasterSecret() {
        return this.masterSecret;
    }

    public SSLCertificate getPeerCert() {
        return this.peerCert;
    }

    public CipherSpec getPendingCS() {
        return this.pendingCS;
    }

    public SessionID getSessionID() {
        return this.sessionID;
    }

    public SessionParams getSessionParams(ProtocolVersion protocolVersion) {
        return new SessionParams(this.sessionID, protocolVersion, this.cert, this.peerCert, this.currentCS.getCipherSuite(), this.masterSecret);
    }

    public boolean isClient() {
        return this.client;
    }

    public boolean isResumable() {
        return this.isResumable();
    }

    public void setCert(SSLCertificate sSLCertificate) {
        this.cert = sSLCertificate;
    }

    public void setClient(boolean bl) {
        this.client = bl;
    }

    public void setCompressionMethod(Compression compression) {
        this.compressionMethod = compression;
    }

    public void setCurrentCS(CipherSpec cipherSpec) {
        this.currentCS = cipherSpec;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDebugOutputStream(OutputStream outputStream) {
        this.debugOut = new PrintWriter(outputStream, true);
    }

    public void setMasterSecret(SymmetricKey symmetricKey) {
        this.masterSecret = symmetricKey;
    }

    public void setPeerCert(SSLCertificate sSLCertificate) {
        this.peerCert = sSLCertificate;
    }

    public void setPendingCS(CipherSpec cipherSpec) {
        this.pendingCS = cipherSpec;
    }

    public void setResumable(boolean bl) {
        this.resumable = bl;
    }

    public void setSessionID(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    public void setSessionParams(SessionParams sessionParams) throws IOException {
        if (this.sessionID != null) {
            this.sessionID.erase();
        }
        if (this.pendingCS != null) {
            this.pendingCS.erase();
        }
        if (this.masterSecret != null) {
            this.masterSecret.erase();
        }
        this.sessionID = sessionParams.getSessionID();
        this.cert = sessionParams.getCert();
        this.peerCert = sessionParams.getPeerCert();
        this.pendingCS = new CipherSpec(sessionParams.getCipherSuite(), sessionParams.getProtocolVersion(), this.sslCrypto);
        this.compressionMethod = Compression.NULL;
        this.masterSecret = sessionParams.getMasterSecretKey();
    }
}

