/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.https;

import com.phaos.SSL.SSLParams;
import com.phaos.SSL.SSLSocket;
import com.phaos.SSL.SSLTunneledSocket;
import com.phaos.https.HttpsURLConnection;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.Vector;

class HttpsRequest {
    private static final int DEFAULT_PORT = 443;
    private String host;
    private int port;
    private String headers;
    private byte[] content;
    private SSLSocket socket;
    private SSLParams params;
    private String proxyHost;
    private int proxyPort;
    private String proxyReqHeaders;
    private int httpProxyVersionMinor;
    private boolean usingProxy;
    private boolean connAlive;
    private boolean doingPipeline;
    private Vector plRequests = new Vector();
    private OutputStream sockOut;
    private boolean sentHeaders;
    private final Object receivingLock = new Object();
    private final Object sendingLock = new Object();

    public HttpsRequest(String string, int n, SSLParams sSLParams, int n2, String string2, int n3, String string3) throws IOException {
        this(string, n, sSLParams, n2, string2, n3, string3, true);
    }

    public HttpsRequest(String string, int n, SSLParams sSLParams, int n2, String string2, int n3, String string3, boolean bl) throws IOException {
        this.host = string;
        this.port = n;
        if (this.port == -1) {
            this.port = 443;
        }
        this.params = sSLParams;
        if (this.params == null) {
            this.params = new SSLParams();
        }
        this.proxyHost = string2;
        this.proxyPort = n3;
        if (this.proxyPort == -1) {
            this.proxyPort = 443;
        }
        this.proxyReqHeaders = string3;
        if (this.proxyReqHeaders == null) {
            this.proxyReqHeaders = "";
        }
        this.httpProxyVersionMinor = n2;
        this.connect(bl);
    }

    public void addPLRequest(HttpsURLConnection httpsURLConnection) {
        this.plRequests.addElement(httpsURLConnection);
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {}
    }

    public void connect(boolean bl) throws IOException {
        if (this.socket != null) {
            return;
        }
        if (this.proxyHost != null) {
            this.socket = new SSLTunneledSocket(this.host, this.port, this.proxyHost, this.proxyPort, this.proxyReqHeaders, this.params, false);
            this.usingProxy = true;
            ((SSLTunneledSocket)this.socket).setHttpProxyVersionMinor(this.httpProxyVersionMinor);
            ((SSLTunneledSocket)this.socket).connectToProxy(this.proxyReqHeaders);
            if (bl) {
                this.socket.performClientHandshake();
            }
        } else {
            this.socket = new SSLSocket(this.host, this.port, this.params, bl);
        }
    }

    public String getHost() {
        return this.host;
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public int getPLRequestCount() {
        return this.plRequests.size();
    }

    public int getPort() {
        return this.port;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyReqHeaders() {
        return this.proxyReqHeaders;
    }

    public Object getReceivingLock() {
        return this.receivingLock;
    }

    public SSLParams getSSLParams() {
        return this.params;
    }

    public Object getSendingLock() {
        return this.sendingLock;
    }

    public int getSoTimeout() throws IOException {
        if (this.socket != null) {
            return this.socket.getSoTimeout();
        }
        return -1;
    }

    public SSLSocket getSocket() {
        return this.socket;
    }

    public boolean getTcpNoDelay() throws IOException {
        if (this.socket != null) {
            return this.socket.getTcpNoDelay();
        }
        return false;
    }

    public int indexOfRequest(HttpsURLConnection httpsURLConnection) {
        return this.plRequests.indexOf(httpsURLConnection);
    }

    public boolean isConnAlive() {
        return this.connAlive;
    }

    public boolean isDoingPipeline() {
        return this.doingPipeline;
    }

    public void performHandshake() throws IOException {
        this.connect(false);
        if (!this.socket.handshakePerformed()) {
            this.socket.performClientHandshake();
        }
    }

    public void removePLRequest(int n) {
        this.plRequests.removeElementAt(n);
    }

    public void requestGetInputStream(int n) throws IOException {
        ((HttpsURLConnection)this.plRequests.elementAt(n)).getInputStream();
    }

    public void sendBody() throws IOException {
        if (!this.sentHeaders) {
            throw new ProtocolException("HTTP headers not yet sent");
        }
        if (this.content != null) {
            this.sockOut.write(this.content);
        }
        this.sockOut.flush();
        this.headers = null;
        this.content = null;
        this.sockOut = null;
        this.sentHeaders = false;
    }

    public void sendHeaders(boolean bl) throws IOException {
        if (this.sentHeaders) {
            throw new ProtocolException("HTTP headers already sent");
        }
        byte[] byArray = this.headers.getBytes();
        int n = byArray.length + (this.content != null ? this.content.length : 0);
        this.sockOut = new BufferedOutputStream(this.socket.getOutputStream(), Math.min(n, 16384));
        this.sockOut.write(byArray);
        if (bl) {
            this.sockOut.flush();
        }
        this.sentHeaders = true;
    }

    public void setConnAlive(boolean bl) {
        this.connAlive = bl;
    }

    public void setContent(byte[] byArray) {
        if (this.content != null) {
            throw new IllegalStateException("HTTP Request content already set.");
        }
        this.content = byArray;
    }

    public void setDoingPipeline(boolean bl) {
        this.doingPipeline = bl;
    }

    public void setHeaders(String string) {
        if (this.headers != null) {
            throw new IllegalStateException("HTTP Request headers already set.");
        }
        this.headers = string;
    }

    public void setSoTimeout(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal timeout value " + n);
        }
        if (this.socket != null) {
            this.socket.setSoTimeout(n);
        }
    }

    public void setTcpNoDelay(boolean bl) throws IOException {
        if (this.socket != null) {
            this.socket.setTcpNoDelay(bl);
        }
    }

    public boolean usingProxy() {
        return this.usingProxy;
    }
}

